/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiText, EuiFlyout, EuiFlyoutHeader, EuiFlyoutBody, EuiTitle, EuiSpacer } from '@elastic/eui';
import { EditorExample } from './editor_example';
export function HelpPanel(props) {
  return /*#__PURE__*/React.createElement(EuiFlyout, {
    onClose: props.onClose,
    "data-test-subj": "helpFlyout",
    size: "s"
  }, /*#__PURE__*/React.createElement(EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "m"
  }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.pageTitle",
    defaultMessage: "Help"
  })))), /*#__PURE__*/React.createElement(EuiFlyoutBody, null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    defaultMessage: "Request format",
    id: "console.helpPage.requestFormatTitle"
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.requestFormatDescription",
    defaultMessage: "You can type one or more requests in the white editor. Console understands requests in a compact format:"
  })), /*#__PURE__*/React.createElement(EditorExample, {
    panel: "help"
  }), /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommandsTitle",
    defaultMessage: "Keyboard commands"
  })), /*#__PURE__*/React.createElement(EuiSpacer, null), /*#__PURE__*/React.createElement("dl", null, /*#__PURE__*/React.createElement("dt", null, "Ctrl/Cmd + I"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.autoIndentDescription",
    defaultMessage: "Auto indent current request"
  })), /*#__PURE__*/React.createElement("dt", null, "Ctrl/Cmd + /"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.openDocumentationDescription",
    defaultMessage: "Open documentation for current request"
  })), /*#__PURE__*/React.createElement("dt", null, "Ctrl + Space"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.openAutoCompleteDescription",
    defaultMessage: "Open Auto complete (even if not typing)"
  })), /*#__PURE__*/React.createElement("dt", null, "Ctrl/Cmd + Enter"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.submitRequestDescription",
    defaultMessage: "Submit request"
  })), /*#__PURE__*/React.createElement("dt", null, "Ctrl/Cmd + Up/Down"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.jumpToPreviousNextRequestDescription",
    defaultMessage: "Jump to the previous/next request start or end."
  })), /*#__PURE__*/React.createElement("dt", null, "Ctrl/Cmd + Alt + L"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.collapseExpandCurrentScopeDescription",
    defaultMessage: "Collapse/expand current scope."
  })), /*#__PURE__*/React.createElement("dt", null, "Ctrl/Cmd + Option + 0"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.collapseAllScopesDescription",
    defaultMessage: "Collapse all scopes but the current one. Expand by adding a shift."
  })), /*#__PURE__*/React.createElement("dt", null, "Down arrow"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.switchFocusToAutoCompleteMenuDescription",
    defaultMessage: "Switch focus to auto-complete menu. Use arrows to further select a term"
  })), /*#__PURE__*/React.createElement("dt", null, "Enter/Tab"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.selectCurrentlySelectedInAutoCompleteMenuDescription",
    defaultMessage: "Select the currently selected or the top most term in auto-complete menu"
  })), /*#__PURE__*/React.createElement("dt", null, "Esc"), /*#__PURE__*/React.createElement("dd", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "console.helpPage.keyboardCommands.closeAutoCompleteMenuDescription",
    defaultMessage: "Close auto-complete menu"
  }))))));
}