function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { toMountPoint } from '../../../../plugins/kibana_react/public';
import { createAction, IncompatibleActionError } from '../../../../plugins/ui_actions/public';
import { getOverlays, getIndexPatterns } from '../services';
import { applyFiltersPopover } from '../ui/apply_filters';
import { createFiltersFromValueClickAction } from './filters/create_filters_from_value_click';
import { esFilters } from '..';
export var ACTION_VALUE_CLICK = 'ACTION_VALUE_CLICK';

function isCompatible(_x) {
  return _isCompatible.apply(this, arguments);
}

function _isCompatible() {
  _isCompatible = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(context) {
    var filters;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.prev = 0;
            _context2.next = 3;
            return createFiltersFromValueClickAction(context.data);

          case 3:
            filters = _context2.sent;
            return _context2.abrupt("return", filters.length > 0);

          case 7:
            _context2.prev = 7;
            _context2.t0 = _context2["catch"](0);
            return _context2.abrupt("return", false);

          case 10:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2, null, [[0, 7]]);
  }));
  return _isCompatible.apply(this, arguments);
}

export function valueClickAction(filterManager, timeFilter) {
  return createAction({
    type: ACTION_VALUE_CLICK,
    id: ACTION_VALUE_CLICK,
    getIconType: function getIconType() {
      return 'filter';
    },
    getDisplayName: function getDisplayName() {
      return i18n.translate('data.filter.applyFilterActionTitle', {
        defaultMessage: 'Apply filter to current view'
      });
    },
    isCompatible: isCompatible,
    execute: function () {
      var _execute = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
        var data, filters, selectedFilters, indexPatterns, filterSelectionPromise, _esFilters$extractTim, timeRangeFilter, restOfFilters;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                data = _ref.data;
                _context.next = 3;
                return isCompatible({
                  data: data
                });

              case 3:
                if (_context.sent) {
                  _context.next = 5;
                  break;
                }

                throw new IncompatibleActionError();

              case 5:
                _context.next = 7;
                return createFiltersFromValueClickAction(data);

              case 7:
                filters = _context.sent;
                selectedFilters = filters;

                if (!(filters.length > 1)) {
                  _context.next = 17;
                  break;
                }

                _context.next = 12;
                return Promise.all(filters.map(function (filter) {
                  return getIndexPatterns().get(filter.meta.index);
                }));

              case 12:
                indexPatterns = _context.sent;
                filterSelectionPromise = new Promise(function (resolve) {
                  var overlay = getOverlays().openModal(toMountPoint(applyFiltersPopover(filters, indexPatterns, function () {
                    overlay.close();
                    resolve([]);
                  }, function (filterSelection) {
                    overlay.close();
                    resolve(filterSelection);
                  })), {
                    'data-test-subj': 'selectFilterOverlay'
                  });
                });
                _context.next = 16;
                return filterSelectionPromise;

              case 16:
                selectedFilters = _context.sent;

              case 17:
                if (data.timeFieldName) {
                  _esFilters$extractTim = esFilters.extractTimeFilter(data.timeFieldName, selectedFilters), timeRangeFilter = _esFilters$extractTim.timeRangeFilter, restOfFilters = _esFilters$extractTim.restOfFilters;
                  filterManager.addFilters(restOfFilters);

                  if (timeRangeFilter) {
                    esFilters.changeTimeFilter(timeFilter, timeRangeFilter);
                  }
                } else {
                  filterManager.addFilters(selectedFilters);
                }

              case 18:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function execute(_x2) {
        return _execute.apply(this, arguments);
      }

      return execute;
    }()
  });
}