/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import { EuiTextColor } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { existsOperator, isOneOfOperator } from './filter_operators';
import { FILTERS } from '../../../../../common';
export function FilterLabel(_ref) {
  var filter = _ref.filter,
      valueLabel = _ref.valueLabel;
  var prefixText = filter.meta.negate ? " ".concat(i18n.translate('data.filter.filterBar.negatedFilterPrefix', {
    defaultMessage: 'NOT '
  })) : '';
  var prefix = filter.meta.negate && !filter.meta.disabled ? /*#__PURE__*/React.createElement(EuiTextColor, {
    color: "danger"
  }, prefixText) : prefixText;

  var getValue = function getValue(text) {
    return /*#__PURE__*/React.createElement("span", {
      className: "globalFilterLabel__value"
    }, text);
  };

  if (filter.meta.alias !== null) {
    return /*#__PURE__*/React.createElement(Fragment, null, prefix, filter.meta.alias);
  }

  switch (filter.meta.type) {
    case FILTERS.EXISTS:
      return /*#__PURE__*/React.createElement(Fragment, null, prefix, filter.meta.key, ": ", getValue("".concat(existsOperator.message)));

    case FILTERS.GEO_BOUNDING_BOX:
      return /*#__PURE__*/React.createElement(Fragment, null, prefix, filter.meta.key, ": ", getValue(valueLabel));

    case FILTERS.GEO_POLYGON:
      return /*#__PURE__*/React.createElement(Fragment, null, prefix, filter.meta.key, ": ", getValue(valueLabel));

    case FILTERS.PHRASES:
      return /*#__PURE__*/React.createElement(Fragment, null, prefix, filter.meta.key, ": ", getValue("".concat(isOneOfOperator.message, " ").concat(valueLabel)));

    case FILTERS.QUERY_STRING:
      return /*#__PURE__*/React.createElement(Fragment, null, prefix, getValue("".concat(valueLabel)));

    case FILTERS.PHRASE:
    case FILTERS.RANGE:
      return /*#__PURE__*/React.createElement(Fragment, null, prefix, filter.meta.key, ": ", getValue(valueLabel));

    default:
      return /*#__PURE__*/React.createElement(Fragment, null, prefix, getValue("".concat(JSON.stringify(filter.query) || filter.meta.value)));
  }
}