function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import dateMath from '@elastic/datemath';
import classNames from 'classnames';
import React, { useState } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiButton, EuiFlexGroup, EuiFlexItem, EuiLink, EuiSuperDatePicker, prettyDuration } from '@elastic/eui'; // @ts-ignore

import { EuiSuperUpdateButton } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { useKibana, toMountPoint } from '../../../../kibana_react/public';
import { QueryStringInput } from './query_string_input';
import { doesKueryExpressionHaveLuceneSyntaxError, UI_SETTINGS } from '../../../common';
import { getQueryLog } from '../../query';
import { NoDataPopover } from './no_data_popover';
export function QueryBarTopRow(props) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isDateRangeInvalid = _useState2[0],
      setIsDateRangeInvalid = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isQueryInputFocused = _useState4[0],
      setIsQueryInputFocused = _useState4[1];

  var kibana = useKibana();
  var _kibana$services = kibana.services,
      uiSettings = _kibana$services.uiSettings,
      notifications = _kibana$services.notifications,
      storage = _kibana$services.storage,
      appName = _kibana$services.appName,
      docLinks = _kibana$services.docLinks;
  var kueryQuerySyntaxLink = docLinks.links.query.kueryQuerySyntax;
  var queryLanguage = props.query && props.query.language;
  var persistedLog = React.useMemo(function () {
    return queryLanguage && uiSettings && storage && appName ? getQueryLog(uiSettings, storage, appName, queryLanguage) : undefined;
  }, [appName, queryLanguage, uiSettings, storage]);

  function onClickSubmitButton(event) {
    if (persistedLog && props.query) {
      persistedLog.add(props.query.query);
    }

    event.preventDefault();
    onSubmit({
      query: props.query,
      dateRange: getDateRange()
    });
  }

  function getDateRange() {
    var defaultTimeSetting = uiSettings.get('timepicker:timeDefaults');
    return {
      from: props.dateRangeFrom || defaultTimeSetting.from,
      to: props.dateRangeTo || defaultTimeSetting.to
    };
  }

  function onQueryChange(query) {
    props.onChange({
      query: query,
      dateRange: getDateRange()
    });
  }

  function onChangeQueryInputFocus(isFocused) {
    setIsQueryInputFocused(isFocused);
  }

  function onTimeChange(_ref) {
    var start = _ref.start,
        end = _ref.end,
        isInvalid = _ref.isInvalid,
        isQuickSelection = _ref.isQuickSelection;
    setIsDateRangeInvalid(isInvalid);
    var retVal = {
      query: props.query,
      dateRange: {
        from: start,
        to: end
      }
    };

    if (isQuickSelection) {
      props.onSubmit(retVal);
    } else {
      props.onChange(retVal);
    }
  }

  function onRefresh(_ref2) {
    var start = _ref2.start,
        end = _ref2.end;
    var retVal = {
      dateRange: {
        from: start,
        to: end
      }
    };

    if (props.onRefresh) {
      props.onRefresh(retVal);
    }
  }

  function onSubmit(_ref3) {
    var query = _ref3.query,
        dateRange = _ref3.dateRange;
    handleLuceneSyntaxWarning();

    if (props.timeHistory) {
      props.timeHistory.add(dateRange);
    }

    props.onSubmit({
      query: query,
      dateRange: dateRange
    });
  }

  function onInputSubmit(query) {
    onSubmit({
      query: query,
      dateRange: getDateRange()
    });
  }

  function toAbsoluteString(value) {
    var roundUp = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var valueAsMoment = dateMath.parse(value, {
      roundUp: roundUp
    });

    if (!valueAsMoment) {
      return value;
    }

    return valueAsMoment.toISOString();
  }

  function renderQueryInput() {
    if (!shouldRenderQueryInput()) return;
    return /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(QueryStringInput, {
      disableAutoFocus: props.disableAutoFocus,
      indexPatterns: props.indexPatterns,
      prepend: props.prepend,
      query: props.query,
      screenTitle: props.screenTitle,
      onChange: onQueryChange,
      onChangeQueryInputFocus: onChangeQueryInputFocus,
      onSubmit: onInputSubmit,
      persistedLog: persistedLog,
      dataTestSubj: props.dataTestSubj
    }));
  }

  function renderSharingMetaFields() {
    var _getDateRange = getDateRange(),
        from = _getDateRange.from,
        to = _getDateRange.to;

    var dateRangePretty = prettyDuration(toAbsoluteString(from), toAbsoluteString(to), [], uiSettings.get('dateFormat'));
    return /*#__PURE__*/React.createElement("div", {
      "data-shared-timefilter-duration": dateRangePretty,
      "data-test-subj": "dataSharedTimefilterDuration"
    });
  }

  function shouldRenderDatePicker() {
    return Boolean(props.showDatePicker || props.showAutoRefreshOnly);
  }

  function shouldRenderQueryInput() {
    return Boolean(props.showQueryInput && props.indexPatterns && props.query && storage);
  }

  function renderUpdateButton() {
    var button = props.customSubmitButton ? /*#__PURE__*/React.cloneElement(props.customSubmitButton, {
      onClick: onClickSubmitButton
    }) : /*#__PURE__*/React.createElement(EuiSuperUpdateButton, {
      needsUpdate: props.isDirty,
      isDisabled: isDateRangeInvalid,
      isLoading: props.isLoading,
      onClick: onClickSubmitButton,
      "data-test-subj": "querySubmitButton"
    });

    if (!shouldRenderDatePicker()) {
      return button;
    }

    return /*#__PURE__*/React.createElement(NoDataPopover, {
      storage: storage,
      showNoDataPopover: props.indicateNoData
    }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
      responsive: false,
      gutterSize: "s"
    }, renderDatePicker(), /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, button)));
  }

  function renderDatePicker() {
    if (!shouldRenderDatePicker()) {
      return null;
    }

    var recentlyUsedRanges;

    if (props.timeHistory) {
      recentlyUsedRanges = props.timeHistory.get().map(function (_ref4) {
        var from = _ref4.from,
            to = _ref4.to;
        return {
          start: from,
          end: to
        };
      });
    }

    var commonlyUsedRanges = uiSettings.get(UI_SETTINGS.TIMEPICKER_QUICK_RANGES).map(function (_ref5) {
      var from = _ref5.from,
          to = _ref5.to,
          display = _ref5.display;
      return {
        start: from,
        end: to,
        label: display
      };
    });
    var wrapperClasses = classNames('kbnQueryBar__datePickerWrapper', {
      'kbnQueryBar__datePickerWrapper-isHidden': isQueryInputFocused
    });
    return /*#__PURE__*/React.createElement(EuiFlexItem, {
      className: wrapperClasses
    }, /*#__PURE__*/React.createElement(EuiSuperDatePicker, {
      start: props.dateRangeFrom,
      end: props.dateRangeTo,
      isPaused: props.isRefreshPaused,
      refreshInterval: props.refreshInterval,
      onTimeChange: onTimeChange,
      onRefresh: onRefresh,
      onRefreshChange: props.onRefreshChange,
      showUpdateButton: false,
      recentlyUsedRanges: recentlyUsedRanges,
      commonlyUsedRanges: commonlyUsedRanges,
      dateFormat: uiSettings.get('dateFormat'),
      isAutoRefreshOnly: props.showAutoRefreshOnly,
      className: "kbnQueryBar__datePicker"
    }));
  }

  function handleLuceneSyntaxWarning() {
    if (!props.query) return;
    var _props$query = props.query,
        query = _props$query.query,
        language = _props$query.language;

    if (language === 'kuery' && typeof query === 'string' && (!storage || !storage.get('kibana.luceneSyntaxWarningOptOut')) && doesKueryExpressionHaveLuceneSyntaxError(query)) {
      var toast = notifications.toasts.addWarning({
        title: i18n.translate('data.query.queryBar.luceneSyntaxWarningTitle', {
          defaultMessage: 'Lucene syntax warning'
        }),
        text: toMountPoint( /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "data.query.queryBar.luceneSyntaxWarningMessage",
          defaultMessage: "It looks like you may be trying to use Lucene query syntax, although you have Kibana Query Language (KQL) selected. Please review the KQL docs {link}.",
          values: {
            link: /*#__PURE__*/React.createElement(EuiLink, {
              href: kueryQuerySyntaxLink,
              target: "_blank"
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "data.query.queryBar.syntaxOptionsDescription.docsLinkText",
              defaultMessage: "here"
            }))
          }
        })), /*#__PURE__*/React.createElement(EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s"
        }, /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiButton, {
          size: "s",
          onClick: function onClick() {
            return onLuceneSyntaxWarningOptOut(toast);
          }
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "data.query.queryBar.luceneSyntaxWarningOptOutText",
          defaultMessage: "Don't show again"
        }))))))
      });
    }
  }

  function onLuceneSyntaxWarningOptOut(toast) {
    if (!storage) return;
    storage.set('kibana.luceneSyntaxWarningOptOut', true);
    notifications.toasts.remove(toast);
  }

  var classes = classNames('kbnQueryBar', {
    'kbnQueryBar--withDatePicker': props.showDatePicker
  });
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    className: classes,
    responsive: !!props.showDatePicker,
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, renderQueryInput(), renderSharingMetaFields(), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, renderUpdateButton()));
}
QueryBarTopRow.defaultProps = {
  showQueryInput: true,
  showDatePicker: true,
  showAutoRefreshOnly: false
};