function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { isEqual } from 'lodash';
import { createStateContainer, createKbnUrlStateStorage, syncState } from '../../../../kibana_utils/public';
import { esFilters } from '../../../../data/public';
import { migrateLegacyQuery } from '../../../../kibana_legacy/public';
var APP_STATE_URL_KEY = '_a';
/**
 * Builds and returns appState and globalState containers and helper functions
 * Used to sync URL with UI state
 */

export function getState(_ref) {
  var _ref$defaultAppState = _ref.defaultAppState,
      defaultAppState = _ref$defaultAppState === void 0 ? {} : _ref$defaultAppState,
      _ref$storeInSessionSt = _ref.storeInSessionStorage,
      storeInSessionStorage = _ref$storeInSessionSt === void 0 ? false : _ref$storeInSessionSt,
      history = _ref.history;
  var stateStorage = createKbnUrlStateStorage({
    useHash: storeInSessionStorage,
    history: history
  });
  var appStateFromUrl = stateStorage.get(APP_STATE_URL_KEY);

  if (appStateFromUrl && appStateFromUrl.query && !appStateFromUrl.query.language) {
    appStateFromUrl.query = migrateLegacyQuery(appStateFromUrl.query);
  }

  var initialAppState = _objectSpread(_objectSpread({}, defaultAppState), appStateFromUrl);

  var previousAppState;
  var appStateContainer = createStateContainer(initialAppState);

  var appStateContainerModified = _objectSpread(_objectSpread({}, appStateContainer), {}, {
    set: function set(value) {
      if (value) {
        previousAppState = appStateContainer.getState();
        appStateContainer.set(value);
      }
    }
  });

  var _syncState = syncState({
    storageKey: APP_STATE_URL_KEY,
    stateContainer: appStateContainerModified,
    stateStorage: stateStorage
  }),
      start = _syncState.start,
      stop = _syncState.stop;

  return {
    kbnUrlStateStorage: stateStorage,
    appStateContainer: appStateContainerModified,
    startSync: start,
    stopSync: stop,
    setAppState: function setAppState(newPartial) {
      return setState(appStateContainerModified, newPartial);
    },
    replaceUrlAppState: function () {
      var _replaceUrlAppState = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var newPartial,
            state,
            _args = arguments;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                newPartial = _args.length > 0 && _args[0] !== undefined ? _args[0] : {};
                state = _objectSpread(_objectSpread({}, appStateContainer.getState()), newPartial);
                _context.next = 4;
                return stateStorage.set(APP_STATE_URL_KEY, state, {
                  replace: true
                });

              case 4:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function replaceUrlAppState() {
        return _replaceUrlAppState.apply(this, arguments);
      }

      return replaceUrlAppState;
    }(),
    resetInitialAppState: function resetInitialAppState() {
      initialAppState = appStateContainer.getState();
    },
    getPreviousAppState: function getPreviousAppState() {
      return previousAppState;
    },
    flushToUrl: function flushToUrl() {
      return stateStorage.flush();
    },
    isAppStateDirty: function isAppStateDirty() {
      return !isEqualState(initialAppState, appStateContainer.getState());
    }
  };
}
/**
 * Helper function to merge a given new state with the existing state and to set the given state
 * container
 */

export function setState(stateContainer, newState) {
  var oldState = stateContainer.getState();

  var mergedState = _objectSpread(_objectSpread({}, oldState), newState);

  if (!isEqualState(oldState, mergedState)) {
    stateContainer.set(mergedState);
  }
}
/**
 * Helper function to compare 2 different filter states
 */

export function isEqualFilters(filtersA, filtersB) {
  if (!filtersA && !filtersB) {
    return true;
  } else if (!filtersA || !filtersB) {
    return false;
  }

  return esFilters.compareFilters(filtersA, filtersB, esFilters.COMPARE_ALL_OPTIONS);
}
/**
 * helper function to extract filters of the given state
 * returns a state object without filters and an array of filters
 */

export function splitState() {
  var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var _state$filters = state.filters,
      filters = _state$filters === void 0 ? [] : _state$filters,
      statePartial = _objectWithoutProperties(state, ["filters"]);

  return {
    filters: filters,
    state: statePartial
  };
}
/**
 * Helper function to compare 2 different state, is needed since comparing filters
 * works differently
 */

export function isEqualState(stateA, stateB) {
  if (!stateA && !stateB) {
    return true;
  } else if (!stateA || !stateB) {
    return false;
  }

  var _stateA$filters = stateA.filters,
      stateAFilters = _stateA$filters === void 0 ? [] : _stateA$filters,
      stateAPartial = _objectWithoutProperties(stateA, ["filters"]);

  var _stateB$filters = stateB.filters,
      stateBFilters = _stateB$filters === void 0 ? [] : _stateB$filters,
      stateBPartial = _objectWithoutProperties(stateB, ["filters"]);

  return isEqual(stateAPartial, stateBPartial) && isEqualFilters(stateAFilters, stateBFilters);
}