function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import angular from 'angular';
import { BehaviorSubject } from 'rxjs';
import { filter, map } from 'rxjs/operators';
import { esFilters } from '../../data/public';
import { createKbnUrlTracker } from '../../kibana_utils/public';
import { DEFAULT_APP_CATEGORIES } from '../../../core/public';
import { DocViewsRegistry } from './application/doc_views/doc_views_registry';
import { DocViewTable } from './application/components/table/table';
import { JsonCodeBlock } from './application/components/json_code_block/json_code_block';
import { setDocViewsRegistry, setUrlTracker, setAngularModule, setServices, setScopedHistory, getScopedHistory, syncHistoryLocations, getServices } from './kibana_services';
import { createSavedSearchesLoader } from './saved_searches';
import { registerFeature } from './register_feature';
import { buildServices } from './build_services';
import { DISCOVER_APP_URL_GENERATOR, DiscoverUrlGenerator } from './url_generator';
import { SearchEmbeddableFactory } from './application/embeddable';
var innerAngularName = 'app/discover';
var embeddableAngularName = 'app/discoverEmbeddable';
/**
 * Contains Discover, one of the oldest parts of Kibana
 * There are 2 kinds of Angular bootstrapped for rendering, additionally to the main Angular
 * Discover provides embeddables, those contain a slimmer Angular
 */

export var DiscoverPlugin = /*#__PURE__*/function () {
  function DiscoverPlugin(initializerContext) {
    var _this = this;

    _classCallCheck(this, DiscoverPlugin);

    this.initializerContext = initializerContext;

    _defineProperty(this, "appStateUpdater", new BehaviorSubject(function () {
      return {};
    }));

    _defineProperty(this, "docViewsRegistry", null);

    _defineProperty(this, "embeddableInjector", null);

    _defineProperty(this, "stopUrlTracking", undefined);

    _defineProperty(this, "servicesInitialized", false);

    _defineProperty(this, "innerAngularInitialized", false);

    _defineProperty(this, "urlGenerator", void 0);

    _defineProperty(this, "initializeInnerAngular", void 0);

    _defineProperty(this, "initializeServices", void 0);

    _defineProperty(this, "getEmbeddableInjector", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var _yield$_this$initiali, core, plugins, _yield$import, getInnerAngularModuleEmbeddable, mountpoint;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (_this.embeddableInjector) {
                _context.next = 16;
                break;
              }

              if (_this.initializeServices) {
                _context.next = 3;
                break;
              }

              throw Error('Discover plugin getEmbeddableInjector:  initializeServices is undefined');

            case 3:
              _context.next = 5;
              return _this.initializeServices();

            case 5:
              _yield$_this$initiali = _context.sent;
              core = _yield$_this$initiali.core;
              plugins = _yield$_this$initiali.plugins;
              getServices().kibanaLegacy.loadFontAwesome();
              _context.next = 11;
              return import('./get_inner_angular');

            case 11:
              _yield$import = _context.sent;
              getInnerAngularModuleEmbeddable = _yield$import.getInnerAngularModuleEmbeddable;
              getInnerAngularModuleEmbeddable(embeddableAngularName, core, plugins, _this.initializerContext);
              mountpoint = document.createElement('div');
              _this.embeddableInjector = angular.bootstrap(mountpoint, [embeddableAngularName]);

            case 16:
              return _context.abrupt("return", _this.embeddableInjector);

            case 17:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
  }

  _createClass(DiscoverPlugin, [{
    key: "setup",
    value: function setup(core, plugins) {
      var _this2 = this;

      var baseUrl = core.http.basePath.prepend('/app/discover');

      if (plugins.share) {
        this.urlGenerator = plugins.share.urlGenerators.registerUrlGenerator(new DiscoverUrlGenerator({
          appBasePath: baseUrl,
          useHash: core.uiSettings.get('state:storeInSessionStorage')
        }));
      }

      this.docViewsRegistry = new DocViewsRegistry();
      setDocViewsRegistry(this.docViewsRegistry);
      this.docViewsRegistry.addDocView({
        title: i18n.translate('discover.docViews.table.tableTitle', {
          defaultMessage: 'Table'
        }),
        order: 10,
        component: DocViewTable
      });
      this.docViewsRegistry.addDocView({
        title: i18n.translate('discover.docViews.json.jsonTitle', {
          defaultMessage: 'JSON'
        }),
        order: 20,
        component: JsonCodeBlock
      });

      var _createKbnUrlTracker = createKbnUrlTracker({
        // we pass getter here instead of plain `history`,
        // so history is lazily created (when app is mounted)
        // this prevents redundant `#` when not in discover app
        getHistory: getScopedHistory,
        baseUrl: baseUrl,
        defaultSubUrl: '#/',
        storageKey: "lastUrl:".concat(core.http.basePath.get(), ":discover"),
        navLinkUpdater$: this.appStateUpdater,
        toastNotifications: core.notifications.toasts,
        stateParams: [{
          kbnUrlKey: '_g',
          stateUpdate$: plugins.data.query.state$.pipe(filter(function (_ref2) {
            var changes = _ref2.changes;
            return !!(changes.globalFilters || changes.time || changes.refreshInterval);
          }), map(function (_ref3) {
            var _state$filters;

            var state = _ref3.state;
            return _objectSpread(_objectSpread({}, state), {}, {
              filters: (_state$filters = state.filters) === null || _state$filters === void 0 ? void 0 : _state$filters.filter(esFilters.isFilterPinned)
            });
          }))
        }]
      }),
          appMounted = _createKbnUrlTracker.appMounted,
          appUnMounted = _createKbnUrlTracker.appUnMounted,
          stopUrlTracker = _createKbnUrlTracker.stop,
          setTrackedUrl = _createKbnUrlTracker.setActiveUrl,
          restorePreviousUrl = _createKbnUrlTracker.restorePreviousUrl;

      setUrlTracker({
        setTrackedUrl: setTrackedUrl,
        restorePreviousUrl: restorePreviousUrl
      });

      this.stopUrlTracking = function () {
        stopUrlTracker();
      };

      this.docViewsRegistry.setAngularInjectorGetter(this.getEmbeddableInjector);
      core.application.register({
        id: 'discover',
        title: 'Discover',
        updater$: this.appStateUpdater.asObservable(),
        order: -1004,
        euiIconType: 'discoverApp',
        defaultPath: '#/',
        category: DEFAULT_APP_CATEGORIES.kibana,
        mount: function () {
          var _mount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(params) {
            var _yield$_this2$initial, dataStart, _yield$import2, renderApp, unmount;

            return regeneratorRuntime.wrap(function _callee2$(_context2) {
              while (1) {
                switch (_context2.prev = _context2.next) {
                  case 0:
                    if (_this2.initializeServices) {
                      _context2.next = 2;
                      break;
                    }

                    throw Error('Discover plugin method initializeServices is undefined');

                  case 2:
                    if (_this2.initializeInnerAngular) {
                      _context2.next = 4;
                      break;
                    }

                    throw Error('Discover plugin method initializeInnerAngular is undefined');

                  case 4:
                    setScopedHistory(params.history);
                    syncHistoryLocations();
                    appMounted();
                    _context2.next = 9;
                    return _this2.initializeServices();

                  case 9:
                    _yield$_this2$initial = _context2.sent;
                    dataStart = _yield$_this2$initial.plugins.data;
                    _context2.next = 13;
                    return _this2.initializeInnerAngular();

                  case 13:
                    _context2.next = 15;
                    return dataStart.indexPatterns.clearCache();

                  case 15:
                    _context2.next = 17;
                    return import('./application/application');

                  case 17:
                    _yield$import2 = _context2.sent;
                    renderApp = _yield$import2.renderApp;
                    params.element.classList.add('dscAppWrapper');
                    _context2.next = 22;
                    return renderApp(innerAngularName, params.element);

                  case 22:
                    unmount = _context2.sent;
                    return _context2.abrupt("return", function () {
                      unmount();
                      appUnMounted();
                    });

                  case 24:
                  case "end":
                    return _context2.stop();
                }
              }
            }, _callee2);
          }));

          function mount(_x) {
            return _mount.apply(this, arguments);
          }

          return mount;
        }()
      });
      plugins.kibanaLegacy.forwardApp('doc', 'discover', function (path) {
        return "#".concat(path);
      });
      plugins.kibanaLegacy.forwardApp('context', 'discover', function (path) {
        return "#".concat(path);
      });
      plugins.kibanaLegacy.forwardApp('discover', 'discover', function (path) {
        var _ref4 = /discover\/([^\?]+)(.*)/.exec(path) || [],
            _ref5 = _slicedToArray(_ref4, 3),
            id = _ref5[1],
            tail = _ref5[2];

        if (!id) {
          return "#".concat(path.replace('/discover', '') || '/');
        }

        return "#/view/".concat(id).concat(tail || '');
      });

      if (plugins.home) {
        registerFeature(plugins.home);
      }

      this.registerEmbeddable(core, plugins);
      return {
        docViews: {
          addDocView: this.docViewsRegistry.addDocView.bind(this.docViewsRegistry)
        }
      };
    }
  }, {
    key: "start",
    value: function start(core, plugins) {
      var _this3 = this;

      // we need to register the application service at setup, but to render it
      // there are some start dependencies necessary, for this reason
      // initializeInnerAngular + initializeServices are assigned at start and used
      // when the application/embeddable is mounted
      this.initializeInnerAngular = /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        var _yield$import3, getInnerAngularModule, module;

        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                if (!_this3.innerAngularInitialized) {
                  _context3.next = 2;
                  break;
                }

                return _context3.abrupt("return");

              case 2:
                _context3.next = 4;
                return import('./get_inner_angular');

              case 4:
                _yield$import3 = _context3.sent;
                getInnerAngularModule = _yield$import3.getInnerAngularModule;
                module = getInnerAngularModule(innerAngularName, core, plugins, _this3.initializerContext);
                setAngularModule(module);
                _this3.innerAngularInitialized = true;

              case 9:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));
      this.initializeServices = /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
        var services;
        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                if (!_this3.servicesInitialized) {
                  _context4.next = 2;
                  break;
                }

                return _context4.abrupt("return", {
                  core: core,
                  plugins: plugins
                });

              case 2:
                _context4.next = 4;
                return buildServices(core, plugins, _this3.initializerContext);

              case 4:
                services = _context4.sent;
                setServices(services);
                _this3.servicesInitialized = true;
                return _context4.abrupt("return", {
                  core: core,
                  plugins: plugins
                });

              case 8:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4);
      }));
      return {
        urlGenerator: this.urlGenerator,
        savedSearchLoader: createSavedSearchesLoader({
          savedObjectsClient: core.savedObjects.client,
          indexPatterns: plugins.data.indexPatterns,
          search: plugins.data.search,
          chrome: core.chrome,
          overlays: core.overlays
        })
      };
    }
  }, {
    key: "stop",
    value: function stop() {
      if (this.stopUrlTracking) {
        this.stopUrlTracking();
      }
    }
    /**
     * register embeddable with a slimmer embeddable version of inner angular
     */

  }, {
    key: "registerEmbeddable",
    value: function registerEmbeddable(core, plugins) {
      if (!this.getEmbeddableInjector) {
        throw Error('Discover plugin method getEmbeddableInjector is undefined');
      }

      var getStartServices = /*#__PURE__*/function () {
        var _ref8 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
          var _yield$core$getStartS, _yield$core$getStartS2, coreStart, deps;

          return regeneratorRuntime.wrap(function _callee5$(_context5) {
            while (1) {
              switch (_context5.prev = _context5.next) {
                case 0:
                  _context5.next = 2;
                  return core.getStartServices();

                case 2:
                  _yield$core$getStartS = _context5.sent;
                  _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 2);
                  coreStart = _yield$core$getStartS2[0];
                  deps = _yield$core$getStartS2[1];
                  return _context5.abrupt("return", {
                    executeTriggerActions: deps.uiActions.executeTriggerActions,
                    isEditable: function isEditable() {
                      return coreStart.application.capabilities.discover.save;
                    }
                  });

                case 7:
                case "end":
                  return _context5.stop();
              }
            }
          }, _callee5);
        }));

        return function getStartServices() {
          return _ref8.apply(this, arguments);
        };
      }();

      var factory = new SearchEmbeddableFactory(getStartServices, this.getEmbeddableInjector);
      plugins.embeddable.registerEmbeddableFactory(factory.type, factory);
    }
  }]);

  return DiscoverPlugin;
}();