function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { serializeProvider, ExpressionsService } from '../common';
import { setCoreStart, setInterpreter, setRenderersRegistry, setNotifications, setExpressionsService } from './services';
import { ReactExpressionRenderer } from './react_expression_renderer';
import { ExpressionLoader, loader } from './loader';
import { render, ExpressionRenderHandler } from './render';
export var ExpressionsPublicPlugin = /*#__PURE__*/function () {
  function ExpressionsPublicPlugin(initializerContext) {
    _classCallCheck(this, ExpressionsPublicPlugin);

    _defineProperty(this, "expressions", new ExpressionsService());
  }

  _createClass(ExpressionsPublicPlugin, [{
    key: "configureExecutor",
    value: function configureExecutor(core) {
      var executor = this.expressions.executor;

      var getSavedObject = /*#__PURE__*/function () {
        var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(type, id) {
          var _yield$core$getStartS, _yield$core$getStartS2, start;

          return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 2;
                  return core.getStartServices();

                case 2:
                  _yield$core$getStartS = _context.sent;
                  _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 1);
                  start = _yield$core$getStartS2[0];
                  return _context.abrupt("return", start.savedObjects.client.get(type, id));

                case 6:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }));

        return function getSavedObject(_x, _x2) {
          return _ref.apply(this, arguments);
        };
      }();

      executor.extendContext({
        environment: 'client',
        getSavedObject: getSavedObject
      });
    }
  }, {
    key: "setup",
    value: function setup(core, _ref2) {
      var bfetch = _ref2.bfetch;
      this.configureExecutor(core);
      var expressions = this.expressions;
      var executor = expressions.executor,
          renderers = expressions.renderers;
      setRenderersRegistry(renderers);
      setExpressionsService(this.expressions);
      var expressionsSetup = expressions.setup(); // This is legacy. Should go away when we get rid of __LEGACY.

      var getExecutor = function getExecutor() {
        return {
          interpreter: {
            interpretAst: expressionsSetup.run
          }
        };
      };

      setInterpreter(getExecutor().interpreter);
      var cached = null;

      var loadLegacyServerFunctionWrappers = /*#__PURE__*/function () {
        var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
          return regeneratorRuntime.wrap(function _callee3$(_context3) {
            while (1) {
              switch (_context3.prev = _context3.next) {
                case 0:
                  if (!cached) {
                    cached = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
                      var serverFunctionList, batchedFunction, _serializeProvider, serialize;

                      return regeneratorRuntime.wrap(function _callee2$(_context2) {
                        while (1) {
                          switch (_context2.prev = _context2.next) {
                            case 0:
                              _context2.next = 2;
                              return core.http.get("/api/interpreter/fns");

                            case 2:
                              serverFunctionList = _context2.sent;
                              batchedFunction = bfetch.batchedFunction({
                                url: "/api/interpreter/fns"
                              });
                              _serializeProvider = serializeProvider(executor.getTypes()), serialize = _serializeProvider.serialize; // For every sever-side function, register a client-side
                              // function that matches its definition, but which simply
                              // calls the server-side function endpoint.

                              Object.keys(serverFunctionList).forEach(function (functionName) {
                                if (expressionsSetup.getFunction(functionName)) {
                                  return;
                                }

                                var fn = function fn() {
                                  return _objectSpread(_objectSpread({}, serverFunctionList[functionName]), {}, {
                                    fn: function fn(input, args) {
                                      return batchedFunction({
                                        functionName: functionName,
                                        args: args,
                                        context: serialize(input)
                                      });
                                    }
                                  });
                                };

                                expressionsSetup.registerFunction(fn);
                              });

                            case 6:
                            case "end":
                              return _context2.stop();
                          }
                        }
                      }, _callee2);
                    }))();
                  }

                  return _context3.abrupt("return", cached);

                case 2:
                case "end":
                  return _context3.stop();
              }
            }
          }, _callee3);
        }));

        return function loadLegacyServerFunctionWrappers() {
          return _ref3.apply(this, arguments);
        };
      }();

      var setup = _objectSpread(_objectSpread({}, expressionsSetup), {}, {
        __LEGACY: {
          types: executor.types,
          functions: executor.functions,
          renderers: renderers,
          getExecutor: getExecutor,
          loadLegacyServerFunctionWrappers: loadLegacyServerFunctionWrappers
        }
      });

      return Object.freeze(setup);
    }
  }, {
    key: "start",
    value: function start(core, _ref5) {
      var bfetch = _ref5.bfetch;
      setCoreStart(core);
      setNotifications(core.notifications);
      var expressions = this.expressions;

      var start = _objectSpread(_objectSpread({}, expressions.start()), {}, {
        ExpressionLoader: ExpressionLoader,
        ExpressionRenderHandler: ExpressionRenderHandler,
        loader: loader,
        ReactExpressionRenderer: ReactExpressionRenderer,
        render: render
      });

      return Object.freeze(start);
    }
  }, {
    key: "stop",
    value: function stop() {
      this.expressions.stop();
    }
  }]);

  return ExpressionsPublicPlugin;
}();