function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as Rx from 'rxjs';
import { filter } from 'rxjs/operators';
import { renderErrorHandler as defaultRenderErrorHandler } from './render_error_handler';
import { getRenderersRegistry } from './services';
export var ExpressionRenderHandler = function ExpressionRenderHandler(element) {
  var _this = this;

  var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
      onRenderError = _ref.onRenderError;

  _classCallCheck(this, ExpressionRenderHandler);

  _defineProperty(this, "render$", void 0);

  _defineProperty(this, "update$", void 0);

  _defineProperty(this, "events$", void 0);

  _defineProperty(this, "element", void 0);

  _defineProperty(this, "destroyFn", void 0);

  _defineProperty(this, "renderCount", 0);

  _defineProperty(this, "renderSubject", void 0);

  _defineProperty(this, "eventsSubject", void 0);

  _defineProperty(this, "updateSubject", void 0);

  _defineProperty(this, "handlers", void 0);

  _defineProperty(this, "onRenderError", void 0);

  _defineProperty(this, "render", /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(data) {
      var uiState,
          _args = arguments;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              uiState = _args.length > 1 && _args[1] !== undefined ? _args[1] : {};

              if (!(!data || _typeof(data) !== 'object')) {
                _context.next = 3;
                break;
              }

              return _context.abrupt("return", _this.handleRenderError(new Error('invalid data provided to the expression renderer')));

            case 3:
              if (!(data.type !== 'render' || !data.as)) {
                _context.next = 9;
                break;
              }

              if (!(data.type === 'error')) {
                _context.next = 8;
                break;
              }

              return _context.abrupt("return", _this.handleRenderError(data.error));

            case 8:
              return _context.abrupt("return", _this.handleRenderError(new Error('invalid data provided to the expression renderer')));

            case 9:
              if (getRenderersRegistry().get(data.as)) {
                _context.next = 11;
                break;
              }

              return _context.abrupt("return", _this.handleRenderError(new Error("invalid renderer id '".concat(data.as, "'"))));

            case 11:
              _context.prev = 11;
              _context.next = 14;
              return getRenderersRegistry().get(data.as).render(_this.element, data.value, _objectSpread(_objectSpread({}, _this.handlers), {}, {
                uiState: uiState
              }));

            case 14:
              _context.next = 19;
              break;

            case 16:
              _context.prev = 16;
              _context.t0 = _context["catch"](11);
              return _context.abrupt("return", _this.handleRenderError(_context.t0));

            case 19:
            case "end":
              return _context.stop();
          }
        }
      }, _callee, null, [[11, 16]]);
    }));

    return function (_x) {
      return _ref2.apply(this, arguments);
    };
  }());

  _defineProperty(this, "destroy", function () {
    _this.renderSubject.complete();

    _this.eventsSubject.complete();

    _this.updateSubject.complete();

    if (_this.destroyFn) {
      _this.destroyFn();
    }
  });

  _defineProperty(this, "getElement", function () {
    return _this.element;
  });

  _defineProperty(this, "handleRenderError", function (error) {
    _this.onRenderError(_this.element, error, _this.handlers);
  });

  this.element = element;
  this.eventsSubject = new Rx.Subject();
  this.events$ = this.eventsSubject.asObservable();
  this.onRenderError = onRenderError || defaultRenderErrorHandler;
  this.renderSubject = new Rx.BehaviorSubject(null);
  this.render$ = this.renderSubject.asObservable().pipe(filter(function (_) {
    return _ !== null;
  }));
  this.updateSubject = new Rx.Subject();
  this.update$ = this.updateSubject.asObservable();
  this.handlers = {
    onDestroy: function onDestroy(fn) {
      _this.destroyFn = fn;
    },
    done: function done() {
      _this.renderCount++;

      _this.renderSubject.next(_this.renderCount);
    },
    reload: function reload() {
      _this.updateSubject.next(null);
    },
    update: function update(params) {
      _this.updateSubject.next(params);
    },
    event: function event(data) {
      _this.eventsSubject.next(data);
    }
  };
};
export function render(element, data, options) {
  var handler = new ExpressionRenderHandler(element, options);
  handler.render(data);
  return handler;
}