function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiText, EuiTextColor, EuiLoadingSpinner } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
export var LoadingIndices = function LoadingIndices(_ref) {
  var rest = Object.assign({}, _ref);
  return /*#__PURE__*/React.createElement(EuiFlexGroup, _extends({
    justifyContent: "center",
    alignItems: "center"
  }, rest), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement(EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.step.loadingHeader",
    defaultMessage: "Looking for matching indices\u2026"
  }))), /*#__PURE__*/React.createElement(EuiText, {
    size: "s",
    style: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/React.createElement(EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.createIndexPattern.step.loadingLabel",
    defaultMessage: "Just a sec\u2026"
  })))));
};