function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import { createSelector } from 'reselect';
import { EuiSpacer } from '@elastic/eui';
import { AddFilter, Table, Header, DeleteFilterConfirmationModal } from './components';
export var SourceFiltersTable = /*#__PURE__*/function (_Component) {
  _inherits(SourceFiltersTable, _Component);

  var _super = _createSuper(SourceFiltersTable);

  // Source filters do not have any unique ids, only the value is stored.
  // To ensure we can create a consistent and expected UX when managing
  // source filters, we are assigning a unique id to each filter on the
  // client side only
  function SourceFiltersTable(_props) {
    var _this;

    _classCallCheck(this, SourceFiltersTable);

    _this = _super.call(this, _props);

    _defineProperty(_assertThisInitialized(_this), "clientSideId", 0);

    _defineProperty(_assertThisInitialized(_this), "updateFilters", function () {
      var sourceFilters = _this.props.indexPattern.sourceFilters;
      var filters = (sourceFilters || []).map(function (sourceFilter) {
        return _objectSpread(_objectSpread({}, sourceFilter), {}, {
          clientId: ++_this.clientSideId
        });
      });

      _this.setState({
        filters: filters
      });
    });

    _defineProperty(_assertThisInitialized(_this), "getFilteredFilters", createSelector(function (state) {
      return state.filters;
    }, function (state, props) {
      return props.filterFilter;
    }, function (filters, filterFilter) {
      if (filterFilter) {
        var filterFilterToLowercase = filterFilter.toLowerCase();
        return filters.filter(function (filter) {
          return filter.value.toLowerCase().includes(filterFilterToLowercase);
        });
      }

      return filters;
    }));

    _defineProperty(_assertThisInitialized(_this), "startDeleteFilter", function (filter) {
      _this.setState({
        filterToDelete: filter,
        isDeleteConfirmationModalVisible: true
      });
    });

    _defineProperty(_assertThisInitialized(_this), "hideDeleteConfirmationModal", function () {
      _this.setState({
        filterToDelete: undefined,
        isDeleteConfirmationModalVisible: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "deleteFilter", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var _this$props, indexPattern, onAddOrRemoveFilter, _this$state, filterToDelete, filters;

      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _this$props = _this.props, indexPattern = _this$props.indexPattern, onAddOrRemoveFilter = _this$props.onAddOrRemoveFilter;
              _this$state = _this.state, filterToDelete = _this$state.filterToDelete, filters = _this$state.filters;
              indexPattern.sourceFilters = filters.filter(function (filter) {
                return filter.clientId !== filterToDelete.clientId;
              });

              _this.setState({
                isSaving: true
              });

              _context.next = 6;
              return indexPattern.save();

            case 6:
              if (onAddOrRemoveFilter) {
                onAddOrRemoveFilter();
              }

              _this.updateFilters();

              _this.setState({
                isSaving: false
              });

              _this.hideDeleteConfirmationModal();

            case 10:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "onAddFilter", /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(value) {
        var _this$props2, indexPattern, onAddOrRemoveFilter;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _this$props2 = _this.props, indexPattern = _this$props2.indexPattern, onAddOrRemoveFilter = _this$props2.onAddOrRemoveFilter;
                indexPattern.sourceFilters = [].concat(_toConsumableArray(indexPattern.sourceFilters || []), [{
                  value: value
                }]);

                _this.setState({
                  isSaving: true
                });

                _context2.next = 5;
                return indexPattern.save();

              case 5:
                if (onAddOrRemoveFilter) {
                  onAddOrRemoveFilter();
                }

                _this.updateFilters();

                _this.setState({
                  isSaving: false
                });

              case 8:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }));

      return function (_x) {
        return _ref2.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "saveFilter", /*#__PURE__*/function () {
      var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(_ref3) {
        var clientId, value, indexPattern, filters;
        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                clientId = _ref3.clientId, value = _ref3.value;
                indexPattern = _this.props.indexPattern;
                filters = _this.state.filters;
                indexPattern.sourceFilters = filters.map(function (filter) {
                  if (filter.clientId === clientId) {
                    return {
                      value: value,
                      clientId: clientId
                    };
                  }

                  return filter;
                });

                _this.setState({
                  isSaving: true
                });

                _context3.next = 7;
                return indexPattern.save();

              case 7:
                _this.updateFilters();

                _this.setState({
                  isSaving: false
                });

              case 9:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }));

      return function (_x2) {
        return _ref4.apply(this, arguments);
      };
    }());

    _this.state = {
      filterToDelete: undefined,
      isDeleteConfirmationModalVisible: false,
      isSaving: false,
      filters: []
    };
    return _this;
  }

  _createClass(SourceFiltersTable, [{
    key: "UNSAFE_componentWillMount",
    value: function UNSAFE_componentWillMount() {
      this.updateFilters();
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
          indexPattern = _this$props3.indexPattern,
          fieldWildcardMatcher = _this$props3.fieldWildcardMatcher;
      var _this$state2 = this.state,
          isSaving = _this$state2.isSaving,
          filterToDelete = _this$state2.filterToDelete;
      var filteredFilters = this.getFilteredFilters(this.state, this.props);
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Header, null), /*#__PURE__*/React.createElement(AddFilter, {
        onAddFilter: this.onAddFilter
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "l"
      }), /*#__PURE__*/React.createElement(Table, {
        isSaving: isSaving,
        indexPattern: indexPattern,
        items: filteredFilters,
        fieldWildcardMatcher: fieldWildcardMatcher,
        deleteFilter: this.startDeleteFilter,
        saveFilter: this.saveFilter
      }), filterToDelete && /*#__PURE__*/React.createElement(DeleteFilterConfirmationModal, {
        filterToDeleteValue: filterToDelete.value,
        onCancelConfirmationModal: this.hideDeleteConfirmationModal,
        onDeleteFilter: this.deleteFilter
      }));
    }
  }]);

  return SourceFiltersTable;
}(Component);