function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useCallback, useEffect, Fragment, useMemo } from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiTabbedContent, EuiSpacer, EuiFieldSearch, EuiSelect } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { fieldWildcardMatcher } from '../../../../../kibana_utils/public';
import { UI_SETTINGS } from '../../../../../../plugins/data/public';
import { useKibana } from '../../../../../../plugins/kibana_react/public';
import { createEditIndexPatternPageStateContainer } from '../edit_index_pattern_state_container';
import { TAB_INDEXED_FIELDS, TAB_SCRIPTED_FIELDS, TAB_SOURCE_FILTERS } from '../constants';
import { SourceFiltersTable } from '../source_filters_table';
import { IndexedFieldsTable } from '../indexed_fields_table';
import { ScriptedFieldsTable } from '../scripted_fields_table';
import { getTabs, getPath, convertToEuiSelectOption } from './utils';
var searchAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.searchAria', {
  defaultMessage: 'Search fields'
});
var filterAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.fields.filterAria', {
  defaultMessage: 'Filter field types'
});
var filterPlaceholder = i18n.translate('indexPatternManagement.editIndexPattern.fields.filterPlaceholder', {
  defaultMessage: 'Search'
});
export function Tabs(_ref) {
  var indexPattern = _ref.indexPattern,
      fields = _ref.fields,
      history = _ref.history,
      location = _ref.location;
  var _useKibana$services = useKibana().services,
      uiSettings = _useKibana$services.uiSettings,
      indexPatternManagementStart = _useKibana$services.indexPatternManagementStart,
      docLinks = _useKibana$services.docLinks;

  var _useState = useState(''),
      _useState2 = _slicedToArray(_useState, 2),
      fieldFilter = _useState2[0],
      setFieldFilter = _useState2[1];

  var _useState3 = useState(''),
      _useState4 = _slicedToArray(_useState3, 2),
      indexedFieldTypeFilter = _useState4[0],
      setIndexedFieldTypeFilter = _useState4[1];

  var _useState5 = useState(''),
      _useState6 = _slicedToArray(_useState5, 2),
      scriptedFieldLanguageFilter = _useState6[0],
      setScriptedFieldLanguageFilter = _useState6[1];

  var _useState7 = useState([]),
      _useState8 = _slicedToArray(_useState7, 2),
      indexedFieldTypes = _useState8[0],
      setIndexedFieldType = _useState8[1];

  var _useState9 = useState([]),
      _useState10 = _slicedToArray(_useState9, 2),
      scriptedFieldLanguages = _useState10[0],
      setScriptedFieldLanguages = _useState10[1];

  var _useState11 = useState({
    getCurrentTab: function getCurrentTab() {
      return TAB_INDEXED_FIELDS;
    }
  }),
      _useState12 = _slicedToArray(_useState11, 2),
      syncingStateFunc = _useState12[0],
      setSyncingStateFunc = _useState12[1];

  var refreshFilters = useCallback(function () {
    var tempIndexedFieldTypes = [];
    var tempScriptedFieldLanguages = [];
    indexPattern.fields.forEach(function (field) {
      if (field.scripted) {
        if (field.lang) {
          tempScriptedFieldLanguages.push(field.lang);
        }
      } else {
        tempIndexedFieldTypes.push(field.type);
      }
    });
    setIndexedFieldType(convertToEuiSelectOption(tempIndexedFieldTypes, 'indexedFiledTypes'));
    setScriptedFieldLanguages(convertToEuiSelectOption(tempScriptedFieldLanguages, 'scriptedFieldLanguages'));
  }, [indexPattern]);
  useEffect(function () {
    refreshFilters();
  }, [indexPattern, indexPattern.fields, refreshFilters]);
  var fieldWildcardMatcherDecorated = useCallback(function (filters) {
    return fieldWildcardMatcher(filters, uiSettings.get(UI_SETTINGS.META_FIELDS));
  }, [uiSettings]);
  var getFilterSection = useCallback(function (type) {
    return /*#__PURE__*/React.createElement(EuiFlexGroup, null, /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/React.createElement(EuiFieldSearch, {
      placeholder: filterPlaceholder,
      value: fieldFilter,
      onChange: function onChange(e) {
        return setFieldFilter(e.target.value);
      },
      "data-test-subj": "indexPatternFieldFilter",
      "aria-label": searchAriaLabel
    })), type === TAB_INDEXED_FIELDS && indexedFieldTypes.length > 0 && /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiSelect, {
      options: indexedFieldTypes,
      value: indexedFieldTypeFilter,
      onChange: function onChange(e) {
        return setIndexedFieldTypeFilter(e.target.value);
      },
      "data-test-subj": "indexedFieldTypeFilterDropdown",
      "aria-label": filterAriaLabel
    })), type === TAB_SCRIPTED_FIELDS && scriptedFieldLanguages.length > 0 && /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiSelect, {
      options: scriptedFieldLanguages,
      value: scriptedFieldLanguageFilter,
      onChange: function onChange(e) {
        return setScriptedFieldLanguageFilter(e.target.value);
      },
      "data-test-subj": "scriptedFieldLanguageFilterDropdown"
    })));
  }, [fieldFilter, indexedFieldTypeFilter, indexedFieldTypes, scriptedFieldLanguageFilter, scriptedFieldLanguages]);
  var getContent = useCallback(function (type) {
    switch (type) {
      case TAB_INDEXED_FIELDS:
        return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }), getFilterSection(type), /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/React.createElement(IndexedFieldsTable, {
          fields: fields,
          indexPattern: indexPattern,
          fieldFilter: fieldFilter,
          fieldWildcardMatcher: fieldWildcardMatcherDecorated,
          indexedFieldTypeFilter: indexedFieldTypeFilter,
          helpers: {
            redirectToRoute: function redirectToRoute(field) {
              history.push(getPath(field));
            },
            getFieldInfo: indexPatternManagementStart.list.getFieldInfo
          }
        }));

      case TAB_SCRIPTED_FIELDS:
        return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }), getFilterSection(type), /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/React.createElement(ScriptedFieldsTable, {
          indexPattern: indexPattern,
          fieldFilter: fieldFilter,
          scriptedFieldLanguageFilter: scriptedFieldLanguageFilter,
          helpers: {
            redirectToRoute: function redirectToRoute(field) {
              history.push(getPath(field));
            }
          },
          onRemoveField: refreshFilters,
          painlessDocLink: docLinks.links.scriptedFields.painless
        }));

      case TAB_SOURCE_FILTERS:
        return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }), getFilterSection(type), /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/React.createElement(SourceFiltersTable, {
          indexPattern: indexPattern,
          filterFilter: fieldFilter,
          fieldWildcardMatcher: fieldWildcardMatcherDecorated,
          onAddOrRemoveFilter: refreshFilters
        }));
    }
  }, [docLinks.links.scriptedFields.painless, fieldFilter, fieldWildcardMatcherDecorated, fields, getFilterSection, history, indexPattern, indexPatternManagementStart.list.getFieldInfo, indexedFieldTypeFilter, refreshFilters, scriptedFieldLanguageFilter]);
  var euiTabs = useMemo(function () {
    return getTabs(indexPattern, fieldFilter, indexPatternManagementStart.list).map(function (tab) {
      return _objectSpread(_objectSpread({}, tab), {}, {
        content: getContent(tab.id)
      });
    });
  }, [fieldFilter, getContent, indexPattern, indexPatternManagementStart.list]);

  var _useState13 = useState(euiTabs[0].id),
      _useState14 = _slicedToArray(_useState13, 2),
      selectedTabId = _useState14[0],
      setSelectedTabId = _useState14[1];

  useEffect(function () {
    var _createEditIndexPatte = createEditIndexPatternPageStateContainer({
      useHashedUrl: uiSettings.get('state:storeInSessionStorage'),
      defaultTab: TAB_INDEXED_FIELDS
    }),
        startSyncingState = _createEditIndexPatte.startSyncingState,
        stopSyncingState = _createEditIndexPatte.stopSyncingState,
        setCurrentTab = _createEditIndexPatte.setCurrentTab,
        getCurrentTab = _createEditIndexPatte.getCurrentTab;

    startSyncingState();
    setSyncingStateFunc({
      setCurrentTab: setCurrentTab,
      getCurrentTab: getCurrentTab
    });
    setSelectedTabId(getCurrentTab());
    return function () {
      stopSyncingState();
    };
  }, [uiSettings]);
  return /*#__PURE__*/React.createElement(EuiTabbedContent, {
    tabs: euiTabs,
    selectedTab: euiTabs.find(function (tab) {
      return tab.id === selectedTabId;
    }),
    onTabClick: function onTabClick(tab) {
      setSelectedTabId(tab.id);
      syncingStateFunc.setCurrentTab(tab.id);
    }
  });
}