/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiBasicTable, EuiCode, EuiFlyout, EuiFlyoutBody, EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
export var UrlTemplateFlyout = function UrlTemplateFlyout(_ref) {
  var _ref$isVisible = _ref.isVisible,
      isVisible = _ref$isVisible === void 0 ? false : _ref$isVisible,
      _ref$onClose = _ref.onClose,
      onClose = _ref$onClose === void 0 ? function () {} : _ref$onClose;
  return isVisible ? /*#__PURE__*/React.createElement(EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/React.createElement(EuiFlyoutBody, null, /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.urlTemplateHeader",
    defaultMessage: "Url Template"
  })), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.urlTemplateLabel.fieldDetail",
    defaultMessage: "If a field only contains part of a URL then a {strongUrlTemplate} can be used to format the value as a complete URL. The format is a string which uses double curly brace notation {doubleCurlyBraces} to inject values. The following values can be accessed:",
    values: {
      doubleCurlyBraces: /*#__PURE__*/React.createElement(EuiCode, null, '{{ }}'),
      strongUrlTemplate: /*#__PURE__*/React.createElement("strong", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "indexPatternManagement.urlTemplateLabel.strongUrlTemplateLabel",
        defaultMessage: "Url Template"
      }))
    }
  })), /*#__PURE__*/React.createElement("ul", null, /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(EuiCode, null, "value"), " \u2014\xA0", /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.urlTemplate.valueLabel",
    defaultMessage: "The URI-escaped value"
  })), /*#__PURE__*/React.createElement("li", null, /*#__PURE__*/React.createElement(EuiCode, null, "rawValue"), " \u2014\xA0", /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.urlTemplate.rawValueLabel",
    defaultMessage: "The unescaped value"
  }))), /*#__PURE__*/React.createElement("h4", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "indexPatternManagement.urlTemplate.examplesHeader",
    defaultMessage: "Examples"
  })), /*#__PURE__*/React.createElement(EuiBasicTable, {
    items: [{
      input: 1234,
      template: 'http://company.net/profiles?user_id={{value}}',
      output: 'http://company.net/profiles?user_id=1234'
    }, {
      input: 'users/admin',
      template: 'http://company.net/groups?id={{value}}',
      output: 'http://company.net/groups?id=users%2Fadmin'
    }, {
      input: '/images/favicon.ico',
      template: 'http://www.site.com{{rawValue}}',
      output: 'http://www.site.com/images/favicon.ico'
    }],
    columns: [{
      field: 'input',
      name: i18n.translate('indexPatternManagement.urlTemplate.inputHeader', {
        defaultMessage: 'Input'
      }),
      width: '160px'
    }, {
      field: 'template',
      name: i18n.translate('indexPatternManagement.urlTemplate.templateHeader', {
        defaultMessage: 'Template'
      })
    }, {
      field: 'output',
      name: i18n.translate('indexPatternManagement.urlTemplate.outputHeader', {
        defaultMessage: 'Output'
      })
    }]
  })))) : null;
};