function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { IndexPatternManagementService } from './service';
var sectionsHeader = i18n.translate('indexPatternManagement.indexPattern.sectionsHeader', {
  defaultMessage: 'Index Patterns'
});
var IPM_APP_ID = 'indexPatterns';
export var IndexPatternManagementPlugin = /*#__PURE__*/function () {
  function IndexPatternManagementPlugin(initializerContext) {
    _classCallCheck(this, IndexPatternManagementPlugin);

    _defineProperty(this, "indexPatternManagementService", new IndexPatternManagementService());
  }

  _createClass(IndexPatternManagementPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var management = _ref.management,
          kibanaLegacy = _ref.kibanaLegacy;
      var kibanaSection = management.sections.section.kibana;

      if (!kibanaSection) {
        throw new Error('`kibana` management section not found.');
      }

      var newAppPath = "management/kibana/".concat(IPM_APP_ID);
      var legacyPatternsPath = 'management/kibana/index_patterns';
      kibanaLegacy.forwardApp('management/kibana/index_pattern', newAppPath, function (path) {
        return '/create';
      });
      kibanaLegacy.forwardApp(legacyPatternsPath, newAppPath, function (path) {
        var pathInApp = path.substr(legacyPatternsPath.length + 1);
        return pathInApp && "/patterns".concat(pathInApp);
      });
      kibanaSection.registerApp({
        id: IPM_APP_ID,
        title: sectionsHeader,
        order: 0,
        mount: function () {
          var _mount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(params) {
            var _yield$import, mountManagementSection;

            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return import('./management_app');

                  case 2:
                    _yield$import = _context.sent;
                    mountManagementSection = _yield$import.mountManagementSection;
                    return _context.abrupt("return", mountManagementSection(core.getStartServices, params));

                  case 5:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          function mount(_x) {
            return _mount.apply(this, arguments);
          }

          return mount;
        }()
      });
      return this.indexPatternManagementService.setup({
        httpClient: core.http
      });
    }
  }, {
    key: "start",
    value: function start(core, plugins) {
      return this.indexPatternManagementService.start();
    }
  }, {
    key: "stop",
    value: function stop() {
      this.indexPatternManagementService.stop();
    }
  }]);

  return IndexPatternManagementPlugin;
}();