function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { FormattedMessage } from '@kbn/i18n/react';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { EuiButtonEmpty, EuiContextMenuItem, EuiContextMenuPanel, EuiPopover, EuiToolTip } from '@elastic/eui';
export var InspectorViewChooser = /*#__PURE__*/function (_Component) {
  _inherits(InspectorViewChooser, _Component);

  var _super = _createSuper(InspectorViewChooser);

  function InspectorViewChooser() {
    var _this;

    _classCallCheck(this, InspectorViewChooser);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isSelectorOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "toggleSelector", function () {
      _this.setState(function (prev) {
        return {
          isSelectorOpen: !prev.isSelectorOpen
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeSelector", function () {
      _this.setState({
        isSelectorOpen: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "renderView", function (view, index) {
      return /*#__PURE__*/React.createElement(EuiContextMenuItem, {
        key: index,
        onClick: function onClick() {
          _this.props.onViewSelected(view);

          _this.closeSelector();
        },
        toolTipContent: view.help,
        toolTipPosition: "left",
        "data-test-subj": "inspectorViewChooser".concat(view.title)
      }, view.title);
    });

    return _this;
  }

  _createClass(InspectorViewChooser, [{
    key: "renderViewButton",
    value: function renderViewButton() {
      return /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        size: "s",
        iconType: "arrowDown",
        iconSide: "right",
        onClick: this.toggleSelector,
        "data-test-subj": "inspectorViewChooser"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.view",
        defaultMessage: "View: {viewName}",
        values: {
          viewName: this.props.selectedView.title
        }
      }));
    }
  }, {
    key: "renderSingleView",
    value: function renderSingleView() {
      return /*#__PURE__*/React.createElement(EuiToolTip, {
        position: "bottom",
        content: this.props.selectedView.help
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.view",
        defaultMessage: "View: {viewName}",
        values: {
          viewName: this.props.selectedView.title
        }
      }));
    }
  }, {
    key: "render",
    value: function render() {
      var views = this.props.views;

      if (views.length < 2) {
        return this.renderSingleView();
      }

      var triggerButton = this.renderViewButton();
      return /*#__PURE__*/React.createElement(EuiPopover, {
        id: "inspectorViewChooser",
        ownFocus: true,
        button: triggerButton,
        isOpen: this.state.isSelectorOpen,
        closePopover: this.closeSelector,
        panelPaddingSize: "none",
        anchorPosition: "downRight",
        repositionOnScroll: true
      }, /*#__PURE__*/React.createElement(EuiContextMenuPanel, {
        items: views.map(this.renderView)
      }));
    }
  }]);

  return InspectorViewChooser;
}(Component);

_defineProperty(InspectorViewChooser, "propTypes", {
  views: PropTypes.array.isRequired,
  onViewSelected: PropTypes.func.isRequired,
  selectedView: PropTypes.object.isRequired
});