function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { EuiButtonIcon, EuiFlexGroup, EuiFlexItem // @ts-ignore
, EuiInMemoryTable, EuiSpacer, EuiToolTip } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';
import { DataDownloadOptions } from './download_options';
import { CSV_SEPARATOR_SETTING, CSV_QUOTE_VALUES_SETTING } from '../../../../../share/public';
export var DataTableFormat = /*#__PURE__*/function (_Component) {
  _inherits(DataTableFormat, _Component);

  var _super = _createSuper(DataTableFormat);

  function DataTableFormat() {
    var _this;

    _classCallCheck(this, DataTableFormat);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "csvSeparator", _this.props.uiSettings.get(CSV_SEPARATOR_SETTING, ','));

    _defineProperty(_assertThisInitialized(_this), "quoteValues", _this.props.uiSettings.get(CSV_QUOTE_VALUES_SETTING, true));

    _defineProperty(_assertThisInitialized(_this), "state", {});

    return _this;
  }

  _createClass(DataTableFormat, [{
    key: "render",
    value: function render() {
      var _this$state = this.state,
          columns = _this$state.columns,
          rows = _this$state.rows;
      var pagination = {
        pageSizeOptions: [10, 20, 50],
        initialPageSize: 20
      };
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexGroup, null, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: true
      }), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(DataDownloadOptions, {
        isFormatted: this.props.isFormatted,
        title: this.props.exportTitle,
        csvSeparator: this.csvSeparator,
        quoteValues: this.quoteValues,
        columns: columns,
        rows: rows
      }))), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/React.createElement(EuiInMemoryTable, {
        className: "insDataTableFormat__table",
        "data-test-subj": "inspectorTable",
        columns: columns,
        items: rows,
        sorting: true,
        pagination: pagination
      }));
    }
  }], [{
    key: "renderCell",
    value: function renderCell(dataColumn, value) {
      var isFormatted = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        responsive: false,
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, isFormatted ? value.formatted : value), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        responsive: false,
        gutterSize: "none",
        alignItems: "center"
      }, dataColumn.filter && /*#__PURE__*/React.createElement(EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.data.filterForValueButtonTooltip",
          defaultMessage: "Filter for value"
        })
      }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
        iconType: "plusInCircle",
        color: "text",
        "aria-label": i18n.translate('inspector.data.filterForValueButtonAriaLabel', {
          defaultMessage: 'Filter for value'
        }),
        "data-test-subj": "filterForInspectorCellValue",
        className: "insDataTableFormat__filter",
        onClick: function onClick() {
          return dataColumn.filter(value);
        }
      })), dataColumn.filterOut && /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiToolTip, {
        position: "bottom",
        content: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.data.filterOutValueButtonTooltip",
          defaultMessage: "Filter out value"
        })
      }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
        iconType: "minusInCircle",
        color: "text",
        "aria-label": i18n.translate('inspector.data.filterOutValueButtonAriaLabel', {
          defaultMessage: 'Filter out value'
        }),
        "data-test-subj": "filterOutInspectorCellValue",
        className: "insDataTableFormat__filter",
        onClick: function onClick() {
          return dataColumn.filterOut(value);
        }
      }))))));
    }
  }, {
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref) {
      var data = _ref.data,
          isFormatted = _ref.isFormatted;

      if (!data) {
        return {
          columns: null,
          rows: null
        };
      }

      var columns = data.columns.map(function (dataColumn) {
        return {
          name: dataColumn.name,
          field: dataColumn.field,
          sortable: isFormatted ? function (row) {
            return row[dataColumn.field].raw;
          } : true,
          render: function render(value) {
            return DataTableFormat.renderCell(dataColumn, value, isFormatted);
          }
        };
      });
      return {
        columns: columns,
        rows: data.rows
      };
    }
  }]);

  return DataTableFormat;
}(Component);

_defineProperty(DataTableFormat, "propTypes", {
  data: PropTypes.object.isRequired,
  exportTitle: PropTypes.string.isRequired,
  uiSettings: PropTypes.object.isRequired,
  isFormatted: PropTypes.bool
});