function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { forOwn, keyBy, isNumber, isBoolean, isPlainObject, isString } from 'lodash';
import { castEsToKbnFieldTypeName } from '../../../data/public';
var maxRecursiveIterations = 20;
export function createFieldList(object, service) {
  var fields = Object.entries(object.attributes).reduce(function (objFields, _ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        key = _ref2[0],
        value = _ref2[1];

    return [].concat(_toConsumableArray(objFields), _toConsumableArray(createFields(key, value)));
  }, []); // Special handling for references which isn't within "attributes"

  fields = [].concat(_toConsumableArray(fields), _toConsumableArray(createFields('references', object.references)));

  if (service && service.Class) {
    addFieldsFromClass(service.Class, fields);
  }

  return fields;
}
/**
 * Creates a field definition and pushes it to the memo stack. This function
 * is designed to be used in conjunction with _.reduce(). If the
 * values is plain object it will recurse through all the keys till it hits
 * a string, number or an array.
 *
 * @param {string} key The key of the field
 * @param {mixed} value The value of the field
 * @param {array} parents The parent keys to the field
 * @returns {array}
 */

var createFields = function createFields(key, value) {
  var parents = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var path = [].concat(_toConsumableArray(parents), [key]);

  if (path.length > maxRecursiveIterations) {
    return [];
  }

  var field = {
    type: 'text',
    name: path.join('.'),
    value: value
  };

  if (isString(field.value)) {
    try {
      field.value = JSON.stringify(JSON.parse(field.value), undefined, 2);
      field.type = 'json';
    } catch (err) {
      field.type = 'text';
    }
  } else if (isNumber(field.value)) {
    field.type = 'number';
  } else if (Array.isArray(field.value)) {
    field.type = 'array';
    field.value = JSON.stringify(field.value, undefined, 2);
  } else if (isBoolean(field.value)) {
    field.type = 'boolean';
  } else if (isPlainObject(field.value)) {
    var fields = [];
    forOwn(field.value, function (childValue, childKey) {
      fields = [].concat(_toConsumableArray(fields), _toConsumableArray(createFields(childKey, childValue, path)));
    });
    return fields;
  }

  return [field];
};

var addFieldsFromClass = function addFieldsFromClass(Class, fields) {
  var fieldMap = keyBy(fields, 'name');
  forOwn(Class.mapping, function (esType, name) {
    if (!name || fieldMap[name]) {
      return;
    }

    var getFieldTypeFromEsType = function getFieldTypeFromEsType() {
      switch (castEsToKbnFieldTypeName(esType)) {
        case 'string':
          return 'text';

        case 'number':
          return 'number';

        case 'boolean':
          return 'boolean';

        default:
          return 'json';
      }
    };

    fields.push({
      name: name,
      type: getFieldTypeFromEsType(),
      value: undefined
    });
  });

  if (Class.searchSource && !fieldMap['kibanaSavedObjectMeta.searchSourceJSON']) {
    fields.push({
      name: 'kibanaSavedObjectMeta.searchSourceJSON',
      type: 'json',
      value: '{}'
    });
  }

  if (!fieldMap.references) {
    fields.push({
      name: 'references',
      type: 'array',
      value: '[]'
    });
  }
};