function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component, Fragment } from 'react';
import { take, get as getField } from 'lodash';
import { EuiFlyout, EuiFlyoutBody, EuiFlyoutFooter, EuiFlyoutHeader, EuiButtonEmpty, EuiButton, EuiText, EuiTitle, EuiForm, EuiFormRow, EuiSwitch, EuiFilePicker, EuiInMemoryTable, EuiSelect, EuiFlexGroup, EuiFlexItem, EuiLoadingKibana, EuiCallOut, EuiSpacer, EuiLink, EuiConfirmModal, EuiOverlayMask, EUI_MODAL_CONFIRM_BUTTON } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { importFile, importLegacyFile, resolveImportErrors, logLegacyImport, getDefaultTitle, processImportResponse } from '../../../lib';
import { resolveSavedObjects, resolveSavedSearches, resolveIndexPatternConflicts, saveObjects } from '../../../lib/resolve_saved_objects';
export var Flyout = /*#__PURE__*/function (_Component) {
  _inherits(Flyout, _Component);

  var _super = _createSuper(Flyout);

  function Flyout(props) {
    var _this;

    _classCallCheck(this, Flyout);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "fetchIndexPatterns", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
      var indexPatterns;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return _this.props.indexPatterns.getFields(['id', 'title']);

            case 2:
              indexPatterns = _context.sent;

              _this.setState({
                indexPatterns: indexPatterns
              });

            case 4:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));

    _defineProperty(_assertThisInitialized(_this), "changeOverwriteAll", function () {
      _this.setState(function (state) {
        return {
          isOverwriteAllChecked: !state.isOverwriteAllChecked
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "setImportFile", function (files) {
      if (!files || !files[0]) {
        _this.setState({
          file: undefined,
          isLegacyFile: false
        });

        return;
      }

      var file = files[0];

      _this.setState({
        file: file,
        isLegacyFile: /\.json$/i.test(file.name) || file.type === 'application/json'
      });
    });

    _defineProperty(_assertThisInitialized(_this), "import", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var http, _this$state, file, isOverwriteAllChecked, response;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              http = _this.props.http;
              _this$state = _this.state, file = _this$state.file, isOverwriteAllChecked = _this$state.isOverwriteAllChecked;

              _this.setState({
                status: 'loading',
                error: undefined
              }); // Import the file


              _context2.prev = 3;
              _context2.next = 6;
              return importFile(http, file, isOverwriteAllChecked);

            case 6:
              response = _context2.sent;

              _this.setState(processImportResponse(response), function () {
                var _this$state$unmatched;

                // Resolve import errors right away if there's no index patterns to match
                // This will ask about overwriting each object, etc
                if (((_this$state$unmatched = _this.state.unmatchedReferences) === null || _this$state$unmatched === void 0 ? void 0 : _this$state$unmatched.length) === 0) {
                  _this.resolveImportErrors();
                }
              });

              _context2.next = 14;
              break;

            case 10:
              _context2.prev = 10;
              _context2.t0 = _context2["catch"](3);

              _this.setState({
                status: 'error',
                error: i18n.translate('savedObjectsManagement.objectsTable.flyout.importFileErrorMessage', {
                  defaultMessage: 'The file could not be processed.'
                })
              });

              return _context2.abrupt("return");

            case 14:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, null, [[3, 10]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "getConflictResolutions", /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(objects) {
        var resolutions, _iterator, _step, _loop;

        return regeneratorRuntime.wrap(function _callee3$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                resolutions = {};
                _iterator = _createForOfIteratorHelper(objects);
                _context4.prev = 2;
                _loop = /*#__PURE__*/regeneratorRuntime.mark(function _loop() {
                  var _step$value, type, id, title, overwrite;

                  return regeneratorRuntime.wrap(function _loop$(_context3) {
                    while (1) {
                      switch (_context3.prev = _context3.next) {
                        case 0:
                          _step$value = _step.value, type = _step$value.type, id = _step$value.id, title = _step$value.title;
                          _context3.next = 3;
                          return new Promise(function (resolve) {
                            _this.setState({
                              conflictingRecord: {
                                id: id,
                                type: type,
                                title: title,
                                done: resolve
                              }
                            });
                          });

                        case 3:
                          overwrite = _context3.sent;
                          resolutions["".concat(type, ":").concat(id)] = overwrite;

                          _this.setState({
                            conflictingRecord: undefined
                          });

                        case 6:
                        case "end":
                          return _context3.stop();
                      }
                    }
                  }, _loop);
                });

                _iterator.s();

              case 5:
                if ((_step = _iterator.n()).done) {
                  _context4.next = 9;
                  break;
                }

                return _context4.delegateYield(_loop(), "t0", 7);

              case 7:
                _context4.next = 5;
                break;

              case 9:
                _context4.next = 14;
                break;

              case 11:
                _context4.prev = 11;
                _context4.t1 = _context4["catch"](2);

                _iterator.e(_context4.t1);

              case 14:
                _context4.prev = 14;

                _iterator.f();

                return _context4.finish(14);

              case 17:
                return _context4.abrupt("return", resolutions);

              case 18:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee3, null, [[2, 11, 14, 17]]);
      }));

      return function (_x) {
        return _ref3.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "resolveImportErrors", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
      var updatedState;
      return regeneratorRuntime.wrap(function _callee4$(_context5) {
        while (1) {
          switch (_context5.prev = _context5.next) {
            case 0:
              _this.setState({
                error: undefined,
                status: 'loading',
                loadingMessage: undefined
              });

              _context5.prev = 1;
              _context5.next = 4;
              return resolveImportErrors({
                http: _this.props.http,
                state: _this.state,
                getConflictResolutions: _this.getConflictResolutions
              });

            case 4:
              updatedState = _context5.sent;

              _this.setState(updatedState);

              _context5.next = 11;
              break;

            case 8:
              _context5.prev = 8;
              _context5.t0 = _context5["catch"](1);

              _this.setState({
                status: 'error',
                error: i18n.translate('savedObjectsManagement.objectsTable.flyout.resolveImportErrorsFileErrorMessage', {
                  defaultMessage: 'The file could not be processed.'
                })
              });

            case 11:
            case "end":
              return _context5.stop();
          }
        }
      }, _callee4, null, [[1, 8]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "legacyImport", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
      var _this$props, serviceRegistry, indexPatterns, overlays, http, allowedTypes, _this$state2, file, isOverwriteAllChecked, contents, _yield$resolveSavedOb, conflictedIndexPatterns, conflictedSavedObjectsLinkedToSavedSearches, conflictedSearchDocs, importedObjectCount, failedImports, byId, unmatchedReferences;

      return regeneratorRuntime.wrap(function _callee5$(_context6) {
        while (1) {
          switch (_context6.prev = _context6.next) {
            case 0:
              _this$props = _this.props, serviceRegistry = _this$props.serviceRegistry, indexPatterns = _this$props.indexPatterns, overlays = _this$props.overlays, http = _this$props.http, allowedTypes = _this$props.allowedTypes;
              _this$state2 = _this.state, file = _this$state2.file, isOverwriteAllChecked = _this$state2.isOverwriteAllChecked;

              _this.setState({
                status: 'loading',
                error: undefined
              }); // Log warning on server, don't wait for response


              logLegacyImport(http);
              _context6.prev = 4;
              _context6.next = 7;
              return importLegacyFile(file);

            case 7:
              contents = _context6.sent;
              _context6.next = 14;
              break;

            case 10:
              _context6.prev = 10;
              _context6.t0 = _context6["catch"](4);

              _this.setState({
                status: 'error',
                error: i18n.translate('savedObjectsManagement.objectsTable.flyout.importLegacyFileErrorMessage', {
                  defaultMessage: 'The file could not be processed.'
                })
              });

              return _context6.abrupt("return");

            case 14:
              if (Array.isArray(contents)) {
                _context6.next = 17;
                break;
              }

              _this.setState({
                status: 'error',
                error: i18n.translate('savedObjectsManagement.objectsTable.flyout.invalidFormatOfImportedFileErrorMessage', {
                  defaultMessage: 'Saved objects file format is invalid and cannot be imported.'
                })
              });

              return _context6.abrupt("return");

            case 17:
              contents = contents.filter(function (content) {
                return allowedTypes.includes(content._type);
              }).map(function (doc) {
                return _objectSpread(_objectSpread({}, doc), {}, {
                  // The server assumes that documents with no migrationVersion are up to date.
                  // That assumption enables Kibana and other API consumers to not have to build
                  // up migrationVersion prior to creating new objects. But it means that imports
                  // need to set migrationVersion to something other than undefined, so that imported
                  // docs are not seen as automatically up-to-date.
                  _migrationVersion: doc._migrationVersion || {}
                });
              });
              _context6.next = 20;
              return resolveSavedObjects(contents, isOverwriteAllChecked, serviceRegistry.all().map(function (e) {
                return e.service;
              }), indexPatterns, overlays.openConfirm);

            case 20:
              _yield$resolveSavedOb = _context6.sent;
              conflictedIndexPatterns = _yield$resolveSavedOb.conflictedIndexPatterns;
              conflictedSavedObjectsLinkedToSavedSearches = _yield$resolveSavedOb.conflictedSavedObjectsLinkedToSavedSearches;
              conflictedSearchDocs = _yield$resolveSavedOb.conflictedSearchDocs;
              importedObjectCount = _yield$resolveSavedOb.importedObjectCount;
              failedImports = _yield$resolveSavedOb.failedImports;
              byId = {};
              conflictedIndexPatterns.map(function (_ref6) {
                var doc = _ref6.doc,
                    obj = _ref6.obj;
                return {
                  doc: doc,
                  obj: obj._serialize()
                };
              }).forEach(function (_ref7) {
                var doc = _ref7.doc,
                    obj = _ref7.obj;
                return obj.references.forEach(function (ref) {
                  byId[ref.id] = byId[ref.id] != null ? byId[ref.id].concat({
                    doc: doc,
                    obj: obj
                  }) : [{
                    doc: doc,
                    obj: obj
                  }];
                });
              });
              unmatchedReferences = Object.entries(byId).reduce(function (accum, _ref8) {
                var _ref9 = _slicedToArray(_ref8, 2),
                    existingIndexPatternId = _ref9[0],
                    list = _ref9[1];

                accum.push({
                  existingIndexPatternId: existingIndexPatternId,
                  newIndexPatternId: undefined,
                  list: list.map(function (_ref10) {
                    var doc = _ref10.doc;
                    return {
                      id: existingIndexPatternId,
                      type: doc._type,
                      title: doc._source.title
                    };
                  })
                });
                return accum;
              }, []);

              _this.setState({
                conflictedIndexPatterns: conflictedIndexPatterns,
                conflictedSavedObjectsLinkedToSavedSearches: conflictedSavedObjectsLinkedToSavedSearches,
                conflictedSearchDocs: conflictedSearchDocs,
                failedImports: failedImports,
                unmatchedReferences: unmatchedReferences,
                importCount: importedObjectCount,
                status: unmatchedReferences.length === 0 ? 'success' : 'idle'
              });

            case 30:
            case "end":
              return _context6.stop();
          }
        }
      }, _callee5, null, [[4, 10]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "confirmLegacyImport", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
      var _this$state3, conflictedIndexPatterns, isOverwriteAllChecked, conflictedSavedObjectsLinkedToSavedSearches, conflictedSearchDocs, failedImports, _this$props2, serviceRegistry, indexPatterns, search, importCount, resolutions;

      return regeneratorRuntime.wrap(function _callee6$(_context7) {
        while (1) {
          switch (_context7.prev = _context7.next) {
            case 0:
              _this$state3 = _this.state, conflictedIndexPatterns = _this$state3.conflictedIndexPatterns, isOverwriteAllChecked = _this$state3.isOverwriteAllChecked, conflictedSavedObjectsLinkedToSavedSearches = _this$state3.conflictedSavedObjectsLinkedToSavedSearches, conflictedSearchDocs = _this$state3.conflictedSearchDocs, failedImports = _this$state3.failedImports;
              _this$props2 = _this.props, serviceRegistry = _this$props2.serviceRegistry, indexPatterns = _this$props2.indexPatterns, search = _this$props2.search;

              _this.setState({
                error: undefined,
                status: 'loading',
                loadingMessage: undefined
              });

              importCount = _this.state.importCount;

              if (!_this.hasUnmatchedReferences) {
                _context7.next = 34;
                break;
              }

              _context7.prev = 5;
              resolutions = _this.resolutions; // Do not Promise.all these calls as the order matters

              _this.setState({
                loadingMessage: i18n.translate('savedObjectsManagement.objectsTable.flyout.confirmLegacyImport.resolvingConflictsLoadingMessage', {
                  defaultMessage: 'Resolving conflicts…'
                })
              });

              if (!resolutions.length) {
                _context7.next = 13;
                break;
              }

              _context7.t0 = importCount;
              _context7.next = 12;
              return resolveIndexPatternConflicts(resolutions, conflictedIndexPatterns, isOverwriteAllChecked, {
                indexPatterns: indexPatterns,
                search: search
              });

            case 12:
              importCount = _context7.t0 += _context7.sent;

            case 13:
              _this.setState({
                loadingMessage: i18n.translate('savedObjectsManagement.objectsTable.flyout.confirmLegacyImport.savingConflictsLoadingMessage', {
                  defaultMessage: 'Saving conflicts…'
                })
              });

              _context7.t1 = importCount;
              _context7.next = 17;
              return saveObjects(conflictedSavedObjectsLinkedToSavedSearches, isOverwriteAllChecked);

            case 17:
              importCount = _context7.t1 += _context7.sent;

              _this.setState({
                loadingMessage: i18n.translate('savedObjectsManagement.objectsTable.flyout.confirmLegacyImport.savedSearchAreLinkedProperlyLoadingMessage', {
                  defaultMessage: 'Ensure saved searches are linked properly…'
                })
              });

              _context7.t2 = importCount;
              _context7.next = 22;
              return resolveSavedSearches(conflictedSearchDocs, serviceRegistry.all().map(function (e) {
                return e.service;
              }), indexPatterns, isOverwriteAllChecked);

            case 22:
              importCount = _context7.t2 += _context7.sent;

              _this.setState({
                loadingMessage: i18n.translate('savedObjectsManagement.objectsTable.flyout.confirmLegacyImport.retryingFailedObjectsLoadingMessage', {
                  defaultMessage: 'Retrying failed objects…'
                })
              });

              _context7.t3 = importCount;
              _context7.next = 27;
              return saveObjects(failedImports.map(function (_ref12) {
                var obj = _ref12.obj;
                return obj;
              }), isOverwriteAllChecked);

            case 27:
              importCount = _context7.t3 += _context7.sent;
              _context7.next = 34;
              break;

            case 30:
              _context7.prev = 30;
              _context7.t4 = _context7["catch"](5);

              _this.setState({
                error: _context7.t4.message,
                status: 'error',
                loadingMessage: undefined
              });

              return _context7.abrupt("return");

            case 34:
              _this.setState({
                status: 'success',
                importCount: importCount
              });

            case 35:
            case "end":
              return _context7.stop();
          }
        }
      }, _callee6, null, [[5, 30]]);
    })));

    _defineProperty(_assertThisInitialized(_this), "onIndexChanged", function (id, e) {
      var value = e.target.value;

      _this.setState(function (state) {
        var _state$unmatchedRefer;

        var conflictIndex = (_state$unmatchedRefer = state.unmatchedReferences) === null || _state$unmatchedRefer === void 0 ? void 0 : _state$unmatchedRefer.findIndex(function (conflict) {
          return conflict.existingIndexPatternId === id;
        });

        if (conflictIndex === undefined || conflictIndex === -1) {
          return state;
        }

        return {
          unmatchedReferences: [].concat(_toConsumableArray(state.unmatchedReferences.slice(0, conflictIndex)), [_objectSpread(_objectSpread({}, state.unmatchedReferences[conflictIndex]), {}, {
            newIndexPatternId: value
          })], _toConsumableArray(state.unmatchedReferences.slice(conflictIndex + 1)))
        };
      });
    });

    _this.state = {
      conflictedIndexPatterns: undefined,
      conflictedSavedObjectsLinkedToSavedSearches: undefined,
      conflictedSearchDocs: undefined,
      unmatchedReferences: undefined,
      conflictingRecord: undefined,
      error: undefined,
      file: undefined,
      importCount: 0,
      indexPatterns: undefined,
      isOverwriteAllChecked: true,
      loadingMessage: undefined,
      isLegacyFile: false,
      status: 'idle'
    };
    return _this;
  }

  _createClass(Flyout, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.fetchIndexPatterns();
    }
  }, {
    key: "renderUnmatchedReferences",
    value: function renderUnmatchedReferences() {
      var _this2 = this;

      var unmatchedReferences = this.state.unmatchedReferences;

      if (!unmatchedReferences) {
        return null;
      }

      var columns = [{
        field: 'existingIndexPatternId',
        name: i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnIdName', {
          defaultMessage: 'ID'
        }),
        description: i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnIdDescription', {
          defaultMessage: 'ID of the index pattern'
        }),
        sortable: true
      }, {
        field: 'list',
        name: i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnCountName', {
          defaultMessage: 'Count'
        }),
        description: i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnCountDescription', {
          defaultMessage: 'How many affected objects'
        }),
        render: function render(list) {
          return /*#__PURE__*/React.createElement(Fragment, null, list.length);
        }
      }, {
        field: 'list',
        name: i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnSampleOfAffectedObjectsName', {
          defaultMessage: 'Sample of affected objects'
        }),
        description: i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnSampleOfAffectedObjectsDescription', {
          defaultMessage: 'Sample of affected objects'
        }),
        render: function render(list) {
          return /*#__PURE__*/React.createElement("ul", {
            style: {
              listStyle: 'none'
            }
          }, take(list, 3).map(function (obj, key) {
            return /*#__PURE__*/React.createElement("li", {
              key: key
            }, obj.title);
          }));
        }
      }, {
        field: 'existingIndexPatternId',
        name: i18n.translate('savedObjectsManagement.objectsTable.flyout.renderConflicts.columnNewIndexPatternName', {
          defaultMessage: 'New index pattern'
        }),
        render: function render(id) {
          var options = _this2.state.indexPatterns.map(function (indexPattern) {
            return {
              text: indexPattern.title,
              value: indexPattern.id,
              'data-test-subj': "indexPatternOption-".concat(indexPattern.title)
            };
          });

          options.unshift({
            text: '-- Skip Import --',
            value: ''
          });
          return /*#__PURE__*/React.createElement(EuiSelect, {
            "data-test-subj": "managementChangeIndexSelection-".concat(id),
            onChange: function onChange(e) {
              return _this2.onIndexChanged(id, e);
            },
            options: options
          });
        }
      }];
      var pagination = {
        pageSizeOptions: [5, 10, 25]
      };
      return /*#__PURE__*/React.createElement(EuiInMemoryTable, {
        items: unmatchedReferences,
        columns: columns,
        pagination: pagination
      });
    }
  }, {
    key: "renderError",
    value: function renderError() {
      var _this$state4 = this.state,
          error = _this$state4.error,
          status = _this$state4.status;

      if (status !== 'error') {
        return null;
      }

      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiCallOut, {
        title: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.errorCalloutTitle",
          defaultMessage: "Sorry, there was an error"
        }),
        color: "danger"
      }, /*#__PURE__*/React.createElement("p", null, error)), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }));
    }
  }, {
    key: "renderBody",
    value: function renderBody() {
      var _this$state5 = this.state,
          status = _this$state5.status,
          loadingMessage = _this$state5.loadingMessage,
          isOverwriteAllChecked = _this$state5.isOverwriteAllChecked,
          importCount = _this$state5.importCount,
          _this$state5$failedIm = _this$state5.failedImports,
          failedImports = _this$state5$failedIm === void 0 ? [] : _this$state5$failedIm,
          isLegacyFile = _this$state5.isLegacyFile;

      if (status === 'loading') {
        return /*#__PURE__*/React.createElement(EuiFlexGroup, {
          justifyContent: "spaceAround"
        }, /*#__PURE__*/React.createElement(EuiFlexItem, {
          grow: false
        }, /*#__PURE__*/React.createElement(EuiLoadingKibana, {
          size: "xl"
        }), /*#__PURE__*/React.createElement(EuiSpacer, {
          size: "m"
        }), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("p", null, loadingMessage))));
      } // Kept backwards compatible logic


      if (failedImports.length && (!this.hasUnmatchedReferences || isLegacyFile === false && status === 'success')) {
        return /*#__PURE__*/React.createElement(EuiCallOut, {
          "data-test-subj": "importSavedObjectsFailedWarning",
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.flyout.importFailedTitle",
            defaultMessage: "Import failed"
          }),
          color: "warning",
          iconType: "help"
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.importFailedDescription",
          defaultMessage: "Failed to import {failedImportCount} of {totalImportCount} objects. Import failed",
          values: {
            failedImportCount: failedImports.length,
            totalImportCount: importCount + failedImports.length
          }
        })), /*#__PURE__*/React.createElement("p", null, failedImports.map(function (_ref13) {
          var _message;

          var error = _ref13.error,
              obj = _ref13.obj;

          if (error.type === 'missing_references') {
            return error.references.map(function (reference) {
              return i18n.translate('savedObjectsManagement.objectsTable.flyout.importFailedMissingReference', {
                defaultMessage: '{type} [id={id}] could not locate {refType} [id={refId}]',
                values: {
                  id: obj.id,
                  type: obj.type,
                  refId: reference.id,
                  refType: reference.type
                }
              });
            });
          } else if (error.type === 'unsupported_type') {
            return i18n.translate('savedObjectsManagement.objectsTable.flyout.importFailedUnsupportedType', {
              defaultMessage: '{type} [id={id}] unsupported type',
              values: {
                id: obj.id,
                type: obj.type
              }
            });
          }

          return getField(error, 'body.message', (_message = error.message) !== null && _message !== void 0 ? _message : '');
        }).join(' ')));
      }

      if (status === 'success') {
        if (importCount === 0) {
          return /*#__PURE__*/React.createElement(EuiCallOut, {
            "data-test-subj": "importSavedObjectsSuccessNoneImported",
            title: /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "savedObjectsManagement.objectsTable.flyout.importSuccessfulCallout.noObjectsImportedTitle",
              defaultMessage: "No objects imported"
            }),
            color: "primary"
          });
        }

        return /*#__PURE__*/React.createElement(EuiCallOut, {
          "data-test-subj": "importSavedObjectsSuccess",
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.flyout.importSuccessfulTitle",
            defaultMessage: "Import successful"
          }),
          color: "success",
          iconType: "check"
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.importSuccessfulDescription",
          defaultMessage: "Successfully imported {importCount} objects.",
          values: {
            importCount: importCount
          }
        })));
      }

      if (this.hasUnmatchedReferences) {
        return this.renderUnmatchedReferences();
      }

      return /*#__PURE__*/React.createElement(EuiForm, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.selectFileToImportFormRowLabel",
          defaultMessage: "Please select a file to import"
        })
      }, /*#__PURE__*/React.createElement(EuiFilePicker, {
        initialPromptText: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.importPromptText",
          defaultMessage: "Import"
        }),
        onChange: this.setImportFile
      })), /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiSwitch, {
        name: "overwriteAll",
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.overwriteSavedObjectsLabel",
          defaultMessage: "Automatically overwrite all saved objects?"
        }),
        "data-test-subj": "importSavedObjectsOverwriteToggle",
        checked: isOverwriteAllChecked,
        onChange: this.changeOverwriteAll
      })));
    }
  }, {
    key: "renderFooter",
    value: function renderFooter() {
      var status = this.state.status;
      var _this$props3 = this.props,
          done = _this$props3.done,
          close = _this$props3.close;
      var confirmButton;

      if (status === 'success') {
        confirmButton = /*#__PURE__*/React.createElement(EuiButton, {
          onClick: done,
          size: "s",
          fill: true,
          "data-test-subj": "importSavedObjectsDoneBtn"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.importSuccessful.confirmButtonLabel",
          defaultMessage: "Done"
        }));
      } else if (this.hasUnmatchedReferences) {
        confirmButton = /*#__PURE__*/React.createElement(EuiButton, {
          onClick: this.state.isLegacyFile ? this.confirmLegacyImport : this.resolveImportErrors,
          size: "s",
          fill: true,
          isLoading: status === 'loading',
          "data-test-subj": "importSavedObjectsConfirmBtn"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.importSuccessful.confirmAllChangesButtonLabel",
          defaultMessage: "Confirm all changes"
        }));
      } else {
        confirmButton = /*#__PURE__*/React.createElement(EuiButton, {
          onClick: this.state.isLegacyFile ? this.legacyImport : this.import,
          size: "s",
          fill: true,
          isLoading: status === 'loading',
          "data-test-subj": "importSavedObjectsImportBtn"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.import.confirmButtonLabel",
          defaultMessage: "Import"
        }));
      }

      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "spaceBetween"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        onClick: close,
        size: "s"
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.import.cancelButtonLabel",
        defaultMessage: "Cancel"
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, confirmButton));
    }
  }, {
    key: "renderSubheader",
    value: function renderSubheader() {
      if (this.state.status === 'loading' || this.state.status === 'success') {
        return null;
      }

      var legacyFileWarning;

      if (this.state.isLegacyFile) {
        legacyFileWarning = /*#__PURE__*/React.createElement(EuiCallOut, {
          "data-test-subj": "importSavedObjectsLegacyWarning",
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.flyout.legacyFileUsedTitle",
            defaultMessage: "Support for JSON files is going away"
          }),
          color: "warning",
          iconType: "help"
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.legacyFileUsedBody",
          defaultMessage: "Use our updated export to generate NDJSON files, and you'll be all set."
        })));
      }

      var indexPatternConflictsWarning;

      if (this.hasUnmatchedReferences) {
        indexPatternConflictsWarning = /*#__PURE__*/React.createElement(EuiCallOut, {
          "data-test-subj": "importSavedObjectsConflictsWarning",
          title: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.flyout.indexPatternConflictsTitle",
            defaultMessage: "Index Pattern Conflicts"
          }),
          color: "warning",
          iconType: "help"
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.indexPatternConflictsDescription",
          defaultMessage: "The following saved objects use index patterns that do not exist. Please select the index patterns you'd like re-associated with them. You can {indexPatternLink} if necessary.",
          values: {
            indexPatternLink: /*#__PURE__*/React.createElement(EuiLink, {
              href: this.props.newIndexPatternUrl
            }, /*#__PURE__*/React.createElement(FormattedMessage, {
              id: "savedObjectsManagement.objectsTable.flyout.indexPatternConflictsCalloutLinkText",
              defaultMessage: "create a new index pattern"
            }))
          }
        })));
      }

      if (!legacyFileWarning && !indexPatternConflictsWarning) {
        return null;
      }

      return /*#__PURE__*/React.createElement(Fragment, null, legacyFileWarning && /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), legacyFileWarning), indexPatternConflictsWarning && /*#__PURE__*/React.createElement("span", null, /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), indexPatternConflictsWarning));
    }
  }, {
    key: "overwriteConfirmed",
    value: function overwriteConfirmed() {
      this.state.conflictingRecord.done(true);
    }
  }, {
    key: "overwriteSkipped",
    value: function overwriteSkipped() {
      this.state.conflictingRecord.done(false);
    }
  }, {
    key: "render",
    value: function render() {
      var close = this.props.close;
      var confirmOverwriteModal;

      if (this.state.conflictingRecord) {
        confirmOverwriteModal = /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(EuiConfirmModal, {
          title: i18n.translate('savedObjectsManagement.objectsTable.flyout.confirmOverwriteTitle', {
            defaultMessage: 'Overwrite {type}?',
            values: {
              type: this.state.conflictingRecord.type
            }
          }),
          cancelButtonText: i18n.translate('savedObjectsManagement.objectsTable.flyout.confirmOverwriteCancelButtonText', {
            defaultMessage: 'Cancel'
          }),
          confirmButtonText: i18n.translate('savedObjectsManagement.objectsTable.flyout.confirmOverwriteOverwriteButtonText', {
            defaultMessage: 'Overwrite'
          }),
          buttonColor: "danger",
          onCancel: this.overwriteSkipped.bind(this),
          onConfirm: this.overwriteConfirmed.bind(this),
          defaultFocusedButton: EUI_MODAL_CONFIRM_BUTTON
        }, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.flyout.confirmOverwriteBody",
          defaultMessage: "Are you sure you want to overwrite {title}?",
          values: {
            title: this.state.conflictingRecord.title || getDefaultTitle(this.state.conflictingRecord)
          }
        }))));
      }

      return /*#__PURE__*/React.createElement(EuiFlyout, {
        onClose: close,
        size: "s"
      }, /*#__PURE__*/React.createElement(EuiFlyoutHeader, {
        hasBorder: true
      }, /*#__PURE__*/React.createElement(EuiTitle, {
        size: "m"
      }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.flyout.importSavedObjectTitle",
        defaultMessage: "Import saved objects"
      })))), /*#__PURE__*/React.createElement(EuiFlyoutBody, null, this.renderSubheader(), this.renderError(), this.renderBody()), /*#__PURE__*/React.createElement(EuiFlyoutFooter, null, this.renderFooter()), confirmOverwriteModal);
    }
  }, {
    key: "hasUnmatchedReferences",
    get: function get() {
      return this.state.unmatchedReferences && this.state.unmatchedReferences.length > 0;
    }
  }, {
    key: "resolutions",
    get: function get() {
      return this.state.unmatchedReferences.reduce(function (accum, _ref14) {
        var existingIndexPatternId = _ref14.existingIndexPatternId,
            newIndexPatternId = _ref14.newIndexPatternId;

        if (newIndexPatternId) {
          accum.push({
            oldId: existingIndexPatternId,
            newId: newIndexPatternId
          });
        }

        return accum;
      }, []);
    }
  }]);

  return Flyout;
}(Component);