/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect } from 'react';
import { get } from 'lodash';
import { i18n } from '@kbn/i18n';
import { SavedObjectsTable } from './objects_table';

var SavedObjectsTablePage = function SavedObjectsTablePage(_ref) {
  var coreStart = _ref.coreStart,
      dataStart = _ref.dataStart,
      allowedTypes = _ref.allowedTypes,
      serviceRegistry = _ref.serviceRegistry,
      actionRegistry = _ref.actionRegistry,
      setBreadcrumbs = _ref.setBreadcrumbs;
  var capabilities = coreStart.application.capabilities;
  var itemsPerPage = coreStart.uiSettings.get('savedObjects:perPage', 50);
  useEffect(function () {
    setBreadcrumbs([{
      text: i18n.translate('savedObjectsManagement.breadcrumb.index', {
        defaultMessage: 'Saved objects'
      }),
      href: '/'
    }]);
  }, [setBreadcrumbs]);
  return /*#__PURE__*/React.createElement(SavedObjectsTable, {
    allowedTypes: allowedTypes,
    serviceRegistry: serviceRegistry,
    actionRegistry: actionRegistry,
    savedObjectsClient: coreStart.savedObjects.client,
    indexPatterns: dataStart.indexPatterns,
    search: dataStart.search,
    http: coreStart.http,
    overlays: coreStart.overlays,
    notifications: coreStart.notifications,
    applications: coreStart.application,
    perPageConfig: itemsPerPage,
    goInspectObject: function goInspectObject(savedObject) {
      var editUrl = savedObject.meta.editUrl;

      if (editUrl) {
        return coreStart.application.navigateToUrl('/app' + editUrl);
      }
    },
    canGoInApp: function canGoInApp(savedObject) {
      var inAppUrl = savedObject.meta.inAppUrl;
      return inAppUrl ? Boolean(get(capabilities, inAppUrl.uiCapabilitiesPath)) : false;
    }
  });
}; // eslint-disable-next-line import/no-default-export


export { SavedObjectsTablePage as default };