function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiFieldText, EuiFlexItem } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { InputList } from './input_list';
import { search } from '../../../../../data/public';
var EMPTY_STRING = '';
var defaultConfig = {
  defaultValue: {
    mask: {
      model: '0.0.0.0/1',
      value: '0.0.0.0/1',
      isInvalid: false
    }
  },
  validateClass: search.aggs.CidrMask,
  getModelValue: function getModelValue() {
    var item = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return {
      mask: {
        model: item.mask || EMPTY_STRING,
        value: item.mask || EMPTY_STRING,
        isInvalid: false
      }
    };
  },
  getRemoveBtnAriaLabel: function getRemoveBtnAriaLabel(item) {
    return item.mask.value ? i18n.translate('visDefaultEditor.controls.ipRanges.removeCidrMaskButtonAriaLabel', {
      defaultMessage: 'Remove the CIDR mask value of {mask}',
      values: {
        mask: item.mask.value
      }
    }) : i18n.translate('visDefaultEditor.controls.ipRanges.removeEmptyCidrMaskButtonAriaLabel', {
      defaultMessage: 'Remove the CIDR mask default value'
    });
  },
  onChangeFn: function onChangeFn(_ref) {
    var mask = _ref.mask;

    if (mask.model) {
      return {
        mask: mask.model
      };
    }

    return {};
  },
  hasInvalidValuesFn: function hasInvalidValuesFn(_ref2) {
    var mask = _ref2.mask;
    return mask.isInvalid;
  },
  modelNames: 'mask'
};

function MaskList(_ref3) {
  var showValidation = _ref3.showValidation,
      onBlur = _ref3.onBlur,
      rest = _objectWithoutProperties(_ref3, ["showValidation", "onBlur"]);

  var renderInputRow = useCallback(function (_ref4, index, onChangeValue) {
    var mask = _ref4.mask;
    return /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFieldText, {
      "aria-label": i18n.translate('visDefaultEditor.controls.ipRanges.cidrMaskAriaLabel', {
        defaultMessage: 'CIDR mask: {mask}',
        values: {
          mask: mask.value || '*'
        }
      }),
      compressed: true,
      fullWidth: true,
      isInvalid: showValidation ? mask.isInvalid : false,
      placeholder: "*",
      onChange: function onChange(ev) {
        onChangeValue(index, ev.target.value, 'mask');
      },
      value: mask.value,
      onBlur: onBlur
    }));
  }, [onBlur, showValidation]);

  var maskListConfig = _objectSpread(_objectSpread({}, defaultConfig), {}, {
    renderInputRow: renderInputRow
  });

  return /*#__PURE__*/React.createElement(InputList, _extends({
    config: maskListConfig
  }, rest));
}

export { MaskList };