/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useCallback } from 'react';
import { EuiFieldText, EuiFormRow } from '@elastic/eui';

function StringParamEditor(_ref) {
  var agg = _ref.agg,
      aggParam = _ref.aggParam,
      showValidation = _ref.showValidation,
      value = _ref.value,
      setValidity = _ref.setValidity,
      setValue = _ref.setValue,
      setTouched = _ref.setTouched;
  var isValid = aggParam.required ? !!value : true;
  useEffect(function () {
    setValidity(isValid);
  }, [isValid, setValidity]);
  var onChange = useCallback(function (ev) {
    return setValue(ev.target.value);
  }, [setValue]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    className: "visEditorAggParam__string",
    label: aggParam.displayName || aggParam.name,
    fullWidth: true,
    compressed: true,
    isInvalid: showValidation ? !isValid : false
  }, /*#__PURE__*/React.createElement(EuiFieldText, {
    value: value || '',
    "data-test-subj": "visEditorStringInput".concat(agg.id).concat(aggParam.name),
    onChange: onChange,
    fullWidth: true,
    compressed: true,
    onBlur: setTouched,
    isInvalid: showValidation ? !isValid : false
  }));
}

export { StringParamEditor };