/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EditorStateActionTypes } from './constants';

var addNewAgg = function addNewAgg(schema) {
  return {
    type: EditorStateActionTypes.ADD_NEW_AGG,
    payload: {
      schema: schema
    }
  };
};

var discardChanges = function discardChanges(vis) {
  return {
    type: EditorStateActionTypes.DISCARD_CHANGES,
    payload: vis
  };
};

var changeAggType = function changeAggType(aggId, value) {
  return {
    type: EditorStateActionTypes.CHANGE_AGG_TYPE,
    payload: {
      aggId: aggId,
      value: value
    }
  };
};

var setAggParamValue = function setAggParamValue(aggId, paramName, value) {
  return {
    type: EditorStateActionTypes.SET_AGG_PARAM_VALUE,
    payload: {
      aggId: aggId,
      paramName: paramName,
      value: value
    }
  };
};

var setStateParamValue = function setStateParamValue(paramName, value) {
  return {
    type: EditorStateActionTypes.SET_STATE_PARAM_VALUE,
    payload: {
      paramName: paramName,
      value: value
    }
  };
};

var removeAgg = function removeAgg(aggId, schemas) {
  return {
    type: EditorStateActionTypes.REMOVE_AGG,
    payload: {
      aggId: aggId,
      schemas: schemas
    }
  };
};

var reorderAggs = function reorderAggs(sourceAgg, destinationAgg) {
  return {
    type: EditorStateActionTypes.REORDER_AGGS,
    payload: {
      sourceAgg: sourceAgg,
      destinationAgg: destinationAgg
    }
  };
};

var toggleEnabledAgg = function toggleEnabledAgg(aggId, enabled) {
  return {
    type: EditorStateActionTypes.TOGGLE_ENABLED_AGG,
    payload: {
      aggId: aggId,
      enabled: enabled
    }
  };
};

var updateStateParams = function updateStateParams(params) {
  return {
    type: EditorStateActionTypes.UPDATE_STATE_PARAMS,
    payload: {
      params: params
    }
  };
};

export { addNewAgg, discardChanges, changeAggType, setAggParamValue, setStateParamValue, removeAgg, reorderAggs, toggleEnabledAgg, updateStateParams };