function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiButtonGroup, EuiFormRow, EuiPanel, EuiSpacer, EuiTitle } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { ColorModes, ColorRanges, ColorSchemaOptions, SwitchOption, RangeOption } from '../../../charts/public';

function MetricVisOptions(_ref) {
  var stateParams = _ref.stateParams,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      setTouched = _ref.setTouched,
      vis = _ref.vis,
      uiState = _ref.uiState;
  var setMetricValue = useCallback(function (paramName, value) {
    return setValue('metric', _objectSpread(_objectSpread({}, stateParams.metric), {}, _defineProperty({}, paramName, value)));
  }, [setValue, stateParams.metric]);
  var setMetricLabels = useCallback(function (paramName, value) {
    return setMetricValue('labels', _objectSpread(_objectSpread({}, stateParams.metric.labels), {}, _defineProperty({}, paramName, value)));
  }, [setMetricValue, stateParams.metric.labels]);
  var setMetricStyle = useCallback(function (paramName, value) {
    return setMetricValue('style', _objectSpread(_objectSpread({}, stateParams.metric.style), {}, _defineProperty({}, paramName, value)));
  }, [setMetricValue, stateParams.metric.style]);
  var setColorMode = useCallback(function (id) {
    return setMetricValue('metricColorMode', id);
  }, [setMetricValue]);
  var metricColorModeLabel = i18n.translate('visTypeMetric.params.color.useForLabel', {
    defaultMessage: 'Use color for'
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeMetric.params.settingsTitle",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeMetric.params.percentageModeLabel', {
      defaultMessage: 'Percentage mode'
    }),
    paramName: "percentageMode",
    value: stateParams.metric.percentageMode,
    setValue: setMetricValue
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeMetric.params.showTitleLabel', {
      defaultMessage: 'Show title'
    }),
    paramName: "show",
    value: stateParams.metric.labels.show,
    setValue: setMetricLabels
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeMetric.params.rangesTitle",
    defaultMessage: "Ranges"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(ColorRanges, {
    "data-test-subj": "metricColorRange",
    colorsRange: stateParams.metric.colorsRange,
    setValue: setMetricValue,
    setTouched: setTouched,
    setValidity: setValidity
  }), /*#__PURE__*/React.createElement(EuiFormRow, {
    fullWidth: true,
    display: "rowCompressed",
    label: metricColorModeLabel
  }, /*#__PURE__*/React.createElement(EuiButtonGroup, {
    buttonSize: "compressed",
    idSelected: stateParams.metric.metricColorMode,
    isDisabled: stateParams.metric.colorsRange.length === 1,
    isFullWidth: true,
    legend: metricColorModeLabel,
    options: vis.type.editorConfig.collections.metricColorMode,
    onChange: setColorMode
  })), /*#__PURE__*/React.createElement(ColorSchemaOptions, {
    colorSchema: stateParams.metric.colorSchema,
    colorSchemas: vis.type.editorConfig.collections.colorSchemas,
    disabled: stateParams.metric.colorsRange.length === 1 || stateParams.metric.metricColorMode === ColorModes.NONE,
    invertColors: stateParams.metric.invertColors,
    setValue: setMetricValue,
    showHelpText: false,
    uiState: uiState
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeMetric.params.style.styleTitle",
    defaultMessage: "Style"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(RangeOption, {
    label: i18n.translate('visTypeMetric.params.style.fontSizeLabel', {
      defaultMessage: 'Metric font size in points'
    }),
    min: 12,
    max: 120,
    paramName: "fontSize",
    value: stateParams.metric.style.fontSize,
    setValue: setMetricStyle,
    showInput: true,
    showLabels: true,
    showValue: false
  })));
}

export { MetricVisOptions };