function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useEffect, useMemo, useCallback } from 'react';
import $ from 'jquery';
import moment from 'moment-timezone';
import { debounce, compact, get, each, cloneDeep, last, map } from 'lodash';
import { useKibana } from '../../../kibana_react/public';
import '../flot';
import { DEFAULT_TIME_FORMAT } from '../../common/lib';
import { buildSeriesData, buildOptions, SERIES_ID_ATTR, colors } from '../helpers/panel_utils';
import { tickFormatters } from '../helpers/tick_formatters';
import { generateTicksProvider } from '../helpers/tick_generator';
var DEBOUNCE_DELAY = 50; // ensure legend is the same height with or without a caption so legend items do not move around

var emptyCaption = '<br>';

function Panel(_ref) {
  var interval = _ref.interval,
      seriesList = _ref.seriesList,
      renderComplete = _ref.renderComplete;
  var kibana = useKibana();

  var _useState = useState(function () {
    return cloneDeep(seriesList.list);
  }),
      _useState2 = _slicedToArray(_useState, 2),
      chart = _useState2[0],
      setChart = _useState2[1];

  var _useState3 = useState(),
      _useState4 = _slicedToArray(_useState3, 2),
      canvasElem = _useState4[0],
      setCanvasElem = _useState4[1];

  var _useState5 = useState(),
      _useState6 = _slicedToArray(_useState5, 2),
      chartElem = _useState6[0],
      setChartElem = _useState6[1];

  var _useState7 = useState(function () {
    return new Map();
  }),
      _useState8 = _slicedToArray(_useState7, 2),
      originalColorMap = _useState8[0],
      setOriginalColorMap = _useState8[1];

  var _useState9 = useState(null),
      _useState10 = _slicedToArray(_useState9, 2),
      highlightedSeries = _useState10[0],
      setHighlightedSeries = _useState10[1];

  var _useState11 = useState(),
      _useState12 = _slicedToArray(_useState11, 2),
      focusedSeries = _useState12[0],
      setFocusedSeries = _useState12[1];

  var _useState13 = useState(),
      _useState14 = _slicedToArray(_useState13, 2),
      plot = _useState14[0],
      setPlot = _useState14[1]; // Used to toggle the series, and for displaying values on hover


  var _useState15 = useState(),
      _useState16 = _slicedToArray(_useState15, 2),
      legendValueNumbers = _useState16[0],
      setLegendValueNumbers = _useState16[1];

  var _useState17 = useState(),
      _useState18 = _slicedToArray(_useState17, 2),
      legendCaption = _useState18[0],
      setLegendCaption = _useState18[1];

  var canvasRef = useCallback(function (node) {
    if (node !== null) {
      setCanvasElem(node);
    }
  }, []);
  var elementRef = useCallback(function (node) {
    if (node !== null) {
      setChartElem(node);
    }
  }, []);
  useEffect(function () {
    return function () {
      if (chartElem) {
        $(chartElem).off('plotselected').off('plothover').off('mouseleave');
      }
    };
  }, [chartElem]);
  /* eslint-disable-next-line react-hooks/exhaustive-deps */

  var highlightSeries = useCallback(debounce(function (_ref2) {
    var currentTarget = _ref2.currentTarget;
    var id = Number(currentTarget.getAttribute(SERIES_ID_ATTR));

    if (highlightedSeries === id) {
      return;
    }

    setHighlightedSeries(id);
    setChart(function (chartState) {
      return chartState.map(function (series, seriesIndex) {
        series.color = seriesIndex === id ? originalColorMap.get(series) // color it like it was
        : 'rgba(128,128,128,0.1)'; // mark as grey

        return series;
      });
    });
  }, DEBOUNCE_DELAY), [originalColorMap, highlightedSeries]);
  var focusSeries = useCallback(function (event) {
    var id = Number(event.currentTarget.getAttribute(SERIES_ID_ATTR));
    setFocusedSeries(id);
    highlightSeries(event);
  }, [highlightSeries]);
  var toggleSeries = useCallback(function (_ref3) {
    var currentTarget = _ref3.currentTarget;
    var id = Number(currentTarget.getAttribute(SERIES_ID_ATTR));
    setChart(function (chartState) {
      return chartState.map(function (series, seriesIndex) {
        if (seriesIndex === id) {
          series._hide = !series._hide;
        }

        return series;
      });
    });
  }, []);
  var updateCaption = useCallback(function (plotData) {
    if (canvasElem && get(plotData, '[0]._global.legend.showTime', true)) {
      var caption = $('<caption class="timChart__legendCaption"></caption>');
      caption.html(emptyCaption);
      setLegendCaption(caption);
      var canvasNode = $(canvasElem);
      canvasNode.find('div.legend table').append(caption);
      setLegendValueNumbers(canvasNode.find('.ngLegendValueNumber'));
      var legend = $(canvasElem).find('.ngLegendValue');

      if (legend) {
        legend.click(toggleSeries);
        legend.focus(focusSeries);
        legend.mouseover(highlightSeries);
      } // legend has been re-created. Apply focus on legend element when previously set


      if (focusedSeries || focusedSeries === 0) {
        canvasNode.find('div.legend table .legendLabel>span').get(focusedSeries).focus();
      }
    }
  }, [focusedSeries, canvasElem, toggleSeries, focusSeries, highlightSeries]);
  var updatePlot = useCallback(function (chartValue, grid) {
    if (canvasElem && canvasElem.clientWidth > 0 && canvasElem.clientHeight > 0) {
      var options = buildOptions(interval, kibana.services.timefilter, kibana.services.uiSettings, chartElem && chartElem.clientWidth, grid);
      var updatedSeries = buildSeriesData(chartValue, options);

      if (options.yaxes) {
        options.yaxes.forEach(function (yaxis) {
          if (yaxis && yaxis.units) {
            var formatters = tickFormatters();
            yaxis.tickFormatter = formatters[yaxis.units.type];
            var byteModes = ['bytes', 'bytes/s'];

            if (byteModes.includes(yaxis.units.type)) {
              yaxis.tickGenerator = generateTicksProvider();
            }
          }
        });
      }

      var newPlot = $.plot($(canvasElem), updatedSeries, options);
      setPlot(newPlot);
      renderComplete();
      updateCaption(newPlot.getData());
    }
  }, [canvasElem, chartElem, renderComplete, kibana.services, interval, updateCaption]);
  useEffect(function () {
    updatePlot(chart, seriesList.render && seriesList.render.grid);
  }, [chart, updatePlot, seriesList.render]);
  useEffect(function () {
    var colorsSet = [];
    var newChart = seriesList.list.map(function (series, seriesIndex) {
      var newSeries = _objectSpread({}, series);

      if (!newSeries.color) {
        var colorIndex = seriesIndex % colors.length;
        newSeries.color = colors[colorIndex];
      }

      colorsSet.push([newSeries, newSeries.color]);
      return newSeries;
    });
    setChart(newChart);
    setOriginalColorMap(new Map(colorsSet));
  }, [seriesList.list]);
  var unhighlightSeries = useCallback(function () {
    if (highlightedSeries === null) {
      return;
    }

    setHighlightedSeries(null);
    setFocusedSeries(null);
    setChart(function (chartState) {
      return chartState.map(function (series) {
        series.color = originalColorMap.get(series); // reset the colors

        return series;
      });
    });
  }, [originalColorMap, highlightedSeries]); // Shamelessly borrowed from the flotCrosshairs example

  var setLegendNumbers = useCallback(function (pos) {
    unhighlightSeries();
    var axes = plot.getAxes();

    if (pos.x < axes.xaxis.min || pos.x > axes.xaxis.max) {
      return;
    }

    var dataset = plot.getData();

    if (legendCaption) {
      legendCaption.text(moment(pos.x).format(get(dataset, '[0]._global.legend.timeFormat', DEFAULT_TIME_FORMAT)));
    }

    var _loop = function _loop(i) {
      var series = dataset[i];
      var useNearestPoint = series.lines.show && !series.lines.steps;
      var precision = get(series, '_meta.precision', 2); // We're setting this flag on top on the series object belonging to the flot library, so we're simply casting here.

      if (series._hide) {
        return "continue";
      }

      var currentPoint = series.data.find(function (point, index) {
        if (index + 1 === series.data.length) {
          return true;
        }

        if (useNearestPoint) {
          return pos.x - point[0] < series.data[index + 1][0] - pos.x;
        } else {
          return pos.x < series.data[index + 1][0];
        }
      });
      var y = currentPoint[1];

      if (legendValueNumbers) {
        if (y == null) {
          legendValueNumbers.eq(i).empty();
        } else {
          var label = y.toFixed(precision);
          var formatter = series.yaxis.tickFormatter;

          if (formatter) {
            label = formatter(Number(label), series.yaxis);
          }

          legendValueNumbers.eq(i).text("(".concat(label, ")"));
        }
      }
    };

    for (var i = 0; i < dataset.length; ++i) {
      var _ret = _loop(i);

      if (_ret === "continue") continue;
    }
  }, [plot, legendValueNumbers, unhighlightSeries, legendCaption]);
  /* eslint-disable-next-line react-hooks/exhaustive-deps */

  var debouncedSetLegendNumbers = useCallback(debounce(setLegendNumbers, DEBOUNCE_DELAY, {
    maxWait: DEBOUNCE_DELAY,
    leading: true,
    trailing: false
  }), [setLegendNumbers]);
  var clearLegendNumbers = useCallback(function () {
    if (legendCaption) {
      legendCaption.html(emptyCaption);
    }

    each(legendValueNumbers, function (num) {
      $(num).empty();
    });
  }, [legendCaption, legendValueNumbers]);
  var plotHoverHandler = useCallback(function (event, pos) {
    if (!plot) {
      return;
    }

    plot.setCrosshair(pos);
    debouncedSetLegendNumbers(pos);
  }, [plot, debouncedSetLegendNumbers]);
  var mouseLeaveHandler = useCallback(function () {
    if (!plot) {
      return;
    }

    plot.clearCrosshair();
    clearLegendNumbers();
  }, [plot, clearLegendNumbers]);
  var plotSelectedHandler = useCallback(function (event, ranges) {
    kibana.services.timefilter.setTime({
      from: moment(ranges.xaxis.from),
      to: moment(ranges.xaxis.to)
    });
  }, [kibana.services.timefilter]);
  useEffect(function () {
    if (chartElem) {
      $(chartElem).off('plotselected').on('plotselected', plotSelectedHandler);
    }
  }, [chartElem, plotSelectedHandler]);
  useEffect(function () {
    if (chartElem) {
      $(chartElem).off('mouseleave').on('mouseleave', mouseLeaveHandler);
    }
  }, [chartElem, mouseLeaveHandler]);
  useEffect(function () {
    if (chartElem) {
      $(chartElem).off('plothover').on('plothover', plotHoverHandler);
    }
  }, [chartElem, plotHoverHandler]);
  var title = useMemo(function () {
    return last(compact(map(seriesList.list, '_title'))) || '';
  }, [seriesList.list]);
  return /*#__PURE__*/React.createElement("div", {
    ref: elementRef,
    className: "timChart"
  }, /*#__PURE__*/React.createElement("div", {
    className: "chart-top-title"
  }, title), /*#__PURE__*/React.createElement("div", {
    ref: canvasRef,
    className: "chart-canvas"
  }));
}

export { Panel };