function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { EuiColorPicker, EuiFormRow, EuiPanel, EuiSpacer, EuiTitle } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { SwitchOption } from '../../../../../charts/public';
var VERTICAL_ROTATION = 270;

function LabelsPanel(_ref) {
  var valueAxis = _ref.valueAxis,
      setValue = _ref.setValue;
  var rotateLabels = valueAxis.labels.rotate === VERTICAL_ROTATION;
  var setValueAxisLabels = useCallback(function (paramName, value) {
    return setValue('valueAxes', [_objectSpread(_objectSpread({}, valueAxis), {}, {
      labels: _objectSpread(_objectSpread({}, valueAxis.labels), {}, _defineProperty({}, paramName, value))
    })]);
  }, [valueAxis, setValue]);
  var setRotateLabels = useCallback(function (paramName, value) {
    return setValueAxisLabels(paramName, value ? VERTICAL_ROTATION : 0);
  }, [setValueAxisLabels]);
  var setColor = useCallback(function (value) {
    return setValueAxisLabels('color', value);
  }, [setValueAxisLabels]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.controls.heatmapOptions.labelsTitle",
    defaultMessage: "Labels"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.showLabelsTitle', {
      defaultMessage: 'Show labels'
    }),
    paramName: "show",
    value: valueAxis.labels.show,
    setValue: setValueAxisLabels
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    disabled: !valueAxis.labels.show,
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.rotateLabel', {
      defaultMessage: 'Rotate'
    }),
    paramName: "rotate",
    value: rotateLabels,
    setValue: setRotateLabels
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    disabled: !valueAxis.labels.show,
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.overwriteAutomaticColorLabel', {
      defaultMessage: 'Overwrite automatic color'
    }),
    paramName: "overwriteColor",
    value: valueAxis.labels.overwriteColor,
    setValue: setValueAxisLabels
  }), /*#__PURE__*/React.createElement(EuiFormRow, {
    display: "rowCompressed",
    fullWidth: true,
    label: i18n.translate('visTypeVislib.controls.heatmapOptions.colorLabel', {
      defaultMessage: 'Color'
    })
  }, /*#__PURE__*/React.createElement(EuiColorPicker, {
    compressed: true,
    fullWidth: true,
    disabled: !valueAxis.labels.show || !valueAxis.labels.overwriteColor,
    color: valueAxis.labels.color,
    onChange: setColor
  })));
}

export { LabelsPanel };