function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo, useEffect, useCallback } from 'react';
import { EuiPanel, EuiTitle, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { SelectOption, SwitchOption } from '../../../../../charts/public';

function GridPanel(_ref) {
  var stateParams = _ref.stateParams,
      setValue = _ref.setValue,
      hasHistogramAgg = _ref.hasHistogramAgg;
  var setGrid = useCallback(function (paramName, value) {
    return setValue('grid', _objectSpread(_objectSpread({}, stateParams.grid), {}, _defineProperty({}, paramName, value)));
  }, [stateParams.grid, setValue]);
  var options = useMemo(function () {
    return [].concat(_toConsumableArray(stateParams.valueAxes.map(function (_ref2) {
      var id = _ref2.id,
          name = _ref2.name;
      return {
        text: name,
        value: id
      };
    })), [{
      text: i18n.translate('visTypeVislib.controls.pointSeries.gridAxis.dontShowLabel', {
        defaultMessage: "Don't show"
      }),
      value: ''
    }]);
  }, [stateParams.valueAxes]);
  useEffect(function () {
    if (hasHistogramAgg) {
      setGrid('categoryLines', false);
    }
  }, [hasHistogramAgg, setGrid]);
  return /*#__PURE__*/React.createElement(EuiPanel, {
    paddingSize: "s"
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/React.createElement("h3", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeVislib.controls.pointSeries.gridAxis.gridText",
    defaultMessage: "Grid"
  }))), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(SwitchOption, {
    disabled: hasHistogramAgg,
    label: i18n.translate('visTypeVislib.controls.pointSeries.gridAxis.xAxisLinesLabel', {
      defaultMessage: 'Show X-axis lines'
    }),
    paramName: "categoryLines",
    tooltip: hasHistogramAgg ? i18n.translate('visTypeVislib.controls.pointSeries.gridAxis.yAxisLinesDisabledTooltip', {
      defaultMessage: "X-axis lines can't show for histograms."
    }) : undefined,
    value: stateParams.grid.categoryLines,
    setValue: setGrid,
    "data-test-subj": "showCategoryLines"
  }), /*#__PURE__*/React.createElement(SelectOption, {
    id: "gridAxis",
    label: i18n.translate('visTypeVislib.controls.pointSeries.gridAxis.yAxisLinesLabel', {
      defaultMessage: 'Y-axis lines'
    }),
    options: options,
    paramName: "valueAxis",
    value: stateParams.grid.valueAxis || '',
    setValue: setGrid
  }));
}

export { GridPanel };