/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiSpacer, EuiText, EuiTitle } from '@elastic/eui';
export var VisHelpText = function VisHelpText(_ref) {
  var name = _ref.name,
      title = _ref.title,
      description = _ref.description,
      highlightMsg = _ref.highlightMsg;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "s"
  }, /*#__PURE__*/React.createElement("h2", null, title)), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement("div", {
    id: "visTypeDescription-".concat(name)
  }, /*#__PURE__*/React.createElement(EuiText, null, highlightMsg && /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement("em", null, highlightMsg)), /*#__PURE__*/React.createElement("p", null, description))));
};