function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import './visualize_editor.scss';
import React, { useEffect, useState } from 'react';
import { useParams } from 'react-router-dom';
import { EventEmitter } from 'events';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiScreenReaderOnly } from '@elastic/eui';
import { useKibana } from '../../../../kibana_react/public';
import { useChromeVisibility, useSavedVisInstance, useVisualizeAppState, useEditorUpdates, useLinkedSearchUpdates } from '../utils';
import { ExperimentalVisInfo } from './experimental_vis_info';
import { VisualizeTopNav } from './visualize_top_nav';
export var VisualizeEditor = function VisualizeEditor() {
  var _savedVisInstance$vis, _savedVisInstance$vis2;

  var _useParams = useParams(),
      visualizationIdFromUrl = _useParams.id;

  var _useState = useState(),
      _useState2 = _slicedToArray(_useState, 2),
      originatingApp = _useState2[0],
      setOriginatingApp = _useState2[1];

  var _useKibana = useKibana(),
      services = _useKibana.services;

  var _useState3 = useState(new EventEmitter()),
      _useState4 = _slicedToArray(_useState3, 1),
      eventEmitter = _useState4[0];

  var _useState5 = useState(!visualizationIdFromUrl),
      _useState6 = _slicedToArray(_useState5, 2),
      hasUnsavedChanges = _useState6[0],
      setHasUnsavedChanges = _useState6[1];

  var isChromeVisible = useChromeVisibility(services.chrome);

  var _useSavedVisInstance = useSavedVisInstance(services, eventEmitter, isChromeVisible, visualizationIdFromUrl),
      savedVisInstance = _useSavedVisInstance.savedVisInstance,
      visEditorRef = _useSavedVisInstance.visEditorRef,
      visEditorController = _useSavedVisInstance.visEditorController;

  var _useVisualizeAppState = useVisualizeAppState(services, eventEmitter, savedVisInstance),
      appState = _useVisualizeAppState.appState,
      hasUnappliedChanges = _useVisualizeAppState.hasUnappliedChanges;

  var _useEditorUpdates = useEditorUpdates(services, eventEmitter, setHasUnsavedChanges, appState, savedVisInstance, visEditorController),
      isEmbeddableRendered = _useEditorUpdates.isEmbeddableRendered,
      currentAppState = _useEditorUpdates.currentAppState;

  useLinkedSearchUpdates(services, eventEmitter, appState, savedVisInstance);
  useEffect(function () {
    var _ref = services.embeddable.getStateTransfer(services.scopedHistory).getIncomingEditorState() || {},
        value = _ref.originatingApp;

    setOriginatingApp(value);
  }, [services]);
  useEffect(function () {
    // clean up all registered listeners if any is left
    return function () {
      eventEmitter.removeAllListeners();
    };
  }, [eventEmitter]);
  return /*#__PURE__*/React.createElement("div", {
    className: "app-container visEditor visEditor--".concat(savedVisInstance === null || savedVisInstance === void 0 ? void 0 : savedVisInstance.vis.type.name)
  }, savedVisInstance && appState && currentAppState && /*#__PURE__*/React.createElement(VisualizeTopNav, {
    currentAppState: currentAppState,
    hasUnsavedChanges: hasUnsavedChanges,
    setHasUnsavedChanges: setHasUnsavedChanges,
    isChromeVisible: isChromeVisible,
    isEmbeddableRendered: isEmbeddableRendered,
    hasUnappliedChanges: hasUnappliedChanges,
    originatingApp: originatingApp,
    setOriginatingApp: setOriginatingApp,
    savedVisInstance: savedVisInstance,
    stateContainer: appState,
    visualizationIdFromUrl: visualizationIdFromUrl
  }), (savedVisInstance === null || savedVisInstance === void 0 ? void 0 : (_savedVisInstance$vis = savedVisInstance.vis) === null || _savedVisInstance$vis === void 0 ? void 0 : (_savedVisInstance$vis2 = _savedVisInstance$vis.type) === null || _savedVisInstance$vis2 === void 0 ? void 0 : _savedVisInstance$vis2.isExperimental) && /*#__PURE__*/React.createElement(ExperimentalVisInfo, null), savedVisInstance && /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("h1", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visualize.pageHeading",
    defaultMessage: "{chartName} {chartType} visualization",
    values: {
      chartName: savedVisInstance.savedVis.title,
      chartType: savedVisInstance.vis.type.title
    }
  }))), /*#__PURE__*/React.createElement("div", {
    className: isChromeVisible ? 'visEditor__content' : 'visualize',
    ref: visEditorRef
  }));
};