/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect } from 'react';
import { i18n } from '@kbn/i18n';
export var useLinkedSearchUpdates = function useLinkedSearchUpdates(services, eventEmitter, appState, savedVisInstance) {
  useEffect(function () {
    if (appState && savedVisInstance && savedVisInstance.savedSearch && savedVisInstance.vis.data.searchSource) {
      var savedSearch = savedVisInstance.savedSearch; // SearchSource is a promise-based stream of search results that can inherit from other search sources.

      var searchSource = savedVisInstance.vis.data.searchSource;

      var unlinkFromSavedSearch = function unlinkFromSavedSearch() {
        var searchSourceParent = savedSearch.searchSource;
        var searchSourceGrandparent = searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getParent();
        var currentIndex = searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getField('index');
        searchSource.setField('index', currentIndex);
        searchSource.setParent(searchSourceGrandparent);
        appState.transitions.unlinkSavedSearch({
          query: searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getField('query'),
          parentFilters: (searchSourceParent === null || searchSourceParent === void 0 ? void 0 : searchSourceParent.getOwnField('filter')) || []
        });
        services.toastNotifications.addSuccess(i18n.translate('visualize.linkedToSearch.unlinkSuccessNotificationText', {
          defaultMessage: "Unlinked from saved search '{searchTitle}'",
          values: {
            searchTitle: savedSearch.title
          }
        }));
      };

      eventEmitter.on('unlinkFromSavedSearch', unlinkFromSavedSearch);
      return function () {
        eventEmitter.off('unlinkFromSavedSearch', unlinkFromSavedSearch);
      };
    }
  }, [appState, eventEmitter, savedVisInstance, services.toastNotifications]);
};