function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useRef, useState } from 'react';
import { parse } from 'query-string';
import { i18n } from '@kbn/i18n';
import { redirectWhenMissing } from '../../../../../kibana_utils/public';
import { DefaultEditorController } from '../../../../../vis_default_editor/public';
import { getVisualizationInstance } from '../get_visualization_instance';
import { getEditBreadcrumbs, getCreateBreadcrumbs } from '../breadcrumbs';
import { VisualizeConstants } from '../../visualize_constants';
/**
 * This effect is responsible for instantiating a saved vis or creating a new one
 * using url parameters, embedding and destroying it in DOM
 */

export var useSavedVisInstance = function useSavedVisInstance(services, eventEmitter, isChromeVisible, visualizationIdFromUrl) {
  var _useState = useState({}),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var visEditorRef = useRef(null);
  var visId = useRef('');
  useEffect(function () {
    var _state$savedVisInstan;

    var navigateToApp = services.application.navigateToApp,
        chrome = services.chrome,
        history = services.history,
        basePath = services.http.basePath,
        setActiveUrl = services.setActiveUrl,
        toastNotifications = services.toastNotifications;

    var getSavedVisInstance = /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var savedVisInstance, searchParams, visTypes, visType, shouldHaveIndex, hasIndex, _savedVisInstance, embeddableHandler, savedVis, vis, visEditorController, Editor, managementRedirectTarget;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;

                if (!(history.location.pathname === '/create')) {
                  _context.next = 16;
                  break;
                }

                searchParams = parse(history.location.search);
                visTypes = services.visualizations.all();
                visType = visTypes.find(function (_ref2) {
                  var name = _ref2.name;
                  return name === searchParams.type;
                });

                if (visType) {
                  _context.next = 7;
                  break;
                }

                throw new Error(i18n.translate('visualize.createVisualization.noVisTypeErrorMessage', {
                  defaultMessage: 'You must provide a valid visualization type'
                }));

              case 7:
                shouldHaveIndex = visType.requiresSearch && visType.options.showIndexSelection;
                hasIndex = searchParams.indexPattern || searchParams.savedSearchId;

                if (!(shouldHaveIndex && !hasIndex)) {
                  _context.next = 11;
                  break;
                }

                throw new Error(i18n.translate('visualize.createVisualization.noIndexPatternOrSavedSearchIdErrorMessage', {
                  defaultMessage: 'You must provide either an indexPattern or a savedSearchId'
                }));

              case 11:
                _context.next = 13;
                return getVisualizationInstance(services, searchParams);

              case 13:
                savedVisInstance = _context.sent;
                _context.next = 19;
                break;

              case 16:
                _context.next = 18;
                return getVisualizationInstance(services, visualizationIdFromUrl);

              case 18:
                savedVisInstance = _context.sent;

              case 19:
                _savedVisInstance = savedVisInstance, embeddableHandler = _savedVisInstance.embeddableHandler, savedVis = _savedVisInstance.savedVis, vis = _savedVisInstance.vis;

                if (savedVis.id) {
                  chrome.setBreadcrumbs(getEditBreadcrumbs(savedVis.title));
                  chrome.docTitle.change(savedVis.title);
                } else {
                  chrome.setBreadcrumbs(getCreateBreadcrumbs());
                }

                // do not create editor in embeded mode
                if (isChromeVisible) {
                  Editor = vis.type.editor || DefaultEditorController;
                  visEditorController = new Editor(visEditorRef.current, vis, eventEmitter, embeddableHandler);
                } else if (visEditorRef.current) {
                  embeddableHandler.render(visEditorRef.current);
                }

                setState({
                  savedVisInstance: savedVisInstance,
                  visEditorController: visEditorController
                });
                _context.next = 29;
                break;

              case 25:
                _context.prev = 25;
                _context.t0 = _context["catch"](0);
                managementRedirectTarget = {
                  app: 'management',
                  path: "kibana/objects/savedVisualizations/".concat(visualizationIdFromUrl)
                };

                try {
                  redirectWhenMissing({
                    history: history,
                    navigateToApp: navigateToApp,
                    toastNotifications: toastNotifications,
                    basePath: basePath,
                    mapping: {
                      visualization: VisualizeConstants.LANDING_PAGE_PATH,
                      search: managementRedirectTarget,
                      'index-pattern': managementRedirectTarget,
                      'index-pattern-field': managementRedirectTarget
                    },
                    onBeforeRedirect: function onBeforeRedirect() {
                      setActiveUrl(VisualizeConstants.LANDING_PAGE_PATH);
                    }
                  })(_context.t0);
                } catch (e) {
                  toastNotifications.addWarning({
                    title: i18n.translate('visualize.createVisualization.failedToLoadErrorMessage', {
                      defaultMessage: 'Failed to load the visualization'
                    }),
                    text: e.message
                  });
                  history.replace(VisualizeConstants.LANDING_PAGE_PATH);
                }

              case 29:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, null, [[0, 25]]);
      }));

      return function getSavedVisInstance() {
        return _ref.apply(this, arguments);
      };
    }();

    if (isChromeVisible === undefined) {
      // wait for specifying chrome
      return;
    }

    if (!visId.current) {
      visId.current = visualizationIdFromUrl || 'new';
      getSavedVisInstance();
    } else if (visualizationIdFromUrl && visId.current !== visualizationIdFromUrl && ((_state$savedVisInstan = state.savedVisInstance) === null || _state$savedVisInstan === void 0 ? void 0 : _state$savedVisInstan.savedVis.id) !== visualizationIdFromUrl) {
      visId.current = visualizationIdFromUrl;
      setState({});
      getSavedVisInstance();
    }
  }, [eventEmitter, isChromeVisible, services, state.savedVisInstance, state.visEditorController, visualizationIdFromUrl]);
  useEffect(function () {
    return function () {
      var _state$savedVisInstan2, _state$savedVisInstan3;

      if (state.visEditorController) {
        state.visEditorController.destroy();
      } else if ((_state$savedVisInstan2 = state.savedVisInstance) === null || _state$savedVisInstan2 === void 0 ? void 0 : _state$savedVisInstan2.embeddableHandler) {
        state.savedVisInstance.embeddableHandler.destroy();
      }

      if ((_state$savedVisInstan3 = state.savedVisInstance) === null || _state$savedVisInstan3 === void 0 ? void 0 : _state$savedVisInstan3.savedVis) {
        state.savedVisInstance.savedVis.destroy();
      }
    };
  }, [state]);
  return _objectSpread(_objectSpread({}, state), {}, {
    visEditorRef: visEditorRef
  });
};