/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message;

import de.rub.nds.modifiablevariable.HoldsModifiableVariable;
import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.handler.ProtocolMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.PskServerKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.PSKPremasterComputations;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class PskServerKeyExchangeMessage
extends ServerKeyExchangeMessage {
    @HoldsModifiableVariable
    protected PSKPremasterComputations computations;
    private ModifiableByteArray identityHint;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger identityHintLength;

    public PskServerKeyExchangeMessage() {
    }

    public PskServerKeyExchangeMessage(Config tlsConfig) {
        super(tlsConfig, HandshakeMessageType.SERVER_KEY_EXCHANGE);
    }

    public ModifiableByteArray getIdentityHint() {
        return this.identityHint;
    }

    public void setIdentityHint(ModifiableByteArray identityHint) {
        this.identityHint = identityHint;
    }

    public void setIdentityHint(byte[] identity) {
        this.identityHint = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.identityHint, (byte[])identity);
    }

    public ModifiableInteger getIdentityHintLength() {
        return this.identityHintLength;
    }

    public void setIdentityHintLength(ModifiableInteger identityHintLength) {
        this.identityHintLength = identityHintLength;
    }

    public void setIdentityHintLength(int identityHintLength) {
        this.identityHintLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.identityHintLength, (Integer)identityHintLength);
    }

    @Override
    public PSKPremasterComputations getComputations() {
        return this.computations;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PskServerKeyExchangeMessage:");
        sb.append("\n  IdentityHintLength: ");
        if (this.identityHintLength != null && this.identityHintLength.getValue() != null) {
            sb.append(this.identityHintLength.getValue());
        } else {
            sb.append("null");
        }
        sb.append("\n  IdentityHint: ");
        if (this.identityHint != null && this.identityHint.getValue() != null) {
            sb.append(ArrayConverter.bytesToHexString((byte[])((byte[])this.identityHint.getValue())));
        } else {
            sb.append("null");
        }
        return sb.toString();
    }

    @Override
    public ProtocolMessageHandler getHandler(TlsContext context) {
        return new PskServerKeyExchangeHandler(context);
    }

    @Override
    public String toCompactString() {
        return "PSK_SERVER_KEY_EXCHANGE";
    }

    @Override
    public void prepareComputations() {
        if (this.getComputations() == null) {
            this.computations = new PSKPremasterComputations();
        }
    }

    @Override
    public List<ModifiableVariableHolder> getAllModifiableVariableHolders() {
        List<ModifiableVariableHolder> holders = super.getAllModifiableVariableHolders();
        if (this.computations != null) {
            holders.add(this.computations);
        }
        return holders;
    }
}

