/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.jxls.common.RowData;
import org.jxls.common.SheetData;
import org.jxls.transform.Transformer;
import org.jxls.transform.poi.PoiRowData;
import org.jxls.transform.poi.PoiTransformer;

public class PoiSheetData
extends SheetData {
    private List<CellRangeAddress> mergedRegions = new ArrayList<CellRangeAddress>();
    private Sheet sheet;

    public static PoiSheetData createSheetData(Sheet sheet, PoiTransformer transformer) {
        int i;
        PoiSheetData sheetData = new PoiSheetData();
        sheetData.setTransformer((Transformer)transformer);
        sheetData.sheet = sheet;
        sheetData.sheetName = sheet.getSheetName();
        int numberOfRows = sheet.getLastRowNum() + 1;
        int numberOfColumns = -1;
        for (i = 0; i < numberOfRows; ++i) {
            RowData rowData = PoiRowData.createRowData(sheet.getRow(i), transformer);
            sheetData.rowDataList.add(rowData);
            if (rowData == null || rowData.getNumberOfCells() <= numberOfColumns) continue;
            numberOfColumns = rowData.getNumberOfCells();
        }
        for (i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = sheet.getMergedRegion(i);
            sheetData.mergedRegions.add(region);
        }
        if (numberOfColumns > 0) {
            sheetData.columnWidth = new int[numberOfColumns];
            for (i = 0; i < numberOfColumns; ++i) {
                sheetData.columnWidth[i] = sheet.getColumnWidth(i);
            }
        }
        return sheetData;
    }

    public List<CellRangeAddress> getMergedRegions() {
        return this.mergedRegions;
    }

    public Sheet getSheet() {
        return this.sheet;
    }
}

