/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.WriteResponse;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class BulkShardResponse
extends ReplicationResponse
implements WriteResponse {
    private static final Version COMPACT_SHARD_ID_VERSION = Version.V_7_9_0;
    private final ShardId shardId;
    private final BulkItemResponse[] responses;

    BulkShardResponse(StreamInput in) throws IOException {
        super(in);
        this.shardId = new ShardId(in);
        this.responses = new BulkItemResponse[in.readVInt()];
        if (in.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION)) {
            for (int i = 0; i < this.responses.length; ++i) {
                this.responses[i] = new BulkItemResponse(this.shardId, in);
            }
        } else {
            for (int i = 0; i < this.responses.length; ++i) {
                this.responses[i] = new BulkItemResponse(in);
            }
        }
    }

    public BulkShardResponse(ShardId shardId, BulkItemResponse[] responses) {
        this.shardId = shardId;
        this.responses = responses;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public BulkItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public void setForcedRefresh(boolean forcedRefresh) {
        for (BulkItemResponse response : this.responses) {
            Object r = response.getResponse();
            if (r == null) continue;
            ((DocWriteResponse)r).setForcedRefresh(forcedRefresh);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardId.writeTo(out);
        out.writeVInt(this.responses.length);
        if (out.getVersion().onOrAfter(COMPACT_SHARD_ID_VERSION)) {
            for (BulkItemResponse response : this.responses) {
                response.writeThin(out);
            }
        } else {
            for (BulkItemResponse response : this.responses) {
                response.writeTo(out);
            }
        }
    }
}

