/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.shingle.FixedShingleFilter;
import org.apache.lucene.analysis.tokenattributes.BytesTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.AutomatonQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.FieldMaskingSpanQuery;
import org.apache.lucene.search.spans.SpanMultiTermQueryWrapper;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.IntervalBuilder;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;

public class TextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "text";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    public static final String FAST_PHRASE_SUFFIX = "._index_phrase";
    private final int positionIncrementGap;
    private PrefixFieldMapper prefixFieldMapper;
    private PhraseFieldMapper phraseFieldMapper;

    protected TextFieldMapper(String simpleName, FieldType fieldType, TextFieldType mappedFieldType, int positionIncrementGap, PrefixFieldMapper prefixFieldMapper, PhraseFieldMapper phraseFieldMapper, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, mappedFieldType, multiFields, copyTo);
        assert (fieldType.tokenized());
        assert (!mappedFieldType.hasDocValues());
        if (fieldType.indexOptions() == IndexOptions.NONE && this.fieldType().fielddata()) {
            throw new IllegalArgumentException("Cannot enable fielddata on a [text] field that is not indexed: [" + this.name() + "]");
        }
        this.positionIncrementGap = positionIncrementGap;
        this.prefixFieldMapper = prefixFieldMapper;
        this.phraseFieldMapper = phraseFieldMapper;
        if (prefixFieldMapper != null) {
            mappedFieldType.setPrefixFieldType((PrefixFieldType)prefixFieldMapper.mappedFieldType);
        }
        mappedFieldType.setIndexPhrases(phraseFieldMapper != null);
    }

    @Override
    protected TextFieldMapper clone() {
        return (TextFieldMapper)super.clone();
    }

    public int getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (this.fieldType.indexOptions() != IndexOptions.NONE || this.fieldType.stored()) {
            Field field = new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType);
            context.doc().add((IndexableField)field);
            if (this.fieldType.omitNorms()) {
                this.createFieldNamesField(context);
            }
            if (this.prefixFieldMapper != null) {
                this.prefixFieldMapper.addField(context, value);
            }
            if (this.phraseFieldMapper != null) {
                context.doc().add((IndexableField)new Field(this.phraseFieldMapper.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.phraseFieldMapper.fieldType));
            }
        }
    }

    @Override
    public Iterator<Mapper> iterator() {
        ArrayList<FieldMapper> subIterators = new ArrayList<FieldMapper>();
        if (this.prefixFieldMapper != null) {
            subIterators.add(this.prefixFieldMapper);
        }
        if (this.phraseFieldMapper != null) {
            subIterators.add(this.phraseFieldMapper);
        }
        if (subIterators.size() == 0) {
            return super.iterator();
        }
        return Iterators.concat(super.iterator(), subIterators.iterator());
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        TextFieldMapper mw = (TextFieldMapper)other;
        if (!Objects.equals(mw.fieldType().getTextSearchInfo().getSimilarity(), this.fieldType().getTextSearchInfo().getSimilarity())) {
            conflicts.add("mapper [" + this.name() + "] has different [similarity] settings");
        }
        if (mw.fieldType().indexPhrases != this.fieldType().indexPhrases) {
            conflicts.add("mapper [" + this.name() + "] has different [index_phrases] settings");
        }
        if (!PrefixFieldType.canMerge(mw.fieldType().prefixFieldType, this.fieldType().prefixFieldType)) {
            conflicts.add("mapper [" + this.name() + "] has different [index_prefixes] settings");
        }
        if (this.prefixFieldMapper != null && mw.prefixFieldMapper != null) {
            this.prefixFieldMapper = (PrefixFieldMapper)this.prefixFieldMapper.merge(mw.prefixFieldMapper);
        }
        if (this.phraseFieldMapper != null && mw.phraseFieldMapper != null) {
            this.phraseFieldMapper = (PhraseFieldMapper)this.phraseFieldMapper.merge(mw.phraseFieldMapper);
        }
    }

    @Override
    public TextFieldType fieldType() {
        return (TextFieldType)super.fieldType();
    }

    @Override
    protected boolean docValuesByDefault() {
        return false;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType.indexOptions() != IndexOptions.NONE && (includeDefaults || this.fieldType.indexOptions() != Defaults.FIELD_TYPE.indexOptions())) {
            builder.field("index_options", TextFieldMapper.indexOptionToString(this.fieldType.indexOptions()));
        }
        if (includeDefaults || this.fieldType.storeTermVectors() != Defaults.FIELD_TYPE.storeTermVectors()) {
            builder.field("term_vector", TextFieldMapper.termVectorOptionsToString(this.fieldType));
        }
        if (includeDefaults || this.fieldType.omitNorms()) {
            builder.field("norms", !this.fieldType.omitNorms());
        }
        this.doXContentAnalyzers(builder, includeDefaults);
        if (this.fieldType().getTextSearchInfo().getSimilarity() != null) {
            builder.field("similarity", this.fieldType().getTextSearchInfo().getSimilarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "BM25");
        }
        if (includeDefaults || this.fieldType().eagerGlobalOrdinals()) {
            builder.field("eager_global_ordinals", this.fieldType().eagerGlobalOrdinals());
        }
        if (this.positionIncrementGap != -1) {
            builder.field("position_increment_gap", this.positionIncrementGap);
        }
        if (includeDefaults || this.fieldType().fielddata()) {
            builder.field("fielddata", this.fieldType().fielddata());
        }
        if (this.fieldType().fielddata() && (includeDefaults || this.fieldType().fielddataMinFrequency() != 0.0 || this.fieldType().fielddataMaxFrequency() != 2.147483647E9 || this.fieldType().fielddataMinSegmentSize() != 0)) {
            builder.startObject("fielddata_frequency_filter");
            if (includeDefaults || this.fieldType().fielddataMinFrequency() != 0.0) {
                builder.field("min", this.fieldType().fielddataMinFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMaxFrequency() != 2.147483647E9) {
                builder.field("max", this.fieldType().fielddataMaxFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMinSegmentSize() != 0) {
                builder.field("min_segment_size", this.fieldType().fielddataMinSegmentSize());
            }
            builder.endObject();
        }
        if (this.fieldType().prefixFieldType != null) {
            this.fieldType().prefixFieldType.doXContent(builder);
        }
        if (this.fieldType().indexPhrases) {
            builder.field("index_phrases", this.fieldType().indexPhrases);
        }
    }

    public static Query createPhraseQuery(TokenStream stream, String field, int slop, boolean enablePositionIncrements) throws IOException {
        MultiPhraseQuery.Builder mpqb = new MultiPhraseQuery.Builder();
        mpqb.setSlop(slop);
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        int position = -1;
        ArrayList<Term> multiTerms = new ArrayList<Term>();
        stream.reset();
        while (stream.incrementToken()) {
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement > 0 && multiTerms.size() > 0) {
                if (enablePositionIncrements) {
                    mpqb.add(multiTerms.toArray(new Term[0]), position);
                } else {
                    mpqb.add(multiTerms.toArray(new Term[0]));
                }
                multiTerms.clear();
            }
            position += positionIncrement;
            multiTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        if (enablePositionIncrements) {
            mpqb.add(multiTerms.toArray(new Term[0]), position);
        } else {
            mpqb.add(multiTerms.toArray(new Term[0]));
        }
        return mpqb.build();
    }

    public static Query createPhrasePrefixQuery(TokenStream stream, String field, int slop, int maxExpansions, String prefixField, IntPredicate usePrefixField) throws IOException {
        MultiPhrasePrefixQuery builder = new MultiPhrasePrefixQuery(field);
        builder.setSlop(slop);
        builder.setMaxExpansions(maxExpansions);
        ArrayList<Term> currentTerms = new ArrayList<Term>();
        TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
        stream.reset();
        int position = -1;
        while (stream.incrementToken()) {
            if (posIncrAtt.getPositionIncrement() != 0) {
                if (!currentTerms.isEmpty()) {
                    builder.add(currentTerms.toArray(new Term[0]), position);
                }
                position += posIncrAtt.getPositionIncrement();
                currentTerms.clear();
            }
            currentTerms.add(new Term(field, termAtt.getBytesRef()));
        }
        builder.add(currentTerms.toArray(new Term[0]), position);
        if (prefixField == null) {
            return builder;
        }
        int lastPos = builder.getTerms().length - 1;
        Term[][] terms = builder.getTerms();
        int[] positions = builder.getPositions();
        for (Term term2 : terms[lastPos]) {
            String value = term2.text();
            if (usePrefixField.test(value.length())) continue;
            return builder;
        }
        if (terms.length == 1) {
            Term[] newTerms = (Term[])Arrays.stream(terms[0]).map(term -> new Term(prefixField, term.bytes())).toArray(Term[]::new);
            return new SynonymQuery(newTerms);
        }
        SpanNearQuery.Builder spanQuery = new SpanNearQuery.Builder(field, true);
        spanQuery.setSlop(slop);
        int previousPos = -1;
        for (int i = 0; i < terms.length; ++i) {
            SpanTermQuery[] queries;
            Term[] posTerms = terms[i];
            int posInc = positions[i] - previousPos;
            previousPos = positions[i];
            if (posInc > 1) {
                spanQuery.addGap(posInc - 1);
            }
            if (i == lastPos) {
                if (posTerms.length == 1) {
                    FieldMaskingSpanQuery fieldMask = new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(prefixField, posTerms[0].bytes())), field);
                    spanQuery.addClause((SpanQuery)fieldMask);
                    continue;
                }
                queries = (SpanQuery[])Arrays.stream(posTerms).map(term -> new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(prefixField, term.bytes())), field)).toArray(SpanQuery[]::new);
                spanQuery.addClause((SpanQuery)new SpanOrQuery((SpanQuery[])queries));
                continue;
            }
            if (posTerms.length == 1) {
                spanQuery.addClause((SpanQuery)new SpanTermQuery(posTerms[0]));
                continue;
            }
            queries = (SpanTermQuery[])Arrays.stream(posTerms).map(SpanTermQuery::new).toArray(SpanTermQuery[]::new);
            spanQuery.addClause((SpanQuery)new SpanOrQuery((SpanQuery[])queries));
        }
        return spanQuery.build();
    }

    public static class TextFieldType
    extends StringFieldType {
        private boolean fielddata;
        private double fielddataMinFrequency;
        private double fielddataMaxFrequency;
        private int fielddataMinSegmentSize;
        private PrefixFieldType prefixFieldType;
        private boolean indexPhrases = false;
        private final FieldType indexedFieldType;

        public TextFieldType(String name, FieldType indexedFieldType, SimilarityProvider similarity, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer, Map<String, String> meta) {
            super(name, indexedFieldType.indexOptions() != IndexOptions.NONE, false, new TextSearchInfo(indexedFieldType, similarity, searchAnalyzer, searchQuoteAnalyzer), meta);
            this.indexedFieldType = indexedFieldType;
            this.fielddata = false;
            this.fielddataMinFrequency = 0.0;
            this.fielddataMaxFrequency = 2.147483647E9;
            this.fielddataMinSegmentSize = 0;
        }

        public TextFieldType(String name, boolean indexed, Map<String, String> meta) {
            super(name, indexed, false, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), meta);
            this.indexedFieldType = Defaults.FIELD_TYPE;
            this.fielddata = false;
        }

        public TextFieldType(String name) {
            this(name, Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER, Collections.emptyMap());
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        public void setFielddata(boolean fielddata) {
            this.fielddata = fielddata;
        }

        public double fielddataMinFrequency() {
            return this.fielddataMinFrequency;
        }

        public void setFielddataMinFrequency(double fielddataMinFrequency) {
            this.fielddataMinFrequency = fielddataMinFrequency;
        }

        public double fielddataMaxFrequency() {
            return this.fielddataMaxFrequency;
        }

        public void setFielddataMaxFrequency(double fielddataMaxFrequency) {
            this.fielddataMaxFrequency = fielddataMaxFrequency;
        }

        public int fielddataMinSegmentSize() {
            return this.fielddataMinSegmentSize;
        }

        public void setFielddataMinSegmentSize(int fielddataMinSegmentSize) {
            this.fielddataMinSegmentSize = fielddataMinSegmentSize;
        }

        void setPrefixFieldType(PrefixFieldType prefixFieldType) {
            this.prefixFieldType = prefixFieldType;
        }

        void setIndexPhrases(boolean indexPhrases) {
            this.indexPhrases = indexPhrases;
        }

        public PrefixFieldType getPrefixFieldType() {
            return this.prefixFieldType;
        }

        @Override
        public String typeName() {
            return TextFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (this.prefixFieldType == null || !this.prefixFieldType.accept(value.length())) {
                return super.prefixQuery(value, method, context);
            }
            Query tq = this.prefixFieldType.prefixQuery(value, method, context);
            if (method == null || method == MultiTermQuery.CONSTANT_SCORE_REWRITE || method == MultiTermQuery.CONSTANT_SCORE_BOOLEAN_REWRITE) {
                return new ConstantScoreQuery(tq);
            }
            return tq;
        }

        @Override
        public SpanQuery spanPrefixQuery(String value, SpanMultiTermQueryWrapper.SpanRewriteMethod method, QueryShardContext context) {
            this.failIfNotIndexed();
            if (this.prefixFieldType != null && value.length() >= this.prefixFieldType.minChars && value.length() <= this.prefixFieldType.maxChars && this.prefixFieldType.getTextSearchInfo().hasPositions()) {
                return new FieldMaskingSpanQuery((SpanQuery)new SpanTermQuery(new Term(this.prefixFieldType.name(), this.indexedValueForSearch(value))), this.name());
            }
            SpanMultiTermQueryWrapper spanMulti = new SpanMultiTermQueryWrapper((MultiTermQuery)new PrefixQuery(new Term(this.name(), this.indexedValueForSearch(value))));
            spanMulti.setRewriteMethod(method);
            return spanMulti;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.indexedFieldType.omitNorms()) {
                return new TermQuery(new Term("_field_names", this.name()));
            }
            return new NormsFieldExistsQuery(this.name());
        }

        @Override
        public IntervalsSource intervals(String text, int maxGaps, boolean ordered, NamedAnalyzer analyzer, boolean prefix) throws IOException {
            if (!this.getTextSearchInfo().hasPositions()) {
                throw new IllegalArgumentException("Cannot create intervals over field [" + this.name() + "] with no positions indexed");
            }
            if (analyzer == null) {
                analyzer = this.getTextSearchInfo().getSearchAnalyzer();
            }
            if (prefix) {
                BytesRef normalizedTerm = analyzer.normalize(this.name(), text);
                if (this.prefixFieldType != null) {
                    return this.prefixFieldType.intervals(normalizedTerm);
                }
                return Intervals.prefix((BytesRef)normalizedTerm);
            }
            IntervalBuilder builder = new IntervalBuilder(this.name(), (Analyzer)(analyzer == null ? this.getTextSearchInfo().getSearchAnalyzer() : analyzer));
            return builder.analyzeText(text, maxGaps, ordered);
        }

        @Override
        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements) throws IOException {
            String field = this.name();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream) && !stream.hasAttribute(BytesTermAttribute.class)) {
                stream = new FixedShingleFilter(stream, 2);
                field = field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            PhraseQuery.Builder builder = new PhraseQuery.Builder();
            builder.setSlop(slop);
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            int position = -1;
            stream.reset();
            while (stream.incrementToken()) {
                if (termAtt.getBytesRef() == null) {
                    throw new IllegalStateException("Null term while building phrase query");
                }
                position = enablePosIncrements ? (position += posIncrAtt.getPositionIncrement()) : ++position;
                builder.add(new Term(field, termAtt.getBytesRef()), position);
            }
            return builder.build();
        }

        @Override
        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements) throws IOException {
            String field = this.name();
            if (this.indexPhrases && slop == 0 && !TextFieldType.hasGaps(stream)) {
                stream = new FixedShingleFilter(stream, 2);
                field = field + TextFieldMapper.FAST_PHRASE_SUFFIX;
            }
            return TextFieldMapper.createPhraseQuery(stream, field, slop, enablePositionIncrements);
        }

        @Override
        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions) throws IOException {
            return this.analyzePhrasePrefix(stream, slop, maxExpansions);
        }

        private Query analyzePhrasePrefix(TokenStream stream, int slop, int maxExpansions) throws IOException {
            String prefixField = this.prefixFieldType == null || slop > 0 ? null : this.prefixFieldType.name();
            IntPredicate usePrefix = len -> len >= this.prefixFieldType.minChars && len <= this.prefixFieldType.maxChars;
            return TextFieldMapper.createPhrasePrefixQuery(stream, this.name(), slop, maxExpansions, prefixField, usePrefix);
        }

        public static boolean hasGaps(TokenStream stream) throws IOException {
            assert (stream instanceof CachingTokenFilter);
            PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)stream.getAttribute(PositionIncrementAttribute.class);
            stream.reset();
            while (stream.incrementToken()) {
                if (posIncAtt.getPositionIncrement() <= 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            if (!this.fielddata) {
                throw new IllegalArgumentException("Text fields are not optimised for operations that require per-document field data like aggregations and sorting, so these operations are disabled by default. Please use a keyword field instead. Alternatively, set fielddata=true on [" + this.name() + "] in order to load field data by uninverting the inverted index. Note that this can use significant memory.");
            }
            return new PagedBytesIndexFieldData.Builder(this.fielddataMinFrequency, this.fielddataMaxFrequency, this.fielddataMinSegmentSize, CoreValuesSourceType.BYTES);
        }
    }

    private static final class PrefixFieldMapper
    extends FieldMapper {
        protected PrefixFieldMapper(FieldType fieldType, PrefixFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        void addField(ParseContext context, String value) {
            context.doc().add((IndexableField)new Field(this.fieldType().name(), (CharSequence)value, (IndexableFieldType)this.fieldType));
        }

        @Override
        protected void parseCreateField(ParseContext context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "prefix";
        }

        public String toString() {
            return this.fieldType().toString();
        }
    }

    private static final class PhraseFieldMapper
    extends FieldMapper {
        PhraseFieldMapper(FieldType fieldType, PhraseFieldType mappedFieldType) {
            super(mappedFieldType.name(), fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        }

        @Override
        protected void parseCreateField(ParseContext context) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        }

        @Override
        protected String contentType() {
            return "phrase";
        }
    }

    static final class PrefixFieldType
    extends StringFieldType {
        final int minChars;
        final int maxChars;
        final TextFieldType parentField;
        final boolean hasPositions;

        PrefixFieldType(TextFieldType parentField, String name, int minChars, int maxChars, boolean hasPositions) {
            super(name, true, false, parentField.getTextSearchInfo(), Collections.emptyMap());
            this.minChars = minChars;
            this.maxChars = maxChars;
            this.parentField = parentField;
            this.hasPositions = hasPositions;
        }

        static boolean canMerge(PrefixFieldType first, PrefixFieldType second) {
            if (first == null) {
                return second == null;
            }
            return second != null && first.minChars == second.minChars && first.maxChars == second.maxChars;
        }

        void setAnalyzer(NamedAnalyzer delegate) {
            this.setIndexAnalyzer(new NamedAnalyzer(delegate.name(), AnalyzerScope.INDEX, (Analyzer)new PrefixWrappedAnalyzer(delegate.analyzer(), this.minChars, this.maxChars)));
        }

        boolean accept(int length) {
            return length >= this.minChars - 1 && length <= this.maxChars;
        }

        void doXContent(XContentBuilder builder) throws IOException {
            builder.startObject("index_prefixes");
            builder.field("min_chars", this.minChars);
            builder.field("max_chars", this.maxChars);
            builder.endObject();
        }

        @Override
        public Query prefixQuery(String value, MultiTermQuery.RewriteMethod method, QueryShardContext context) {
            if (value.length() >= this.minChars) {
                return super.termQuery(value, context);
            }
            ArrayList<Automaton> automata = new ArrayList<Automaton>();
            automata.add(Automata.makeString((String)value));
            for (int i = value.length(); i < this.minChars; ++i) {
                automata.add(Automata.makeAnyChar());
            }
            Automaton automaton = Operations.concatenate(automata);
            AutomatonQuery query = new AutomatonQuery(new Term(this.name(), value + "*"), automaton);
            query.setRewriteMethod(method);
            return new BooleanQuery.Builder().add((Query)query, BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term(this.parentField.name(), value)), BooleanClause.Occur.SHOULD).build();
        }

        public IntervalsSource intervals(BytesRef term) {
            if (!this.hasPositions) {
                throw new IllegalArgumentException("Cannot create intervals over a field [" + this.name() + "] without indexed positions");
            }
            if (term.length > this.maxChars) {
                return Intervals.prefix((BytesRef)term);
            }
            if (term.length >= this.minChars) {
                return Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.term((BytesRef)term));
            }
            StringBuilder sb = new StringBuilder(term.utf8ToString());
            for (int i = term.length; i < this.minChars; ++i) {
                sb.append("?");
            }
            String wildcardTerm = sb.toString();
            return Intervals.or((IntervalsSource[])new IntervalsSource[]{Intervals.fixField((String)this.name(), (IntervalsSource)Intervals.wildcard((BytesRef)new BytesRef((CharSequence)wildcardTerm))), Intervals.term((BytesRef)term)});
        }

        @Override
        public String typeName() {
            return "prefix";
        }

        public String toString() {
            return super.toString() + ",prefixChars=" + this.minChars + ":" + this.maxChars;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Defaults {
        public static final double FIELDDATA_MIN_FREQUENCY = 0.0;
        public static final double FIELDDATA_MAX_FREQUENCY = 2.147483647E9;
        public static final int FIELDDATA_MIN_SEGMENT_SIZE = 0;
        public static final int INDEX_PREFIX_MIN_CHARS = 2;
        public static final int INDEX_PREFIX_MAX_CHARS = 5;
        public static final FieldType FIELD_TYPE = new FieldType();
        public static final int POSITION_INCREMENT_GAP = 100;

        static {
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(false);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.freeze();
        }
    }

    private static final class PhraseFieldType
    extends StringFieldType {
        final TextFieldType parent;

        PhraseFieldType(TextFieldType parent) {
            super(parent.name() + TextFieldMapper.FAST_PHRASE_SUFFIX, true, false, parent.getTextSearchInfo(), Collections.emptyMap());
            this.setAnalyzer(parent.indexAnalyzer().name(), parent.indexAnalyzer().analyzer());
            this.parent = parent;
        }

        void setAnalyzer(String name, Analyzer delegate) {
            this.setIndexAnalyzer(new NamedAnalyzer(name, AnalyzerScope.INDEX, (Analyzer)new PhraseWrappedAnalyzer(delegate)));
        }

        @Override
        public String typeName() {
            return "phrase";
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            throw new UnsupportedOperationException();
        }
    }

    private static class PrefixWrappedAnalyzer
    extends AnalyzerWrapper {
        private final int minChars;
        private final int maxChars;
        private final Analyzer delegate;

        PrefixWrappedAnalyzer(Analyzer delegate, int minChars, int maxChars) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
            this.minChars = minChars;
            this.maxChars = maxChars;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            EdgeNGramTokenFilter filter = new EdgeNGramTokenFilter(components.getTokenStream(), this.minChars, this.maxChars, false);
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)filter);
        }
    }

    private static class PhraseWrappedAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer delegate;

        PhraseWrappedAnalyzer(Analyzer delegate) {
            super(delegate.getReuseStrategy());
            this.delegate = delegate;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            return this.delegate;
        }

        protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
            return new Analyzer.TokenStreamComponents(components.getSource(), (TokenStream)new FixedShingleFilter(components.getTokenStream(), 2));
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(fieldName);
            builder.indexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
            builder.searchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
            builder.searchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                TypeParsers.checkNull(propName, propNode);
                if (propName.equals("position_increment_gap")) {
                    int newPositionIncrementGap = XContentMapValues.nodeIntegerValue(propNode, -1);
                    builder.positionIncrementGap(newPositionIncrementGap);
                    iterator.remove();
                    continue;
                }
                if (propName.equals("fielddata")) {
                    builder.fielddata(XContentMapValues.nodeBooleanValue(propNode, "fielddata"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(propNode, "eager_global_ordinals"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("fielddata_frequency_filter")) {
                    Map frequencyFilter = (Map)propNode;
                    double minFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("min"), 0.0);
                    double maxFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("max"), 2.147483647E9);
                    int minSegmentSize = XContentMapValues.nodeIntegerValue(frequencyFilter.remove("min_segment_size"), 0);
                    builder.fielddataFrequencyFilter(minFrequency, maxFrequency, minSegmentSize);
                    DocumentMapperParser.checkNoRemainingFields(propName, frequencyFilter, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("index_prefixes")) {
                    Map indexPrefix = (Map)propNode;
                    int minChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("min_chars"), 2);
                    int maxChars = XContentMapValues.nodeIntegerValue(indexPrefix.remove("max_chars"), 5);
                    builder.indexPrefixes(minChars, maxChars);
                    DocumentMapperParser.checkNoRemainingFields(propName, indexPrefix, parserContext.indexVersionCreated());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("index_phrases")) {
                    builder.indexPhrases(XContentMapValues.nodeBooleanValue(propNode, "index_phrases"));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("similarity")) continue;
                SimilarityProvider similarityProvider = TypeParsers.resolveSimilarity(parserContext, fieldName, propNode.toString());
                builder.similarity(similarityProvider);
                iterator.remove();
            }
            TypeParsers.parseTextField(builder, fieldName, node, parserContext);
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder> {
        private int positionIncrementGap = -1;
        private int minPrefixChars = -1;
        private int maxPrefixChars = -1;
        private boolean fielddata = false;
        private boolean indexPhrases = false;
        private boolean eagerGlobalOrdinals = false;
        private double fielddataMinFreq = 0.0;
        private double fielddataMaxFreq = 2.147483647E9;
        private int fielddataMinSegSize = 0;
        protected SimilarityProvider similarity;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder positionIncrementGap(int positionIncrementGap) {
            if (positionIncrementGap < 0) {
                throw new MapperParsingException("[positions_increment_gap] must be positive, got " + positionIncrementGap);
            }
            this.positionIncrementGap = positionIncrementGap;
            return this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fielddata = fielddata;
            return (Builder)this.builder;
        }

        public Builder indexPhrases(boolean indexPhrases) {
            this.indexPhrases = indexPhrases;
            return (Builder)this.builder;
        }

        public void similarity(SimilarityProvider similarity) {
            this.similarity = similarity;
        }

        @Override
        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("[text] fields do not support doc values");
            }
            return (Builder)super.docValues(docValues);
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            return (Builder)this.builder;
        }

        public Builder fielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.fielddataMinFreq = minFreq;
            this.fielddataMaxFreq = maxFreq;
            this.fielddataMinSegSize = minSegmentSize;
            return (Builder)this.builder;
        }

        public Builder indexPrefixes(int minChars, int maxChars) {
            if (minChars > maxChars) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be less than max_chars [" + maxChars + "]");
            }
            if (minChars < 1) {
                throw new IllegalArgumentException("min_chars [" + minChars + "] must be greater than zero");
            }
            if (maxChars >= 20) {
                throw new IllegalArgumentException("max_chars [" + maxChars + "] must be less than 20");
            }
            this.minPrefixChars = minChars;
            this.maxPrefixChars = maxChars;
            return this;
        }

        private TextFieldType buildFieldType(Mapper.BuilderContext context) {
            TextFieldType ft = new TextFieldType(this.buildFullName(context), this.fieldType, this.similarity, this.searchAnalyzer, this.searchQuoteAnalyzer, this.meta);
            ft.setIndexAnalyzer(this.indexAnalyzer);
            ft.setEagerGlobalOrdinals(this.eagerGlobalOrdinals);
            if (this.fielddata) {
                ft.setFielddata(true);
                ft.setFielddataMinFrequency(this.fielddataMinFreq);
                ft.setFielddataMaxFrequency(this.fielddataMaxFreq);
                ft.setFielddataMinSegmentSize(this.fielddataMinSegSize);
            }
            return ft;
        }

        private PrefixFieldMapper buildPrefixMapper(Mapper.BuilderContext context, TextFieldType tft) {
            if (this.minPrefixChars == -1) {
                return null;
            }
            if (!this.indexed) {
                throw new IllegalArgumentException("Cannot set index_prefixes on unindexed field [" + this.name() + "]");
            }
            String fullName = context.indexCreatedVersion().before(Version.V_7_2_1) ? this.name() : this.buildFullName(context);
            FieldType pft = new FieldType((IndexableFieldType)this.fieldType);
            pft.setOmitNorms(true);
            if (this.fieldType.indexOptions() == IndexOptions.DOCS_AND_FREQS) {
                pft.setIndexOptions(IndexOptions.DOCS);
            } else {
                pft.setIndexOptions(this.fieldType.indexOptions());
            }
            if (this.fieldType.storeTermVectorOffsets()) {
                pft.setStoreTermVectorOffsets(true);
            }
            PrefixFieldType prefixFieldType = new PrefixFieldType(tft, fullName + "._index_prefix", this.minPrefixChars, this.maxPrefixChars, pft.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0);
            prefixFieldType.setAnalyzer(this.indexAnalyzer);
            return new PrefixFieldMapper(pft, prefixFieldType);
        }

        private PhraseFieldMapper buildPhraseMapper(Mapper.BuilderContext context, TextFieldType parent) {
            if (!this.indexPhrases) {
                return null;
            }
            if (!this.indexed) {
                throw new IllegalArgumentException("Cannot set index_phrases on unindexed field [" + this.name() + "]");
            }
            if (this.fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                throw new IllegalArgumentException("Cannot set index_phrases on field [" + this.name() + "] if positions are not enabled");
            }
            FieldType phraseFieldType = new FieldType((IndexableFieldType)this.fieldType);
            return new PhraseFieldMapper(phraseFieldType, new PhraseFieldType(parent));
        }

        @Override
        public FieldMapper build(Mapper.BuilderContext context) {
            if (this.positionIncrementGap != -1) {
                if (this.fieldType.indexOptions().compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
                }
                this.indexAnalyzer = new NamedAnalyzer(this.indexAnalyzer, this.positionIncrementGap);
                this.searchAnalyzer = new NamedAnalyzer(this.searchAnalyzer, this.positionIncrementGap);
                this.searchQuoteAnalyzer = new NamedAnalyzer(this.searchQuoteAnalyzer, this.positionIncrementGap);
            }
            TextFieldType tft = this.buildFieldType(context);
            return new TextFieldMapper(this.name, this.fieldType, tft, this.positionIncrementGap, this.buildPrefixMapper(context, tft), this.buildPhraseMapper(context, tft), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

