/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class ByteEncodedValue
extends EncodedValue {
    public final byte value;

    protected ByteEncodedValue(Input in) {
        this.value = (byte)EncodedValueUtils.decodeSignedIntegralValue(in.readBytes(1));
    }

    public ByteEncodedValue(byte value) {
        this.value = value;
    }

    @Override
    public void writeValue(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_BYTE.name() + ",value_arg=0");
            out.annotate(1, "value: 0x" + Integer.toHexString(this.value) + " (" + this.value + ")");
        }
        out.writeByte(ValueType.VALUE_BYTE.value);
        out.writeByte(this.value);
    }

    @Override
    public int placeValue(int offset) {
        return offset + 2;
    }

    @Override
    protected int compareValue(EncodedValue o) {
        ByteEncodedValue other = (ByteEncodedValue)o;
        return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_BYTE;
    }

    public int hashCode() {
        return this.value;
    }
}

