/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.task.gui.taskview;

import docking.widgets.label.GDLabel;
import ghidra.framework.task.gui.GProgressBar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ScheduledTaskPanel
extends JPanel {
    private int scrollOffset = 0;
    private int indention = 0;
    private GProgressBar progressBar;
    private JLabel label;
    private ScheduledElementLayout layout;

    public ScheduledTaskPanel(String labelText, int indention) {
        this.indention = indention;
        this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.layout = new ScheduledElementLayout();
        this.setLayout(this.layout);
        this.label = new GDLabel(labelText);
        this.setBackground(Color.WHITE);
        this.add(this.label);
    }

    void addProgressBar() {
        this.progressBar = new GProgressBar(null, true, true, false, 12.0f);
        this.progressBar.setBackgroundColor(Color.WHITE);
        this.add(this.progressBar);
        this.layout.clearPreferredSize();
        this.invalidate();
    }

    public GProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void setHiddenViewAmount(float fraction) {
        Container parent = this.getParent();
        if (parent == null) {
            this.scrollOffset = 0;
        }
        this.scrollOffset = (int)((float)this.layout.getNormalPreferredSize((Container)parent).height * fraction);
    }

    private class ScheduledElementLayout
    implements LayoutManager {
        private Dimension normalPreferredSize;

        private ScheduledElementLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            this.normalPreferredSize = null;
        }

        public void clearPreferredSize() {
            this.normalPreferredSize = null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            this.normalPreferredSize = null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d = this.getNormalPreferredSize(parent);
            if (ScheduledTaskPanel.this.scrollOffset == 0) {
                return d;
            }
            return new Dimension(d.width, d.height - ScheduledTaskPanel.this.scrollOffset);
        }

        private Dimension getNormalPreferredSize(Container parent) {
            if (this.normalPreferredSize == null) {
                Insets insets = parent.getInsets();
                int height = insets.top + insets.bottom + ScheduledTaskPanel.this.label.getPreferredSize().height;
                if (ScheduledTaskPanel.this.progressBar != null) {
                    height += ScheduledTaskPanel.this.progressBar.getPreferredSize().height;
                }
                this.normalPreferredSize = new Dimension(100, height);
            }
            return this.normalPreferredSize;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return ScheduledTaskPanel.this.getPreferredSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            int width = size.width - insets.left - insets.right - ScheduledTaskPanel.this.indention;
            int x = insets.left + ScheduledTaskPanel.this.indention;
            int y = insets.top - ScheduledTaskPanel.this.scrollOffset;
            int labelHeight = ScheduledTaskPanel.this.label.getPreferredSize().height;
            ScheduledTaskPanel.this.label.setBounds(x, y, width, labelHeight);
            y += labelHeight;
            if (ScheduledTaskPanel.this.progressBar != null) {
                ScheduledTaskPanel.this.progressBar.setBounds(x, y, width, ScheduledTaskPanel.this.progressBar.getPreferredSize().height);
            }
        }
    }
}

