/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.Record;
import ghidra.docking.settings.Settings;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.data.BitFieldDBDataType;
import ghidra.program.database.data.ComponentDBAdapter;
import ghidra.program.database.data.CompositeDB;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeComponentDB;
import ghidra.program.database.data.DataTypeDB;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class UnionDB
extends CompositeDB
implements Union {
    private ArrayList<DataTypeComponentDB> components;
    private int unionLength;
    private static MemberComparator comparator = new MemberComparator();

    public UnionDB(DataTypeManagerDB dataMgr, DBObjectCache<DataTypeDB> cache, CompositeDBAdapter compositeAdapter, ComponentDBAdapter componentAdapter, Record record) {
        super(dataMgr, cache, compositeAdapter, componentAdapter, record);
    }

    @Override
    protected void initialize() {
        this.components = new ArrayList();
        try {
            long[] ids = this.componentAdapter.getComponentIdsInComposite(this.key);
            for (int i = 0; i < ids.length; ++i) {
                Record rec = this.componentAdapter.getRecord(ids[i]);
                this.components.add(new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec));
            }
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
        Collections.sort(this.components, comparator);
        this.unionLength = this.record.getIntValue(4);
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (this.isNotYetDefined()) {
            return "<Empty-Union>";
        }
        return "";
    }

    @Override
    public boolean isNotYetDefined() {
        return this.components.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent add(DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataTypeComponent dtc = this.doAdd(dataType, length, name, comment);
            this.adjustLength(true, true);
            DataTypeComponent dataTypeComponent = dtc;
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    private int getBitFieldAllocation(BitFieldDataType bitfieldDt) {
        BitFieldPacking bitFieldPacking = this.getBitFieldPacking();
        if (bitFieldPacking.useMSConvention()) {
            return bitfieldDt.getBaseTypeSize();
        }
        if (bitfieldDt.getBitSize() == 0) {
            return 0;
        }
        int length = bitfieldDt.getBaseTypeSize();
        int packValue = this.getPackingValue();
        if (packValue != 0 && length > packValue) {
            length = DataOrganizationImpl.getLeastCommonMultiple(bitfieldDt.getStorageSize(), packValue);
        }
        return length;
    }

    private DataTypeComponent doAdd(DataType dataType, int length, String name, String comment) {
        this.validateDataType(dataType);
        dataType = this.adjustBitField(dataType);
        dataType = this.resolve(dataType);
        this.checkAncestry(dataType);
        length = this.getPreferredComponentLength(dataType, length);
        DataTypeComponentDB dtc = this.createComponent(this.dataMgr.getResolvedID(dataType), length, this.components.size(), 0, name, comment);
        dataType.addParent(this);
        this.components.add(dtc);
        return dtc;
    }

    private DataTypeComponentDB createComponent(long dtID, int length, int ordinal, int offset, String name, String comment) {
        try {
            Record rec = this.componentAdapter.createRecord(dtID, this.key, length, ordinal, offset, name, comment);
            return new DataTypeComponentDB(this.dataMgr, this.componentAdapter, this, rec);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
            return null;
        }
    }

    private void removeComponent(long compKey) {
        try {
            this.componentAdapter.removeRecord(compKey);
        }
        catch (IOException e) {
            this.dataMgr.dbError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataTypeComponent insert(int ordinal, DataType dataType, int length, String name, String comment) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            this.validateDataType(dataType);
            dataType = this.adjustBitField(dataType);
            dataType = this.resolve(dataType);
            this.checkAncestry(dataType);
            length = this.getPreferredComponentLength(dataType, length);
            DataTypeComponentDB dtc = this.createComponent(this.dataMgr.getResolvedID(dataType), length, ordinal, 0, name, comment);
            dataType.addParent(this);
            this.shiftOrdinals(ordinal, 1);
            this.components.add(ordinal, dtc);
            this.adjustLength(true, true);
            DataTypeComponentDB dataTypeComponentDB = dtc;
            return dataTypeComponentDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent addBitField(DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException {
        return this.insertBitField(this.components.size(), baseDataType, bitSize, componentName, comment);
    }

    @Override
    public DataTypeComponent insertBitField(int ordinal, DataType baseDataType, int bitSize, String componentName, String comment) throws InvalidDataTypeException, ArrayIndexOutOfBoundsException {
        if (ordinal < 0 || ordinal > this.components.size()) {
            throw new ArrayIndexOutOfBoundsException(ordinal);
        }
        BitFieldDBDataType bitFieldDt = new BitFieldDBDataType(baseDataType, bitSize, 0);
        return this.insert(ordinal, bitFieldDt, bitFieldDt.getStorageSize(), componentName, comment);
    }

    @Override
    public void delete(int ordinal) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataTypeComponentDB dtc = this.components.remove(ordinal);
            dtc.getDataType().removeParent(this);
            this.removeComponent(dtc.getKey());
            this.shiftOrdinals(ordinal, -1);
            this.adjustLength(true, true);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void delete(int[] ordinals) {
        for (int ordinal : ordinals) {
            this.delete(ordinal);
        }
    }

    @Override
    public void replaceWith(DataType dataType) {
        if (!(dataType instanceof Union)) {
            throw new IllegalArgumentException();
        }
        this.doReplaceWith((Union)dataType, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReplaceWith(Union union, boolean notify, DataTypeConflictHandler handler) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            long oldMinAlignment = this.getMinimumAlignment();
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeComponentDB dtc = this.components.get(i);
                dtc.getDataType().removeParent(this);
                this.removeComponent(dtc.getKey());
            }
            this.components.clear();
            this.setAlignment(union, notify);
            for (DataTypeComponent dtc : union.getComponents()) {
                DataType dt = dtc.getDataType();
                this.doAdd(dt, dtc.getLength(), dtc.getFieldName(), dtc.getComment());
            }
            this.adjustLength(notify, true);
            if (notify && oldMinAlignment != (long)this.getMinimumAlignment()) {
                this.notifyAlignmentChanged();
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPartOf(DataType dataType) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.equals(dataType)) {
                boolean bl = true;
                return bl;
            }
            for (DataTypeComponent dataTypeComponent : this.components) {
                DataType subDt = dataTypeComponent.getDataType();
                if (subDt instanceof Composite) {
                    if (!((Composite)subDt).isPartOf(dataType)) continue;
                    boolean bl = true;
                    return bl;
                }
                if (!subDt.equals(dataType)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public int getNumComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            int n = this.components.size();
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent getComponent(int ordinal) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (ordinal < 0 || ordinal >= this.components.size()) {
                DataTypeComponent dataTypeComponent = null;
                return dataTypeComponent;
            }
            DataTypeComponent dataTypeComponent = this.components.get(ordinal);
            return dataTypeComponent;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataTypeComponent[] getComponents() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            DataTypeComponent[] dataTypeComponentArray = this.components.toArray(new DataTypeComponent[this.components.size()]);
            return dataTypeComponentArray;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        UnionDataType union = new UnionDataType(this.getCategoryPath(), this.getName(), this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
        union.setDescription(this.getDescription());
        union.replaceWith(this);
        return union;
    }

    @Override
    public int getLength() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.unionLength == 0) {
                int n = 1;
                return n;
            }
            int n = this.unionLength;
            return n;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeSizeChanged(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean changed = false;
            for (DataTypeComponentDB dtc : this.components) {
                int length = dtc.getLength();
                if (dtc.getDataType() != dt) continue;
                length = this.getPreferredComponentLength(dt, length);
                dtc.setLength(length, true);
                changed = true;
            }
            if (changed) {
                this.adjustLength(true, false);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeAlignmentChanged(DataType dt) {
        this.adjustInternalAlignment(true);
    }

    private DataType adjustBitField(DataType dataType) {
        if (!(dataType instanceof BitFieldDataType)) {
            return dataType;
        }
        BitFieldDataType bitfieldDt = (BitFieldDataType)dataType;
        DataType baseDataType = bitfieldDt.getBaseDataType();
        baseDataType = this.resolve(baseDataType);
        int bitSize = bitfieldDt.getDeclaredBitSize();
        int effectiveBitSize = BitFieldDataType.getEffectiveBitSize(bitSize, baseDataType.getLength());
        boolean bigEndian = this.getDataOrganization().isBigEndian();
        int storageBitOffset = 0;
        if (bigEndian) {
            if (bitSize == 0) {
                storageBitOffset = 7;
            } else {
                int storageSize = BitFieldDataType.getMinimumStorageSize(effectiveBitSize);
                storageBitOffset = 8 * storageSize - effectiveBitSize;
            }
        }
        if (effectiveBitSize != bitfieldDt.getBitSize() || storageBitOffset != bitfieldDt.getBitOffset()) {
            try {
                bitfieldDt = new BitFieldDBDataType(baseDataType, effectiveBitSize, storageBitOffset);
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                // empty catch block
            }
        }
        return bitfieldDt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustLength(boolean notify, boolean setLastChangeTime) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            int oldLength = this.unionLength;
            this.unionLength = 0;
            for (DataTypeComponent dataTypeComponent : this.components) {
                int length = dataTypeComponent.getLength();
                if (this.isInternallyAligned() && dataTypeComponent.isBitFieldComponent()) {
                    length = this.getBitFieldAllocation((BitFieldDataType)dataTypeComponent.getDataType());
                }
                this.unionLength = Math.max(length, this.unionLength);
            }
            DataOrganization dataOrganization = this.getDataOrganization();
            int n = dataOrganization.getAlignment(this, this.unionLength);
            int amountFilled = this.unionLength % n;
            if (amountFilled > 0) {
                this.unionLength += n - amountFilled;
            }
            this.updateLength(oldLength, notify, setLastChangeTime);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeDeleted(DataType dt) {
        this.lock.acquire();
        try {
            this.checkDeleted();
            boolean didChange = false;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                boolean removeBitFieldComponent = false;
                if (dtc.isBitFieldComponent()) {
                    BitFieldDataType bitfieldDt = (BitFieldDataType)dtc.getDataType();
                    boolean bl = removeBitFieldComponent = bitfieldDt.getBaseDataType() == dt;
                }
                if (!removeBitFieldComponent && dtc.getDataType() != dt) continue;
                dt.removeParent(this);
                this.components.remove(i);
                this.removeComponent(dtc.getKey());
                this.shiftOrdinals(i, -1);
                didChange = true;
            }
            if (didChange) {
                this.adjustLength(true, true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isEquivalent(DataType dt) {
        DataTypeComponent[] otherComps;
        if (dt == this) {
            return true;
        }
        if (dt == null || !(dt instanceof Union)) {
            return false;
        }
        this.checkIsValid();
        if (this.resolving) {
            if (dt.getUniversalID().equals((Object)this.getUniversalID())) {
                return true;
            }
            return DataTypeUtilities.equalsIgnoreConflict(this.getPathName(), dt.getPathName());
        }
        Union union = (Union)dt;
        if (this.isInternallyAligned() != union.isInternallyAligned() || this.isDefaultAligned() != union.isDefaultAligned() || this.isMachineAligned() != union.isMachineAligned() || this.getMinimumAlignment() != union.getMinimumAlignment() || this.getPackingValue() != union.getPackingValue()) {
            return false;
        }
        DataTypeComponent[] myComps = this.getComponents();
        if (myComps.length != (otherComps = union.getComponents()).length) {
            return false;
        }
        for (int i = 0; i < myComps.length; ++i) {
            if (myComps[i].isEquivalent(otherComps[i])) continue;
            return false;
        }
        return true;
    }

    private void updateLength(int oldLength, boolean notify, boolean setLastChangeTime) {
        if (oldLength != this.unionLength) {
            this.record.setIntValue(4, this.unionLength);
            try {
                this.compositeAdapter.updateRecord(this.record, setLastChangeTime);
            }
            catch (IOException e) {
                this.dataMgr.dbError(e);
            }
            this.notifySizeChanged();
        } else if (notify) {
            this.dataMgr.dataTypeChanged(this);
        }
    }

    private void shiftOrdinals(int ordinal, int deltaOrdinal) {
        for (int i = ordinal; i < this.components.size(); ++i) {
            DataTypeComponentDB dtc = this.components.get(i);
            dtc.setOrdinal(dtc.getOrdinal() + deltaOrdinal, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        if (oldDt == this) {
            return;
        }
        this.lock.acquire();
        try {
            this.checkDeleted();
            DataType replacementDt = newDt;
            try {
                this.validateDataType(replacementDt);
                if (!(replacementDt instanceof DataTypeDB) || replacementDt.getDataTypeManager() != this.getDataTypeManager()) {
                    replacementDt = this.resolve(replacementDt);
                }
                this.checkAncestry(replacementDt);
            }
            catch (Exception e) {
                replacementDt = DataType.DEFAULT;
            }
            boolean changed = false;
            for (int i = this.components.size() - 1; i >= 0; --i) {
                DataTypeComponentDB dtc = this.components.get(i);
                boolean remove = false;
                if (dtc.isBitFieldComponent()) {
                    try {
                        changed |= this.updateBitFieldDataType(dtc, oldDt, replacementDt);
                    }
                    catch (InvalidDataTypeException e) {
                        Msg.error((Object)this, (Object)("Invalid bitfield replacement type " + newDt.getName() + ", removing bitfield " + dtc.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    }
                } else if (dtc.getDataType() == oldDt) {
                    if (replacementDt == DEFAULT) {
                        Msg.error((Object)this, (Object)("Invalid replacement type " + newDt.getName() + ", removing component " + dtc.getDataType().getName() + ": " + this.getPathName()));
                        remove = true;
                    } else {
                        oldDt.removeParent(this);
                        dtc.setDataType(replacementDt);
                        replacementDt.addParent(this);
                        int len = replacementDt.getLength();
                        if (len > 0) {
                            dtc.setLength(len, true);
                        }
                        changed = true;
                    }
                }
                if (!remove) continue;
                oldDt.removeParent(this);
                this.components.remove(i);
                this.removeComponent(dtc.getKey());
                this.shiftOrdinals(i, -1);
                changed = true;
            }
            if (changed) {
                this.adjustLength(true, true);
            }
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dependsOn(DataType dt) {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.getNumComponents() == 1) {
                DataTypeComponent dtc = this.getComponent(0);
                boolean bl = dtc.getDataType().dependsOn(dt);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "UNION_" + this.getName();
    }

    @Override
    public void realign() {
        if (this.isInternallyAligned()) {
            this.adjustInternalAlignment(true);
        }
    }

    @Override
    public void adjustInternalAlignment(boolean notify) {
        this.adjustLength(notify, false);
    }

    private static class MemberComparator
    implements Comparator<DataTypeComponent> {
        private MemberComparator() {
        }

        @Override
        public int compare(DataTypeComponent dtc1, DataTypeComponent dtc2) {
            return dtc1.getOrdinal() - dtc2.getOrdinal();
        }
    }
}

