/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.Record;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.GhidraClassDB;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;

public class ClassSymbol
extends SymbolDB {
    private GhidraClassDB ghidraClass;

    public ClassSymbol(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, Address address, Record record) {
        super(symbolMgr, cache, address, record);
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.CLASS;
    }

    @Override
    public Object getObject() {
        this.lock.acquire();
        try {
            this.checkIsValid();
            if (this.ghidraClass == null) {
                this.ghidraClass = new GhidraClassDB(this, this.symbolMgr.getProgram().getNamespaceManager());
            }
            GhidraClassDB ghidraClassDB = this.ghidraClass;
            return ghidraClassDB;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isExternal() {
        Symbol parentSymbol = this.getParentSymbol();
        return parentSymbol != null ? parentSymbol.isExternal() : false;
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return SymbolType.CLASS.isValidParent(this.symbolMgr.getProgram(), parent, this.address, this.isExternal());
    }
}

