/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.List;

public class InjectPayloadCallfixup
extends InjectPayloadSleigh {
    private List<String> targetSymbolNames;

    public InjectPayloadCallfixup(String sourceName) {
        super(sourceName);
        this.type = 1;
        this.targetSymbolNames = new ArrayList<String>();
    }

    public List<String> getTargets() {
        return this.targetSymbolNames;
    }

    @Override
    public InjectPayloadSleigh clone() {
        InjectPayloadCallfixup res = new InjectPayloadCallfixup(this.source);
        ((InjectPayloadSleigh)res).copy(this);
        return res;
    }

    @Override
    protected void copy(InjectPayloadSleigh op2) {
        super.copy(op2);
        InjectPayloadCallfixup fixup = (InjectPayloadCallfixup)op2;
        for (String target : fixup.targetSymbolNames) {
            this.targetSymbolNames.add(target);
        }
    }

    @Override
    public void restoreXml(XmlPullParser parser) {
        XmlElement fixupEl = parser.start(new String[]{"callfixup"});
        this.name = fixupEl.getAttribute("name");
        boolean pcodeSubtag = false;
        while (parser.peek().isStart()) {
            String elname = parser.peek().getName();
            if (elname.equals("target")) {
                XmlElement subel = parser.start(new String[0]);
                String targetName = subel.getAttribute("name");
                if (targetName == null) {
                    throw new SleighException("Invalid callfixup target, missing target name");
                }
                this.targetSymbolNames.add(targetName);
                parser.end(subel);
                continue;
            }
            if (elname.equals("pcode")) {
                super.restoreXml(parser);
                pcodeSubtag = true;
                continue;
            }
            throw new SleighException("Unknown callfixup tag: " + elname);
        }
        if (!pcodeSubtag) {
            throw new SleighException("<callfixup> missing <pcode> subtag: " + this.name);
        }
        parser.end(fixupEl);
    }
}

