/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.coff.CoffSymbolAux;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CoffSymbolAuxBeginningOfBlock
implements CoffSymbolAux {
    private byte[] unused1;
    private short sourceLineNumber;
    private byte[] unused2;
    private int nextEntryIndex;
    private byte[] unused3;

    CoffSymbolAuxBeginningOfBlock(BinaryReader reader) throws IOException {
        this.unused1 = reader.readNextByteArray(4);
        this.sourceLineNumber = reader.readNextShort();
        this.unused2 = reader.readNextByteArray(5);
        this.nextEntryIndex = reader.readNextInt();
        this.unused3 = reader.readNextByteArray(2);
    }

    public byte[] getUnused1() {
        return this.unused1;
    }

    public short getSourceLineNumber() {
        return this.sourceLineNumber;
    }

    public byte[] getUnused2() {
        return this.unused2;
    }

    public int getNextEntryIndex() {
        return this.nextEntryIndex;
    }

    public byte[] getUnused3() {
        return this.unused3;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType(this);
    }
}

