/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.resource;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class VS_VERSION_CHILD
implements StructConverter {
    private String parentName;
    private long relativeOffset;
    private String childName;
    private short childSize;
    private short childValueSize;
    private short childValueType;
    private String childDataType;
    private int valueAlignment;
    private String childValue;
    private ArrayList<VS_VERSION_CHILD> children;

    VS_VERSION_CHILD(FactoryBundledWithBinaryReader reader, long relativeOffset, String parentName, HashMap<String, String> valueMap) throws IOException {
        this.relativeOffset = relativeOffset;
        this.parentName = parentName;
        long origIndex = reader.getPointerIndex();
        this.childSize = reader.readNextShort();
        if (this.childSize == 0) {
            return;
        }
        this.childValueSize = reader.readNextShort();
        this.childValueType = reader.readNextShort();
        this.childName = reader.readNextUnicodeString();
        this.valueAlignment = reader.align(4);
        boolean hasChildren = false;
        if (parentName == null) {
            this.childDataType = this.childName;
            hasChildren = true;
        } else if ("StringFileInfo".equals(parentName)) {
            this.childDataType = "StringTable";
            hasChildren = true;
        } else if ("VarFileInfo".equals(parentName)) {
            this.childDataType = "Var";
            if (this.childValueSize > 0) {
                this.childValue = Integer.toHexString(reader.readNextInt());
            }
        } else if ("StringTable".equals(parentName)) {
            this.childDataType = "StringInfo";
            if (this.childValueSize > 0) {
                this.childValue = reader.readNextUnicodeString();
            }
        }
        if (hasChildren) {
            while (reader.getPointerIndex() < origIndex + (long)this.childSize) {
                VS_VERSION_CHILD child = new VS_VERSION_CHILD(reader, reader.getPointerIndex() - origIndex, this.childDataType, valueMap);
                if (this.children == null) {
                    this.children = new ArrayList();
                }
                this.children.add(child);
            }
        } else if (this.childValueSize > 0 && this.childValue != null) {
            valueMap.put(this.childName, this.childValue);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        if (this.childName == null || this.childDataType == null) {
            return null;
        }
        StructureDataType struct = new StructureDataType(this.childDataType, 0);
        struct.add(WORD, "wLength", null);
        struct.add(WORD, "wValueLength", null);
        struct.add(WORD, "wType", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public VS_VERSION_CHILD[] getChildren() {
        VS_VERSION_CHILD[] arr = new VS_VERSION_CHILD[this.children.size()];
        this.children.toArray(arr);
        return arr;
    }

    public long getRelativeOffset() {
        return this.relativeOffset;
    }

    public String getChildName() {
        return this.childName;
    }

    public short getChildSize() {
        return this.childSize;
    }

    public long getValueRelativeOffset() {
        if (this.childValue == null) {
            return 0L;
        }
        return (this.childName.length() + 1) * 2 + this.valueAlignment + 6;
    }

    public long getNameRelativeOffset() {
        if (this.childSize == 0) {
            return 0L;
        }
        return 6L;
    }

    public boolean valueIsUnicodeString() {
        return this.childValue != null && "StringInfo".equals(this.childDataType);
    }

    public boolean valueIsDWord() {
        return this.childValue != null && "Var".equals(this.childDataType);
    }

    public boolean hasChildren() {
        return this.children != null;
    }
}

