/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.acl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlList;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.AccessControlPolicy;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.api.security.principal.PrincipalManager;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.observation.SynchronousEventListener;
import org.apache.jackrabbit.core.security.authorization.AbstractAccessControlProvider;
import org.apache.jackrabbit.core.security.authorization.AbstractCompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEditor;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryIterator;
import org.apache.jackrabbit.core.security.authorization.CompiledPermissions;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlEntry;
import org.apache.jackrabbit.core.security.authorization.Permission;
import org.apache.jackrabbit.core.security.authorization.UnmodifiableAccessControlList;
import org.apache.jackrabbit.core.security.authorization.acl.ACLEditor;
import org.apache.jackrabbit.core.security.authorization.acl.ACLTemplate;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLProvider
extends AbstractAccessControlProvider
implements AccessControlConstants {
    private static final Logger log = LoggerFactory.getLogger((Class)ACLProvider.class);
    private ACLEditor systemEditor;
    private NodeId rootNodeId;
    private boolean initializedWithDefaults;

    public boolean isAcItem(Path absPath) throws RepositoryException {
        Path.Element[] elems = absPath.getElements();
        for (int i = 0; i < elems.length; ++i) {
            if (!N_POLICY.equals(elems[i].getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAcItem(ItemImpl item) throws RepositoryException {
        NodeImpl n = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        return n.isNodeType(NT_REP_ACL) || n.isNodeType(NT_REP_ACE);
    }

    public void init(Session systemSession, Map configuration) throws RepositoryException {
        super.init(systemSession, configuration);
        NodeImpl root = (NodeImpl)this.session.getRootNode();
        this.rootNodeId = root.getNodeId();
        this.systemEditor = new ACLEditor(systemSession, this);
        boolean bl = this.initializedWithDefaults = !configuration.containsKey("omit-default-permission");
        if (this.initializedWithDefaults && !ACLProvider.isAccessControlled(root)) {
            ACLProvider.initRootACL(this.session, this.systemEditor);
        }
    }

    public AccessControlPolicy[] getEffectivePolicies(Path absPath) throws ItemNotFoundException, RepositoryException {
        this.checkInitialized();
        NodeImpl targetNode = (NodeImpl)this.session.getNode(this.session.getJCRPath(absPath));
        NodeImpl node = this.getNode(targetNode);
        ArrayList<UnmodifiableAccessControlList> acls = new ArrayList<UnmodifiableAccessControlList>();
        this.collectAcls(node, acls);
        if (acls.isEmpty()) {
            log.warn("No access controlled node present in item hierarchy starting from " + targetNode.getPath());
            acls.add(new UnmodifiableAccessControlList(Collections.EMPTY_LIST));
        }
        return acls.toArray(new AccessControlList[acls.size()]);
    }

    public AccessControlEditor getEditor(Session session) {
        this.checkInitialized();
        return new ACLEditor(session, this);
    }

    public CompiledPermissions compilePermissions(Set principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return ACLProvider.getAdminPermissions();
        }
        if (this.isReadOnly(principals)) {
            return this.getReadOnlyPermissions();
        }
        return new AclPermissions(principals);
    }

    public boolean canAccessRoot(Set principals) throws RepositoryException {
        this.checkInitialized();
        if (this.isAdminOrSystem(principals)) {
            return true;
        }
        AclPermissions cp = new AclPermissions(principals, false);
        return cp.grants(PathFactoryImpl.getInstance().getRootPath(), 1);
    }

    private NodeImpl getNode(NodeImpl targetNode) throws RepositoryException {
        NodeImpl node = this.isAcItem(targetNode) ? (targetNode.isNodeType(NT_REP_ACL) ? (NodeImpl)targetNode.getParent() : (NodeImpl)targetNode.getParent().getParent()) : targetNode;
        return node;
    }

    private void collectAcls(NodeImpl node, List acls) throws RepositoryException {
        if (ACLProvider.isAccessControlled(node)) {
            NodeImpl aclNode = node.getNode(N_POLICY);
            AccessControlList acl = this.systemEditor.getACL(aclNode);
            acls.add(new UnmodifiableAccessControlList(acl));
        }
        if (!this.rootNodeId.equals(node.getId())) {
            NodeImpl parentNode = (NodeImpl)node.getParent();
            this.collectAcls(parentNode, acls);
        }
    }

    private static void initRootACL(SessionImpl session, AccessControlEditor editor) throws RepositoryException {
        try {
            Principal administrators;
            log.info("Install initial ACL:...");
            String rootPath = session.getRootNode().getPath();
            AccessControlPolicy[] acls = editor.editAccessControlPolicies(rootPath);
            ACLTemplate acl = (ACLTemplate)acls[0];
            PrincipalManager pMgr = session.getPrincipalManager();
            AccessControlManager acMgr = session.getAccessControlManager();
            log.info("... Privilege.ALL for administrators.");
            String pName = "administrators";
            if (pMgr.hasPrincipal(pName)) {
                administrators = pMgr.getPrincipal(pName);
            } else {
                log.warn("Administrators principal group is missing.");
                administrators = new PrincipalImpl(pName);
            }
            Privilege[] privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}all")};
            acl.addAccessControlEntry(administrators, privs);
            Principal everyone = pMgr.getEveryone();
            log.info("... Privilege.READ for everyone.");
            privs = new Privilege[]{acMgr.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")};
            acl.addAccessControlEntry(everyone, privs);
            editor.setPolicy(rootPath, acl);
            session.save();
            log.info("... done.");
        }
        catch (RepositoryException e) {
            log.error("Failed to set-up minimal access control for root node of workspace " + session.getWorkspace().getName());
            session.getRootNode().refresh(false);
            throw e;
        }
    }

    static boolean isAccessControlled(NodeImpl node) throws RepositoryException {
        return node.isNodeType(NT_REP_ACCESS_CONTROLLABLE) && node.hasNode(N_POLICY);
    }

    private class Entries {
        private final ListOrderedMap principalNamesToEntries = new ListOrderedMap();

        private Entries(NodeImpl node, Collection principalNames) throws RepositoryException {
            Iterator it = principalNames.iterator();
            while (it.hasNext()) {
                this.principalNamesToEntries.put(it.next(), new ArrayList());
            }
            this.collectEntries(node);
        }

        private void collectEntries(NodeImpl node) throws RepositoryException {
            if (ACLProvider.isAccessControlled(node)) {
                NodeImpl aclNode = node.getNode(AccessControlConstants.N_POLICY);
                ACLTemplate.collectEntries(aclNode, (Map)this.principalNamesToEntries);
            }
            if (!ACLProvider.this.rootNodeId.equals(node.getId())) {
                NodeImpl parentNode = (NodeImpl)node.getParent();
                this.collectEntries(parentNode);
            }
        }

        private AccessControlEntryIterator iterator() {
            ArrayList entries = new ArrayList();
            Iterator it = this.principalNamesToEntries.asList().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                entries.addAll((List)this.principalNamesToEntries.get(key));
            }
            return new AccessControlEntryIterator(entries);
        }
    }

    private class AclPermissions
    extends AbstractCompiledPermissions
    implements SynchronousEventListener {
        private final List principalNames;
        private final String jcrReadPrivilegeName;
        private boolean readAllowed = false;

        private AclPermissions(Set principals) throws RepositoryException {
            this(principals, true);
        }

        private AclPermissions(Set principals, boolean listenToEvents) throws RepositoryException {
            this.principalNames = new ArrayList(principals.size());
            Iterator it = principals.iterator();
            while (it.hasNext()) {
                this.principalNames.add(((Principal)it.next()).getName());
            }
            this.jcrReadPrivilegeName = ACLProvider.this.session.getAccessControlManager().privilegeFromName("{http://www.jcp.org/jcr/1.0}read").getName();
            if (listenToEvents) {
                this.readAllowed = this.isReadAllowed(this.principalNames);
                int events = 19;
                String[] ntNames = new String[]{ACLProvider.this.resolver.getJCRName(AccessControlConstants.NT_REP_ACE), ACLProvider.this.resolver.getJCRName(AccessControlConstants.NT_REP_ACL)};
                ACLProvider.this.observationMgr.addEventListener((EventListener)this, events, ACLProvider.this.session.getRootNode().getPath(), true, null, ntNames, true);
            }
        }

        private boolean isReadAllowed(Collection principalnames) {
            boolean isReadAllowed = false;
            if (ACLProvider.this.initializedWithDefaults) {
                try {
                    QueryManager qm = ACLProvider.this.session.getWorkspace().getQueryManager();
                    StringBuffer stmt = new StringBuffer("/jcr:root");
                    stmt.append("//element(*,");
                    stmt.append(ACLProvider.this.resolver.getJCRName(AccessControlConstants.NT_REP_DENY_ACE));
                    stmt.append(")[(");
                    int i = 0;
                    Iterator itr = principalnames.iterator();
                    while (itr.hasNext()) {
                        stmt.append("@").append(ACLProvider.this.resolver.getJCRName(AccessControlConstants.P_PRINCIPAL_NAME)).append(" eq ");
                        stmt.append("'").append(itr.next().toString()).append("'");
                        if (++i >= principalnames.size()) continue;
                        stmt.append(" or ");
                    }
                    stmt.append(") and @");
                    stmt.append(ACLProvider.this.resolver.getJCRName(AccessControlConstants.P_PRIVILEGES));
                    stmt.append(" = '").append(this.jcrReadPrivilegeName).append("']");
                    Query q = qm.createQuery(stmt.toString(), "xpath");
                    NodeIterator it = q.execute().getNodes();
                    isReadAllowed = !it.hasNext();
                }
                catch (RepositoryException e) {
                    log.error(e.toString());
                }
            }
            return isReadAllowed;
        }

        protected AbstractCompiledPermissions.Result buildResult(Path absPath) throws RepositoryException {
            List<AccessControlEntry> localACEs;
            boolean existingNode = false;
            NodeImpl node = null;
            String jcrPath = ACLProvider.this.resolver.getJCRPath(absPath);
            if (ACLProvider.this.session.nodeExists(jcrPath)) {
                node = (NodeImpl)ACLProvider.this.session.getNode(jcrPath);
                existingNode = true;
            } else {
                String parentPath = Text.getRelativeParent(jcrPath, 1);
                while (parentPath.length() > 0) {
                    if (ACLProvider.this.session.nodeExists(parentPath)) {
                        node = (NodeImpl)ACLProvider.this.session.getNode(parentPath);
                        break;
                    }
                    parentPath = Text.getRelativeParent(parentPath, 1);
                }
            }
            if (node == null) {
                throw new ItemNotFoundException("Item out of hierarchy.");
            }
            boolean isAcItem = ACLProvider.this.isAcItem(absPath);
            AccessControlEntryIterator entries = new Entries(ACLProvider.this.getNode(node), this.principalNames).iterator();
            if (existingNode && ACLProvider.isAccessControlled(node)) {
                NodeImpl aclNode = node.getNode(AccessControlConstants.N_POLICY);
                localACEs = Arrays.asList(ACLProvider.this.systemEditor.getACL(aclNode).getAccessControlEntries());
            } else {
                localACEs = Collections.EMPTY_LIST;
            }
            int allows = 0;
            int denies = 0;
            int allowPrivileges = 0;
            int denyPrivileges = 0;
            int parentAllows = 0;
            int parentDenies = 0;
            while (entries.hasNext() && allows != 127) {
                int permissions;
                JackrabbitAccessControlEntry ace = (JackrabbitAccessControlEntry)entries.next();
                int entryBits = ace.getPrivilegeBits();
                boolean isLocal = localACEs.contains(ace);
                if (!isLocal) {
                    if (ace.isAllow()) {
                        parentAllows |= Permission.diff(entryBits, parentDenies);
                    } else {
                        parentDenies |= Permission.diff(entryBits, parentAllows);
                    }
                }
                if (ace.isAllow()) {
                    permissions = Permission.calculatePermissions(allowPrivileges |= Permission.diff(entryBits, denyPrivileges), parentAllows, true, isAcItem);
                    allows |= Permission.diff(permissions, denies);
                    continue;
                }
                permissions = Permission.calculatePermissions(denyPrivileges |= Permission.diff(entryBits, allowPrivileges), parentDenies, false, isAcItem);
                denies |= Permission.diff(permissions, allows);
            }
            return new AbstractCompiledPermissions.Result(allows, denies, allowPrivileges, denyPrivileges);
        }

        public void close() {
            try {
                ACLProvider.this.observationMgr.removeEventListener((EventListener)this);
            }
            catch (RepositoryException e) {
                log.debug("Unable to unregister listener: ", (Object)e.getMessage());
            }
            super.close();
        }

        public boolean grants(Path absPath, int permissions) throws RepositoryException {
            if (permissions == 1 && this.readAllowed && !ACLProvider.this.isAcItem(absPath)) {
                return true;
            }
            return super.grants(absPath, permissions);
        }

        public synchronized void onEvent(EventIterator events) {
            boolean clearCache = false;
            block7: while (events.hasNext() && !clearCache) {
                try {
                    Event ev = events.nextEvent();
                    String path = ev.getPath();
                    switch (ev.getType()) {
                        case 1: {
                            NodeImpl n = (NodeImpl)ACLProvider.this.session.getNode(path);
                            if (!n.isNodeType(AccessControlConstants.NT_REP_ACE) || !this.principalNames.contains(n.getProperty(AccessControlConstants.P_PRINCIPAL_NAME).getString())) break;
                            if (this.readAllowed && n.isNodeType(AccessControlConstants.NT_REP_DENY_ACE)) {
                                Value[] vs = n.getProperty(AccessControlConstants.P_PRIVILEGES).getValues();
                                for (int i = 0; i < vs.length; ++i) {
                                    if (!this.jcrReadPrivilegeName.equals(vs[i].getString())) continue;
                                    this.readAllowed = false;
                                }
                            }
                            clearCache = true;
                            break;
                        }
                        case 2: 
                        case 8: {
                            this.readAllowed = this.isReadAllowed(this.principalNames);
                            clearCache = true;
                            break;
                        }
                        case 4: 
                        case 16: {
                            PropertyImpl p = (PropertyImpl)ACLProvider.this.session.getProperty(path);
                            NodeImpl parent = (NodeImpl)p.getParent();
                            if (!parent.isNodeType(AccessControlConstants.NT_REP_ACE)) break;
                            String principalName = null;
                            if (AccessControlConstants.P_PRIVILEGES.equals(p.getQName())) {
                                principalName = parent.getProperty(AccessControlConstants.P_PRINCIPAL_NAME).getString();
                            } else if (AccessControlConstants.P_PRINCIPAL_NAME.equals(p.getQName())) {
                                principalName = p.getString();
                            }
                            if (principalName == null || !this.principalNames.contains(principalName)) continue block7;
                            this.readAllowed = this.isReadAllowed(this.principalNames);
                            clearCache = true;
                            break;
                        }
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Internal error: ", (Object)e.getMessage());
                }
            }
            if (clearCache) {
                this.clearCache();
            }
        }
    }
}

