/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.UpdatableItemStateManager;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;

public class NodeStateEx {
    private NodeState nodeState;
    private final UpdatableItemStateManager stateMgr;
    private final NodeTypeRegistry ntReg;
    private Name name;

    public NodeStateEx(UpdatableItemStateManager stateMgr, NodeTypeRegistry ntReg, NodeState nodeState, Name name) {
        this.nodeState = nodeState;
        this.ntReg = ntReg;
        this.stateMgr = stateMgr;
        this.name = name;
    }

    public Name getName() {
        if (this.name == null) {
            try {
                NodeId parentId = this.nodeState.getParentId();
                NodeState parent = (NodeState)this.stateMgr.getItemState(parentId);
                this.name = parent.getChildNodeEntry(this.nodeState.getNodeId()).getName();
            }
            catch (ItemStateException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        return this.name;
    }

    public NodeId getNodeId() {
        return this.nodeState.getNodeId();
    }

    public NodeId getParentId() {
        return this.nodeState.getParentId();
    }

    public NodeState getState() {
        return this.nodeState;
    }

    public PropertyState[] getProperties() throws ItemStateException {
        Set set = this.nodeState.getPropertyNames();
        PropertyState[] props = new PropertyState[set.size()];
        int i = 0;
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            Name propName = (Name)iter.next();
            PropertyId propId = new PropertyId(this.nodeState.getNodeId(), propName);
            props[i++] = (PropertyState)this.stateMgr.getItemState(propId);
        }
        return props;
    }

    public boolean hasProperty(Name name) {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        return this.stateMgr.hasItemState(propId);
    }

    public InternalValue[] getPropertyValues(Name name) {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        try {
            PropertyState ps = (PropertyState)this.stateMgr.getItemState(propId);
            return ps.getValues();
        }
        catch (ItemStateException e) {
            return null;
        }
    }

    public InternalValue getPropertyValue(Name name) {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        try {
            PropertyState ps = (PropertyState)this.stateMgr.getItemState(propId);
            return ps.getValues()[0];
        }
        catch (ItemStateException e) {
            return null;
        }
    }

    public void setPropertyValue(Name name, InternalValue value) throws RepositoryException {
        this.setPropertyValues(name, value.getType(), new InternalValue[]{value}, false);
    }

    public void setPropertyValues(Name name, int type, InternalValue[] values) throws RepositoryException {
        this.setPropertyValues(name, type, values, true);
    }

    public void setPropertyValues(Name name, int type, InternalValue[] values, boolean multiple) throws RepositoryException {
        PropertyState prop = this.getOrCreatePropertyState(name, type, multiple);
        prop.setValues(values);
    }

    private PropertyState getOrCreatePropertyState(Name name, int type, boolean multiValued) throws RepositoryException {
        PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
        if (this.stateMgr.hasItemState(propId)) {
            try {
                PropertyState propState = (PropertyState)this.stateMgr.getItemState(propId);
                if (propState.getStatus() == 1) {
                    propState.setStatus(2);
                }
                if (this.nodeState.getStatus() == 1) {
                    this.nodeState.setStatus(2);
                }
                return propState;
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Unable to create property: " + e.toString());
            }
        }
        PropertyState propState = this.stateMgr.createNew(name, this.nodeState.getNodeId());
        propState.setType(type);
        propState.setMultiValued(multiValued);
        PropDef pd = this.getEffectiveNodeType().getApplicablePropertyDef(name, type, multiValued);
        propState.setDefinitionId(pd.getId());
        this.nodeState.addPropertyName(name);
        if (this.nodeState.getStatus() == 1) {
            this.nodeState.setStatus(2);
        }
        return propState;
    }

    public EffectiveNodeType getEffectiveNodeType() throws RepositoryException {
        try {
            return this.ntReg.getEffectiveNodeType(this.nodeState.getNodeTypeName(), this.nodeState.getMixinTypeNames());
        }
        catch (NodeTypeConflictException ntce) {
            String msg = "internal error: failed to build effective node type for node " + this.nodeState.getNodeId();
            throw new RepositoryException(msg, (Throwable)ntce);
        }
    }

    public boolean hasNode(Name name) {
        return this.nodeState.hasChildNodeEntry(name);
    }

    public boolean removeNode(Name name) throws RepositoryException {
        return this.removeNode(name, 1);
    }

    public boolean removeNode(Name name, int index) throws RepositoryException {
        try {
            ChildNodeEntry entry = this.nodeState.getChildNodeEntry(name, index);
            if (entry == null) {
                return false;
            }
            this.removeNode(entry.getId());
            this.nodeState.removeChildNodeEntry(name, index);
            this.nodeState.setStatus(2);
            return true;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void removeNode(NodeId id) throws ItemStateException {
        NodeState state = (NodeState)this.stateMgr.getItemState(id);
        Iterator iter = state.getPropertyNames().iterator();
        while (iter.hasNext()) {
            Name name = (Name)iter.next();
            PropertyId propId = new PropertyId(id, name);
            PropertyState propState = (PropertyState)this.stateMgr.getItemState(propId);
            this.stateMgr.destroy(propState);
        }
        state.removeAllPropertyNames();
        iter = state.getChildNodeEntries().iterator();
        while (iter.hasNext()) {
            ChildNodeEntry entry = (ChildNodeEntry)iter.next();
            this.removeNode(entry.getId());
        }
        state.removeAllChildNodeEntries();
        this.stateMgr.destroy(state);
    }

    public boolean removeProperty(Name name) throws RepositoryException {
        try {
            if (!this.nodeState.hasPropertyName(name)) {
                return false;
            }
            PropertyId propId = new PropertyId(this.nodeState.getNodeId(), name);
            ItemState state = this.stateMgr.getItemState(propId);
            this.stateMgr.destroy(state);
            this.nodeState.removePropertyName(name);
            this.nodeState.setStatus(2);
            return true;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public NodeStateEx getNode(Name name, int index) throws RepositoryException {
        ChildNodeEntry entry = this.nodeState.getChildNodeEntry(name, index);
        if (entry == null) {
            return null;
        }
        try {
            NodeState state = (NodeState)this.stateMgr.getItemState(entry.getId());
            return new NodeStateEx(this.stateMgr, this.ntReg, state, name);
        }
        catch (ItemStateException e) {
            throw new RepositoryException("Unable to getNode: " + e.toString());
        }
    }

    public NodeStateEx addNode(Name nodeName, Name nodeTypeName, NodeId id, boolean referenceable) throws NoSuchNodeTypeException, ConstraintViolationException, RepositoryException {
        NodeStateEx node = this.createChildNode(nodeName, nodeTypeName, id);
        if (referenceable) {
            node.setPropertyValue(NameConstants.JCR_UUID, InternalValue.create(node.getNodeId().getUUID().toString()));
        }
        return node;
    }

    private NodeStateEx createChildNode(Name name, Name nodeTypeName, NodeId id) throws RepositoryException {
        NodeId parentId = this.nodeState.getNodeId();
        if (id == null) {
            id = new NodeId(UUID.randomUUID());
        }
        NodeState state = this.stateMgr.createNew(id, nodeTypeName, parentId);
        NodeDef cnd = this.getEffectiveNodeType().getApplicableChildNodeDef(name, nodeTypeName, this.ntReg);
        state.setDefinitionId(cnd.getId());
        NodeStateEx node = new NodeStateEx(this.stateMgr, this.ntReg, state, name);
        node.setPropertyValue(NameConstants.JCR_PRIMARYTYPE, InternalValue.create(nodeTypeName));
        this.nodeState.addChildNodeEntry(name, id);
        if (this.nodeState.getStatus() == 1) {
            this.nodeState.setStatus(2);
        }
        return node;
    }

    public NodeStateEx[] getChildNodes() throws RepositoryException {
        try {
            List entries = this.nodeState.getChildNodeEntries();
            NodeStateEx[] children = new NodeStateEx[entries.size()];
            for (int i = 0; i < entries.size(); ++i) {
                ChildNodeEntry entry = (ChildNodeEntry)entries.get(i);
                NodeState state = (NodeState)this.stateMgr.getItemState(entry.getId());
                children[i] = new NodeStateEx(this.stateMgr, this.ntReg, state, entry.getName());
            }
            return children;
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void store() throws RepositoryException {
        try {
            this.store(this.nodeState);
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void store(NodeState state) throws ItemStateException {
        if (state.getStatus() != 1) {
            Set props = state.getPropertyNames();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                Name propName = (Name)iter.next();
                PropertyState pstate = (PropertyState)this.stateMgr.getItemState(new PropertyId(state.getNodeId(), propName));
                if (pstate.getStatus() == 1) continue;
                this.stateMgr.store(pstate);
            }
            List nodes = state.getChildNodeEntries();
            for (int i = 0; i < nodes.size(); ++i) {
                ChildNodeEntry entry = (ChildNodeEntry)nodes.get(i);
                NodeState nstate = (NodeState)this.stateMgr.getItemState(entry.getId());
                this.store(nstate);
            }
            this.stateMgr.store(state);
        }
    }

    public void reload() throws RepositoryException {
        try {
            this.reload(this.nodeState);
            this.nodeState = (NodeState)this.stateMgr.getItemState(this.nodeState.getNodeId());
        }
        catch (ItemStateException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void reload(NodeState state) throws ItemStateException {
        if (state.getStatus() != 1) {
            Set props = state.getPropertyNames();
            Iterator iter = props.iterator();
            while (iter.hasNext()) {
                Name propName = (Name)iter.next();
                PropertyState pstate = (PropertyState)this.stateMgr.getItemState(new PropertyId(state.getNodeId(), propName));
                if (pstate.getStatus() == 1) continue;
                pstate.discard();
            }
            List nodes = state.getChildNodeEntries();
            for (int i = 0; i < nodes.size(); ++i) {
                ChildNodeEntry entry = (ChildNodeEntry)nodes.get(i);
                NodeState nstate = (NodeState)this.stateMgr.getItemState(entry.getId());
                this.reload(nstate);
            }
            state.discard();
        }
    }

    public void copyFrom(PropertyImpl prop) throws RepositoryException {
        if (prop.getDefinition().isMultiple()) {
            InternalValue[] values = prop.internalGetValues();
            InternalValue[] copiedValues = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                copiedValues[i] = values[i].createCopy();
            }
            this.setPropertyValues(prop.getQName(), prop.getType(), copiedValues);
        } else {
            this.setPropertyValue(prop.getQName(), prop.internalGetValue().createCopy());
        }
    }
}

