/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.util.name;

import java.util.Iterator;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.util.name.NamespaceMapping;

public class NamespaceAdder {
    private final NamespaceRegistry registry;

    public NamespaceAdder(NamespaceRegistry nsr) {
        this.registry = nsr;
    }

    public void addNamespaces(NamespaceMapping nsm) throws NamespaceException, UnsupportedRepositoryOperationException, RepositoryException {
        Map m = nsm.getPrefixToURIMapping();
        Iterator i = m.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            String prefix = (String)e.getKey();
            String uri = (String)e.getValue();
            this.registry.registerNamespace(prefix, uri);
        }
    }

    public void addNamespace(String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, RepositoryException {
        this.registry.registerNamespace(prefix, uri);
    }
}

