/*
 * Decompiled with CFR 0.152.
 */
package generic.util;

import ghidra.util.exception.AssertException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ArchiveBuilder {
    private ZipOutputStream zipOut;

    ArchiveBuilder(ZipOutputStream zos) {
        this.zipOut = zos;
    }

    public void close() throws IOException {
        this.zipOut.close();
    }

    public void addFile(String path, File file) throws IOException {
        int numRead;
        if (!file.isFile()) {
            throw new AssertException("Attempted to write a directory to the jar file");
        }
        long modifiedTime = file.lastModified();
        ZipEntry entry = new ZipEntry(path);
        entry.setTime(modifiedTime);
        this.zipOut.putNextEntry(entry);
        FileInputStream in = new FileInputStream(file);
        byte[] bytes = new byte[4096];
        while ((numRead = ((InputStream)in).read(bytes)) != -1) {
            this.zipOut.write(bytes, 0, numRead);
        }
        ((InputStream)in).close();
        this.zipOut.closeEntry();
    }

    public void createFile(String path, List<String> lines) throws IOException {
        ZipEntry entry = new ZipEntry(path);
        this.zipOut.putNextEntry(entry);
        for (String line : lines) {
            this.zipOut.write(line.getBytes());
            this.zipOut.write(10);
        }
        this.zipOut.closeEntry();
    }
}

