/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.Generator;
import json.ext.OptionsReader;
import json.ext.RuntimeInfo;
import json.ext.Utils;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class GeneratorState
extends RubyObject {
    private ByteList indent = ByteList.EMPTY_BYTELIST;
    private ByteList space = ByteList.EMPTY_BYTELIST;
    private ByteList spaceBefore = ByteList.EMPTY_BYTELIST;
    private ByteList objectNl = ByteList.EMPTY_BYTELIST;
    private ByteList arrayNl = ByteList.EMPTY_BYTELIST;
    private int maxNesting = 100;
    static final int DEFAULT_MAX_NESTING = 100;
    private boolean allowNaN = false;
    static final boolean DEFAULT_ALLOW_NAN = false;
    private boolean asciiOnly = false;
    static final boolean DEFAULT_ASCII_ONLY = false;
    private boolean quirksMode = false;
    static final boolean DEFAULT_QUIRKS_MODE = false;
    private int bufferInitialLength = 1024;
    static final int DEFAULT_BUFFER_INITIAL_LENGTH = 1024;
    private int depth = 0;
    static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new GeneratorState(ruby, rubyClass);
        }
    };

    public GeneratorState(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject from_state(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return GeneratorState.fromState(threadContext, iRubyObject2);
    }

    static GeneratorState fromState(ThreadContext threadContext, IRubyObject iRubyObject) {
        return GeneratorState.fromState(threadContext, RuntimeInfo.forRuntime(threadContext.getRuntime()), iRubyObject);
    }

    static GeneratorState fromState(ThreadContext threadContext, RuntimeInfo runtimeInfo, IRubyObject iRubyObject) {
        RubyClass rubyClass = (RubyClass)runtimeInfo.generatorStateClass.get();
        if (iRubyObject != null) {
            if (rubyClass.isInstance(iRubyObject)) {
                return (GeneratorState)iRubyObject;
            }
            if (threadContext.getRuntime().getHash().isInstance(iRubyObject)) {
                return (GeneratorState)rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject}, Block.NULL_BLOCK);
            }
        }
        return (GeneratorState)runtimeInfo.getSafeStatePrototype(threadContext).dup();
    }

    @JRubyMethod(optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        this.configure(threadContext, iRubyObjectArray.length > 0 ? iRubyObjectArray[0] : null);
        return this;
    }

    @JRubyMethod
    public IRubyObject initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.getRuntime();
        if (!(iRubyObject instanceof GeneratorState)) {
            throw ruby.newTypeError(iRubyObject, this.getType());
        }
        GeneratorState generatorState = (GeneratorState)iRubyObject;
        this.indent = generatorState.indent;
        this.space = generatorState.space;
        this.spaceBefore = generatorState.spaceBefore;
        this.objectNl = generatorState.objectNl;
        this.arrayNl = generatorState.arrayNl;
        this.maxNesting = generatorState.maxNesting;
        this.allowNaN = generatorState.allowNaN;
        this.asciiOnly = generatorState.asciiOnly;
        this.quirksMode = generatorState.quirksMode;
        this.bufferInitialLength = generatorState.bufferInitialLength;
        this.depth = generatorState.depth;
        return this;
    }

    @JRubyMethod
    public IRubyObject generate(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString = Generator.generateJson(threadContext, iRubyObject, this);
        RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.getRuntime());
        rubyString.force_encoding(threadContext, (IRubyObject)runtimeInfo.utf8.get());
        return rubyString;
    }

    private static boolean matchClosingBrace(ByteList byteList, int n, int n2, int n3) {
        for (int i = n2 - 1; i > n; --i) {
            int n4 = byteList.get(i);
            if (Character.isWhitespace(n4)) continue;
            return n4 == n3;
        }
        return false;
    }

    @JRubyMethod(name={"[]"}, required=1)
    public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
        String string = iRubyObject.asJavaString();
        if (this.getMetaClass().isMethodBound(string, true)) {
            return this.send(threadContext, iRubyObject, Block.NULL_BLOCK);
        }
        IRubyObject iRubyObject2 = this.getInstanceVariables().getInstanceVariable("@" + string);
        return iRubyObject2 == null ? threadContext.nil : iRubyObject2;
    }

    @JRubyMethod(name={"[]="}, required=2)
    public IRubyObject op_aset(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string = iRubyObject.asJavaString();
        String string2 = string + "=";
        if (this.getMetaClass().isMethodBound(string2, true)) {
            return this.send(threadContext, (IRubyObject)threadContext.getRuntime().newString(string2), iRubyObject2, Block.NULL_BLOCK);
        }
        this.getInstanceVariables().setInstanceVariable("@" + string, iRubyObject2);
        return threadContext.getRuntime().getNil();
    }

    public ByteList getIndent() {
        return this.indent;
    }

    @JRubyMethod(name={"indent"})
    public RubyString indent_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newString(this.indent);
    }

    @JRubyMethod(name={"indent="})
    public IRubyObject indent_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.indent = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getSpace() {
        return this.space;
    }

    @JRubyMethod(name={"space"})
    public RubyString space_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newString(this.space);
    }

    @JRubyMethod(name={"space="})
    public IRubyObject space_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.space = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getSpaceBefore() {
        return this.spaceBefore;
    }

    @JRubyMethod(name={"space_before"})
    public RubyString space_before_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newString(this.spaceBefore);
    }

    @JRubyMethod(name={"space_before="})
    public IRubyObject space_before_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.spaceBefore = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getObjectNl() {
        return this.objectNl;
    }

    @JRubyMethod(name={"object_nl"})
    public RubyString object_nl_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newString(this.objectNl);
    }

    @JRubyMethod(name={"object_nl="})
    public IRubyObject object_nl_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.objectNl = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    public ByteList getArrayNl() {
        return this.arrayNl;
    }

    @JRubyMethod(name={"array_nl"})
    public RubyString array_nl_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newString(this.arrayNl);
    }

    @JRubyMethod(name={"array_nl="})
    public IRubyObject array_nl_set(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.arrayNl = this.prepareByteList(threadContext, iRubyObject);
        return iRubyObject;
    }

    @JRubyMethod(name={"check_circular?"})
    public RubyBoolean check_circular_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.maxNesting != 0);
    }

    public int getMaxNesting() {
        return this.maxNesting;
    }

    @JRubyMethod(name={"max_nesting"})
    public RubyInteger max_nesting_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.maxNesting);
    }

    @JRubyMethod(name={"max_nesting="})
    public IRubyObject max_nesting_set(IRubyObject iRubyObject) {
        this.maxNesting = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        return iRubyObject;
    }

    public boolean allowNaN() {
        return this.allowNaN;
    }

    @JRubyMethod(name={"allow_nan?"})
    public RubyBoolean allow_nan_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.allowNaN);
    }

    public boolean asciiOnly() {
        return this.asciiOnly;
    }

    @JRubyMethod(name={"ascii_only?"})
    public RubyBoolean ascii_only_p(ThreadContext threadContext) {
        return threadContext.getRuntime().newBoolean(this.asciiOnly);
    }

    @JRubyMethod(name={"buffer_initial_length"})
    public RubyInteger buffer_initial_length_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.bufferInitialLength);
    }

    @JRubyMethod(name={"buffer_initial_length="})
    public IRubyObject buffer_initial_length_set(IRubyObject iRubyObject) {
        int n = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        if (n > 0) {
            this.bufferInitialLength = n;
        }
        return iRubyObject;
    }

    public int getDepth() {
        return this.depth;
    }

    @JRubyMethod(name={"depth"})
    public RubyInteger depth_get(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.depth);
    }

    @JRubyMethod(name={"depth="})
    public IRubyObject depth_set(IRubyObject iRubyObject) {
        this.depth = RubyNumeric.fix2int((IRubyObject)iRubyObject);
        return iRubyObject;
    }

    private ByteList prepareByteList(ThreadContext threadContext, IRubyObject iRubyObject) {
        RubyString rubyString = iRubyObject.convertToString();
        RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.getRuntime());
        if (rubyString.encoding(threadContext) != runtimeInfo.utf8.get()) {
            rubyString = (RubyString)rubyString.encode(threadContext, (IRubyObject)runtimeInfo.utf8.get());
        }
        return rubyString.getByteList().dup();
    }

    @JRubyMethod(alias={"merge"})
    public IRubyObject configure(ThreadContext threadContext, IRubyObject iRubyObject) {
        ByteList byteList;
        ByteList byteList2;
        ByteList byteList3;
        ByteList byteList4;
        OptionsReader optionsReader = new OptionsReader(threadContext, iRubyObject);
        ByteList byteList5 = optionsReader.getString("indent");
        if (byteList5 != null) {
            this.indent = byteList5;
        }
        if ((byteList4 = optionsReader.getString("space")) != null) {
            this.space = byteList4;
        }
        if ((byteList3 = optionsReader.getString("space_before")) != null) {
            this.spaceBefore = byteList3;
        }
        if ((byteList2 = optionsReader.getString("array_nl")) != null) {
            this.arrayNl = byteList2;
        }
        if ((byteList = optionsReader.getString("object_nl")) != null) {
            this.objectNl = byteList;
        }
        this.maxNesting = optionsReader.getInt("max_nesting", 100);
        this.allowNaN = optionsReader.getBool("allow_nan", false);
        this.asciiOnly = optionsReader.getBool("ascii_only", false);
        this.bufferInitialLength = optionsReader.getInt("buffer_initial_length", 1024);
        this.depth = optionsReader.getInt("depth", 0);
        return this;
    }

    @JRubyMethod(alias={"to_hash"})
    public RubyHash to_h(ThreadContext threadContext) {
        Ruby ruby = threadContext.getRuntime();
        RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("indent"), (IRubyObject)this.indent_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("space"), (IRubyObject)this.space_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("space_before"), (IRubyObject)this.space_before_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("object_nl"), (IRubyObject)this.object_nl_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("array_nl"), (IRubyObject)this.array_nl_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("allow_nan"), (IRubyObject)this.allow_nan_p(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("ascii_only"), (IRubyObject)this.ascii_only_p(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("max_nesting"), (IRubyObject)this.max_nesting_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("depth"), (IRubyObject)this.depth_get(threadContext));
        rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol("buffer_initial_length"), (IRubyObject)this.buffer_initial_length_get(threadContext));
        for (String string : this.getInstanceVariableNameList()) {
            rubyHash.op_aset(threadContext, (IRubyObject)ruby.newSymbol(string.substring(1)), this.getInstanceVariables().getInstanceVariable(string));
        }
        return rubyHash;
    }

    public int increaseDepth() {
        ++this.depth;
        this.checkMaxNesting();
        return this.depth;
    }

    public int decreaseDepth() {
        return --this.depth;
    }

    private void checkMaxNesting() {
        if (this.maxNesting != 0 && this.depth > this.maxNesting) {
            --this.depth;
            throw Utils.newException(this.getRuntime().getCurrentContext(), "NestingError", "nesting of " + this.depth + " is too deep");
        }
    }
}

