function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import React, { useState, useEffect, useRef } from 'react';
import { KibanaContextProvider } from '../../../../kibana_react/public';
import { SearchBar } from './search_bar';
import { useFilterManager } from './lib/use_filter_manager';
import { useTimefilter } from './lib/use_timefilter';
import { useSavedQuery } from './lib/use_saved_query';
import { UI_SETTINGS } from '../../../common';

// Respond to user changing the filters
var defaultFiltersUpdated = function defaultFiltersUpdated(queryService) {
  return function (filters) {
    queryService.filterManager.setFilters(filters);
  };
}; // Respond to user changing the refresh settings


var defaultOnRefreshChange = function defaultOnRefreshChange(queryService) {
  var timefilter = queryService.timefilter.timefilter;
  return function (options) {
    timefilter.setRefreshInterval({
      value: options.refreshInterval,
      pause: options.isPaused
    });
  };
}; // Respond to user changing the query string or time settings


var defaultOnQuerySubmit = function defaultOnQuerySubmit(props, queryService, currentQuery, setQueryStringState) {
  if (!props.useDefaultBehaviors) return props.onQuerySubmit;
  var timefilter = queryService.timefilter.timefilter;
  return function (payload) {
    var isUpdate = !_.isEqual(timefilter.getTime(), payload.dateRange) || !_.isEqual(payload.query, currentQuery);

    if (isUpdate) {
      timefilter.setTime(payload.dateRange);
      setQueryStringState(payload.query);
    } else {
      // Refresh button triggered for an update
      if (props.onQuerySubmit) props.onQuerySubmit({
        dateRange: timefilter.getTime(),
        query: currentQuery
      }, false);
    }
  };
}; // Respond to user clearing a saved query


var defaultOnClearSavedQuery = function defaultOnClearSavedQuery(props, clearSavedQuery) {
  if (!props.useDefaultBehaviors) return props.onClearSavedQuery;
  return function () {
    clearSavedQuery();
    if (props.onSavedQueryIdChange) props.onSavedQueryIdChange();
  };
}; // Respond to user saving or updating a saved query


var defaultOnSavedQueryUpdated = function defaultOnSavedQueryUpdated(props, setSavedQuery) {
  if (!props.useDefaultBehaviors) return props.onSavedQueryUpdated;
  return function (savedQuery) {
    setSavedQuery(savedQuery);
    if (props.onSavedQueryIdChange) props.onSavedQueryIdChange(savedQuery.id);
  };
};

var overrideDefaultBehaviors = function overrideDefaultBehaviors(props) {
  return props.useDefaultBehaviors ? {} : props;
};

export function createSearchBar(_ref) {
  var core = _ref.core,
      storage = _ref.storage,
      data = _ref.data;
  // App name should come from the core application service.
  // Until it's available, we'll ask the user to provide it for the pre-wired component.
  return function (props) {
    var useDefaultBehaviors = props.useDefaultBehaviors; // Handle queries

    var queryRef = useRef(props.query);
    var onQuerySubmitRef = useRef(props.onQuerySubmit);
    var defaultQuery = {
      query: '',
      language: storage.get('kibana.userQueryLanguage') || core.uiSettings.get(UI_SETTINGS.SEARCH_QUERY_LANGUAGE)
    };

    var _useState = useState(props.query || defaultQuery),
        _useState2 = _slicedToArray(_useState, 2),
        query = _useState2[0],
        setQuery = _useState2[1];

    useEffect(function () {
      if (props.query !== queryRef.current) {
        queryRef.current = props.query;
        setQuery(props.query || defaultQuery);
      }
      /* eslint-disable-next-line react-hooks/exhaustive-deps */

    }, [defaultQuery, props.query]);
    useEffect(function () {
      if (props.onQuerySubmit !== onQuerySubmitRef.current) {
        onQuerySubmitRef.current = props.onQuerySubmit;
      }
      /* eslint-disable-next-line react-hooks/exhaustive-deps */

    }, [props.onQuerySubmit]); // handle service state updates.
    // i.e. filters being added from a visualization directly to filterManager.

    var _useFilterManager = useFilterManager({
      filters: props.filters,
      filterManager: data.query.filterManager
    }),
        filters = _useFilterManager.filters;

    var _useTimefilter = useTimefilter({
      dateRangeFrom: props.dateRangeFrom,
      dateRangeTo: props.dateRangeTo,
      refreshInterval: props.refreshInterval,
      isRefreshPaused: props.isRefreshPaused,
      timefilter: data.query.timefilter.timefilter
    }),
        timeRange = _useTimefilter.timeRange,
        refreshInterval = _useTimefilter.refreshInterval; // Fetch and update UI from saved query


    var _useSavedQuery = useSavedQuery({
      queryService: data.query,
      setQuery: setQuery,
      savedQueryId: props.savedQueryId,
      notifications: core.notifications,
      defaultLanguage: defaultQuery.language
    }),
        savedQuery = _useSavedQuery.savedQuery,
        setSavedQuery = _useSavedQuery.setSavedQuery,
        clearSavedQuery = _useSavedQuery.clearSavedQuery; // Fire onQuerySubmit on query or timerange change


    useEffect(function () {
      if (!useDefaultBehaviors || !onQuerySubmitRef.current) return;
      onQuerySubmitRef.current({
        dateRange: timeRange,
        query: query
      }, true);
    }, [query, timeRange, useDefaultBehaviors]);
    return /*#__PURE__*/React.createElement(KibanaContextProvider, {
      services: _objectSpread({
        appName: props.appName,
        data: data,
        storage: storage
      }, core)
    }, /*#__PURE__*/React.createElement(SearchBar, _extends({
      showAutoRefreshOnly: props.showAutoRefreshOnly,
      showDatePicker: props.showDatePicker,
      showFilterBar: props.showFilterBar,
      showQueryBar: props.showQueryBar,
      showQueryInput: props.showQueryInput,
      showSaveQuery: props.showSaveQuery,
      screenTitle: props.screenTitle,
      indexPatterns: props.indexPatterns,
      indicateNoData: props.indicateNoData,
      timeHistory: data.query.timefilter.history,
      dateRangeFrom: timeRange.from,
      dateRangeTo: timeRange.to,
      refreshInterval: refreshInterval.value,
      isRefreshPaused: refreshInterval.pause,
      filters: filters,
      query: query,
      onFiltersUpdated: defaultFiltersUpdated(data.query),
      onRefreshChange: defaultOnRefreshChange(data.query),
      savedQuery: savedQuery,
      onQuerySubmit: defaultOnQuerySubmit(props, data.query, query, setQuery),
      onClearSavedQuery: defaultOnClearSavedQuery(props, clearSavedQuery),
      onSavedQueryUpdated: defaultOnSavedQueryUpdated(props, setSavedQuery),
      onSaved: defaultOnSavedQueryUpdated(props, setSavedQuery)
    }, overrideDefaultBehaviors(props))));
  };
}