"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findAll = findAll;

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
async function findAll(savedObjectsClient, opts) {
  const {
    page = 1,
    perPage = 10000,
    ...options
  } = opts;
  const {
    saved_objects: savedObjects,
    total
  } = await savedObjectsClient.find({ ...options,
    page,
    perPage
  });

  if (page * perPage >= total) {
    return savedObjects;
  }

  return [...savedObjects, ...(await findAll(savedObjectsClient, { ...opts,
    page: page + 1
  }))];
}