function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as Rx from 'rxjs';
import moment from 'moment';
import { i18n } from '@kbn/i18n';
import { catchError, filter, mergeMap, tap } from 'rxjs/operators';
import { NEWSFEED_FALLBACK_LANGUAGE, NEWSFEED_LAST_FETCH_STORAGE_KEY, NEWSFEED_HASH_SET_STORAGE_KEY } from '../../common/constants';
export var NewsfeedApiDriver = /*#__PURE__*/function () {
  // the date is compared to time in UTC format coming from the service
  function NewsfeedApiDriver(kibanaVersion, userLanguage, fetchInterval) {
    _classCallCheck(this, NewsfeedApiDriver);

    this.kibanaVersion = kibanaVersion;
    this.userLanguage = userLanguage;
    this.fetchInterval = fetchInterval;

    _defineProperty(this, "loadedTime", moment().utc());
  }

  _createClass(NewsfeedApiDriver, [{
    key: "shouldFetch",
    value: function shouldFetch() {
      var lastFetchUtc = sessionStorage.getItem(NEWSFEED_LAST_FETCH_STORAGE_KEY);

      if (lastFetchUtc == null) {
        return true;
      }

      var last = moment(lastFetchUtc, 'x'); // parse as unix ms timestamp (already is UTC)
      // does the last fetch time precede the time that the page was loaded?

      if (this.loadedTime.diff(last) > 0) {
        return true;
      }

      var now = moment.utc(); // always use UTC to compare timestamps that came from the service

      var duration = moment.duration(now.diff(last));
      return duration.asMilliseconds() > this.fetchInterval;
    }
  }, {
    key: "updateLastFetch",
    value: function updateLastFetch() {
      sessionStorage.setItem(NEWSFEED_LAST_FETCH_STORAGE_KEY, Date.now().toString());
    }
  }, {
    key: "updateHashes",
    value: function updateHashes(items) {
      // replace localStorage hashes with new hashes
      var stored = localStorage.getItem(NEWSFEED_HASH_SET_STORAGE_KEY);
      var old = [];

      if (stored != null) {
        old = stored.split(',');
      }

      var newHashes = items.map(function (i) {
        return i.hash;
      });

      var updatedHashes = _toConsumableArray(new Set(old.concat(newHashes)));

      localStorage.setItem(NEWSFEED_HASH_SET_STORAGE_KEY, updatedHashes.join(','));
      return {
        previous: old,
        current: updatedHashes
      };
    }
  }, {
    key: "fetchNewsfeedItems",
    value: function fetchNewsfeedItems(http, config) {
      var _this = this;

      var urlPath = config.pathTemplate.replace('{VERSION}', this.kibanaVersion);
      var fullUrl = config.urlRoot + urlPath;
      return Rx.from(http.fetch(fullUrl, {
        method: 'GET'
      }).then(function (_ref) {
        var items = _ref.items;
        return _this.modelItems(items);
      }));
    }
  }, {
    key: "validateItem",
    value: function validateItem(item) {
      var hasMissing = [item.title, item.description, item.linkText, item.linkUrl, item.publishOn, item.hash].includes(undefined);
      return !hasMissing;
    }
  }, {
    key: "modelItems",
    value: function modelItems(items) {
      var _this2 = this;

      var feedItems = items.reduce(function (accum, it) {
        var chosenLanguage = _this2.userLanguage;
        var expireOnUtc = it.expire_on,
            publishOnUtc = it.publish_on,
            languages = it.languages,
            title = it.title,
            description = it.description,
            linkText = it.link_text,
            linkUrl = it.link_url,
            badge = it.badge,
            hash = it.hash;

        if (moment(expireOnUtc).isBefore(Date.now())) {
          return accum; // ignore item if expired
        }

        if (moment(publishOnUtc).isAfter(Date.now())) {
          return accum; // ignore item if publish date hasn't occurred yet (pre-published)
        }

        if (languages && !languages.includes(chosenLanguage)) {
          chosenLanguage = NEWSFEED_FALLBACK_LANGUAGE; // don't remove the item: fallback on a language
        }

        var tempItem = {
          title: title[chosenLanguage],
          description: description[chosenLanguage],
          linkText: linkText[chosenLanguage],
          linkUrl: linkUrl[chosenLanguage],
          badge: badge != null ? badge[chosenLanguage] : null,
          publishOn: moment(publishOnUtc),
          expireOn: moment(expireOnUtc),
          hash: hash.slice(0, 10) // optimize for storage and faster parsing

        };

        if (!_this2.validateItem(tempItem)) {
          return accum; // ignore if title, description, etc is missing
        }

        return [].concat(_toConsumableArray(accum), [tempItem]);
      }, []); // calculate hasNew

      var _this$updateHashes = this.updateHashes(feedItems),
          previous = _this$updateHashes.previous,
          current = _this$updateHashes.current;

      var hasNew = current.length > previous.length;
      return {
        error: null,
        kibanaVersion: this.kibanaVersion,
        hasNew: hasNew,
        feedItems: feedItems
      };
    }
  }]);

  return NewsfeedApiDriver;
}();
/*
 * Creates an Observable to newsfeed items, powered by the main interval
 * Computes hasNew value from new item hashes saved in localStorage
 */

export function getApi(http, config, kibanaVersion) {
  var userLanguage = i18n.getLocale();
  var fetchInterval = config.fetchInterval.asMilliseconds();
  var driver = new NewsfeedApiDriver(kibanaVersion, userLanguage, fetchInterval);
  return Rx.timer(0, config.mainInterval.asMilliseconds()).pipe(filter(function () {
    return driver.shouldFetch();
  }), mergeMap(function () {
    return driver.fetchNewsfeedItems(http, config.service).pipe(catchError(function (err) {
      window.console.error(err);
      return Rx.of({
        error: err,
        kibanaVersion: kibanaVersion,
        hasNew: false,
        feedItems: []
      });
    }));
  }), tap(function () {
    return driver.updateLastFetch();
  }));
}