function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { modifyUrl } from '../../utils';
export var BasePath = function BasePath() {
  var _this = this;

  var basePath = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var serverBasePath = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : basePath;

  _classCallCheck(this, BasePath);

  this.basePath = basePath;
  this.serverBasePath = serverBasePath;

  _defineProperty(this, "get", function () {
    return _this.basePath;
  });

  _defineProperty(this, "prepend", function (path) {
    if (!_this.basePath) return path;
    return modifyUrl(path, function (parts) {
      if (!parts.hostname && parts.pathname && parts.pathname.startsWith('/')) {
        parts.pathname = "".concat(_this.basePath).concat(parts.pathname);
      }
    });
  });

  _defineProperty(this, "remove", function (path) {
    if (!_this.basePath) {
      return path;
    }

    if (path === _this.basePath) {
      return '/';
    }

    if (path.startsWith("".concat(_this.basePath, "/"))) {
      return path.slice(_this.basePath.length);
    }

    return path;
  });
};