function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/* eslint-disable max-classes-per-file */
import { i18n as t } from '@kbn/i18n';
import { EuiModal, EuiConfirmModal, EuiOverlayMask } from '@elastic/eui';
import React from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { Subject } from 'rxjs';
import { MountWrapper } from '../../utils';
/**
 * A ModalRef is a reference to an opened modal. It offers methods to
 * close the modal.
 *
 * @public
 */

var ModalRef = /*#__PURE__*/function () {
  function ModalRef() {
    _classCallCheck(this, ModalRef);

    _defineProperty(this, "onClose", void 0);

    _defineProperty(this, "closeSubject", new Subject());

    this.onClose = this.closeSubject.toPromise();
  }
  /**
   * Closes the referenced modal if it's still open which in turn will
   * resolve the `onClose` Promise. If the modal had already been
   * closed this method does nothing.
   */


  _createClass(ModalRef, [{
    key: "close",
    value: function close() {
      if (!this.closeSubject.closed) {
        this.closeSubject.next();
        this.closeSubject.complete();
      }

      return this.onClose;
    }
  }]);

  return ModalRef;
}();
/**
 * @public
 */


/** @internal */
export var ModalService = /*#__PURE__*/function () {
  function ModalService() {
    _classCallCheck(this, ModalService);

    _defineProperty(this, "activeModal", null);

    _defineProperty(this, "targetDomElement", null);
  }

  _createClass(ModalService, [{
    key: "start",
    value: function start(_ref) {
      var _this = this;

      var i18n = _ref.i18n,
          targetDomElement = _ref.targetDomElement;
      this.targetDomElement = targetDomElement;
      return {
        open: function open(mount) {
          var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

          // If there is an active modal, close it before opening a new one.
          if (_this.activeModal) {
            _this.activeModal.close();

            _this.cleanupDom();
          }

          var modal = new ModalRef(); // If a modal gets closed through it's ModalRef, remove it from the dom

          modal.onClose.then(function () {
            if (_this.activeModal === modal) {
              _this.cleanupDom();
            }
          });
          _this.activeModal = modal;
          render( /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(i18n.Context, null, /*#__PURE__*/React.createElement(EuiModal, _extends({}, options, {
            onClose: function onClose() {
              return modal.close();
            }
          }), /*#__PURE__*/React.createElement(MountWrapper, {
            mount: mount,
            className: "kbnOverlayMountWrapper"
          })))), targetDomElement);
          return modal;
        },
        openConfirm: function openConfirm(message, options) {
          // If there is an active modal, close it before opening a new one.
          if (_this.activeModal) {
            _this.activeModal.close();

            _this.cleanupDom();
          }

          return new Promise(function (resolve, reject) {
            var resolved = false;

            var closeModal = function closeModal(confirmed) {
              resolved = true;
              modal.close();
              resolve(confirmed);
            };

            var modal = new ModalRef();
            modal.onClose.then(function () {
              if (_this.activeModal === modal) {
                _this.cleanupDom();
              } // modal.close can be called when opening a new modal/confirm, so we need to resolve the promise in that case.


              if (!resolved) {
                closeModal(false);
              }
            });
            _this.activeModal = modal;

            var props = _objectSpread(_objectSpread({}, options), {}, {
              children: typeof message === 'string' ? message : /*#__PURE__*/React.createElement(MountWrapper, {
                mount: message,
                className: "kbnOverlayMountWrapper"
              }),
              onCancel: function onCancel() {
                return closeModal(false);
              },
              onConfirm: function onConfirm() {
                return closeModal(true);
              },
              cancelButtonText: (options === null || options === void 0 ? void 0 : options.cancelButtonText) || t.translate('core.overlays.confirm.cancelButton', {
                defaultMessage: 'Cancel'
              }),
              confirmButtonText: (options === null || options === void 0 ? void 0 : options.confirmButtonText) || t.translate('core.overlays.confirm.okButton', {
                defaultMessage: 'Confirm'
              })
            });

            render( /*#__PURE__*/React.createElement(EuiOverlayMask, null, /*#__PURE__*/React.createElement(i18n.Context, null, /*#__PURE__*/React.createElement(EuiConfirmModal, props))), targetDomElement);
          });
        }
      };
    }
    /**
     * Using React.Render to re-render into a target DOM element will replace
     * the content of the target but won't call unmountComponent on any
     * components inside the target or any of their children. So we properly
     * cleanup the DOM here to prevent subtle bugs in child components which
     * depend on unmounting for cleanup behaviour.
     */

  }, {
    key: "cleanupDom",
    value: function cleanupDom() {
      if (this.targetDomElement != null) {
        unmountComponentAtNode(this.targetDomElement);
        this.targetDomElement.innerHTML = '';
      }

      this.activeModal = null;
    }
  }]);

  return ModalService;
}();